/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectId;
import java.io.Serializable;
import java.util.Map;

public class EncryptedGetObjectRequest
extends GetObjectRequest
implements Serializable {
    private ExtraMaterialsDescription supplemental = ExtraMaterialsDescription.NONE;
    private String instructionFileSuffix;
    private boolean keyWrapExpected;

    public EncryptedGetObjectRequest(String string, String string2) {
        this(string, string2, null);
    }

    public EncryptedGetObjectRequest(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setKey(string2);
        this.setVersionId(string3);
    }

    public EncryptedGetObjectRequest(S3ObjectId s3ObjectId) {
        super(s3ObjectId);
    }

    public EncryptedGetObjectRequest(String string, String string2, boolean bl) {
        super(string, string2, bl);
    }

    @Override
    @Deprecated
    public EncryptedGetObjectRequest withRange(long l, long l2) {
        super.withRange(l, l2);
        return this;
    }

    @Override
    @Deprecated
    public void setRange(long l, long l2) {
        super.setRange(l, l2);
    }

    @Override
    @Deprecated
    public EncryptedGetObjectRequest withRange(long l) {
        super.withRange(l);
        return this;
    }

    @Override
    @Deprecated
    public void setRange(long l) {
        super.setRange(l);
    }

    @Override
    @Deprecated
    public long[] getRange() {
        return super.getRange();
    }

    @Override
    @Deprecated
    public EncryptedGetObjectRequest withPartNumber(Integer n) {
        super.withPartNumber(n);
        return this;
    }

    @Override
    @Deprecated
    public void setPartNumber(Integer n) {
        super.setPartNumber(n);
    }

    @Override
    @Deprecated
    public Integer getPartNumber() {
        return super.getPartNumber();
    }

    public ExtraMaterialsDescription getExtraMaterialDescription() {
        return this.supplemental;
    }

    public void setExtraMaterialDescription(ExtraMaterialsDescription extraMaterialsDescription) {
        this.supplemental = extraMaterialsDescription == null ? ExtraMaterialsDescription.NONE : extraMaterialsDescription;
    }

    public EncryptedGetObjectRequest withExtraMaterialsDescription(ExtraMaterialsDescription extraMaterialsDescription) {
        this.setExtraMaterialDescription(extraMaterialsDescription);
        return this;
    }

    public EncryptedGetObjectRequest withExtraMaterialsDescription(Map<String, String> map) {
        this.setExtraMaterialDescription(map == null ? null : new ExtraMaterialsDescription(map));
        return this;
    }

    public String getInstructionFileSuffix() {
        return this.instructionFileSuffix;
    }

    public void setInstructionFileSuffix(String string) {
        this.instructionFileSuffix = string;
    }

    public EncryptedGetObjectRequest withInstructionFileSuffix(String string) {
        this.instructionFileSuffix = string;
        return this;
    }

    public boolean isKeyWrapExpected() {
        return this.keyWrapExpected;
    }

    public void setKeyWrapExpected(boolean bl) {
        this.keyWrapExpected = bl;
    }

    public EncryptedGetObjectRequest withKeyWrapExpected(boolean bl) {
        this.keyWrapExpected = bl;
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EncryptedGetObjectRequest)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        EncryptedGetObjectRequest encryptedGetObjectRequest = (EncryptedGetObjectRequest)object;
        if (this.keyWrapExpected != encryptedGetObjectRequest.isKeyWrapExpected()) {
            return false;
        }
        if (this.supplemental != null ? !this.supplemental.equals(encryptedGetObjectRequest.supplemental) : encryptedGetObjectRequest.supplemental != null) {
            return false;
        }
        return this.getInstructionFileSuffix() != null ? this.getInstructionFileSuffix().equals(encryptedGetObjectRequest.getInstructionFileSuffix()) : encryptedGetObjectRequest.getInstructionFileSuffix() == null;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.supplemental != null ? this.supplemental.hashCode() : 0);
        n2 = n * n2 + (this.getInstructionFileSuffix() != null ? this.getInstructionFileSuffix().hashCode() : 0);
        n2 = n * n2 + (this.isKeyWrapExpected() ? 1 : 0);
        return n2;
    }
}

