/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v2;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

class S3ObjectWrapper
implements Closeable {
    private final S3Object s3obj;
    private final S3ObjectId id;

    S3ObjectWrapper(S3Object s3Object, S3ObjectId s3ObjectId) {
        if (s3Object == null) {
            throw new IllegalArgumentException();
        }
        this.s3obj = s3Object;
        this.id = s3ObjectId;
    }

    public S3ObjectId getS3ObjectId() {
        return this.id;
    }

    ObjectMetadata getObjectMetadata() {
        return this.s3obj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.s3obj.setObjectMetadata(objectMetadata);
    }

    S3ObjectInputStream getObjectContent() {
        return this.s3obj.getObjectContent();
    }

    void setObjectContent(S3ObjectInputStream s3ObjectInputStream) {
        this.s3obj.setObjectContent(s3ObjectInputStream);
    }

    void setObjectContent(InputStream inputStream2) {
        this.s3obj.setObjectContent(inputStream2);
    }

    String getBucketName() {
        return this.s3obj.getBucketName();
    }

    void setBucketName(String string) {
        this.s3obj.setBucketName(string);
    }

    String getKey() {
        return this.s3obj.getKey();
    }

    void setKey(String string) {
        this.s3obj.setKey(string);
    }

    String getRedirectLocation() {
        return this.s3obj.getRedirectLocation();
    }

    void setRedirectLocation(String string) {
        this.s3obj.setRedirectLocation(string);
    }

    public String toString() {
        return this.s3obj.toString();
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata objectMetadata = this.s3obj.getObjectMetadata();
        Map<String, String> map = objectMetadata.getUserMetadata();
        return map != null && map.containsKey("x-amz-iv") && (map.containsKey("x-amz-key-v2") || map.containsKey("x-amz-key"));
    }

    String toJsonString() {
        try {
            return S3ObjectWrapper.from(this.s3obj.getObjectContent());
        }
        catch (Exception exception) {
            throw new SdkClientException("Error parsing JSON: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream2.close();
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        this.s3obj.close();
    }

    S3Object getS3Object() {
        return this.s3obj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> map) {
        if (map != null) {
            String string = map.get("x-amz-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(string);
        }
        ObjectMetadata objectMetadata = this.s3obj.getObjectMetadata();
        Map<String, String> map2 = objectMetadata.getUserMetadata();
        String string = map2.get("x-amz-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(string);
    }
}

