/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v2;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.AdjustedRangeInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import com.amazonaws.services.s3.internal.crypto.v2.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.v2.MultipartUploadCryptoContext;
import com.amazonaws.services.s3.internal.crypto.v2.S3CryptoModuleBase;
import com.amazonaws.services.s3.internal.crypto.v2.S3ObjectWrapper;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoRangeGetMode;
import com.amazonaws.services.s3.model.EncryptedGetObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class S3CryptoModuleAE
extends S3CryptoModuleBase<MultipartUploadCryptoContext> {
    public S3CryptoModuleAE(AWSKMS aWSKMS, S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfigurationV2 cryptoConfigurationV2) {
        super(aWSKMS, s3Direct, encryptionMaterialsProvider, cryptoConfigurationV2);
        CryptoMode cryptoMode = cryptoConfigurationV2.getCryptoMode();
        if (cryptoMode != CryptoMode.StrictAuthenticatedEncryption && cryptoMode != CryptoMode.AuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    S3CryptoModuleAE(S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfigurationV2 cryptoConfigurationV2) {
        this(null, s3Direct, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfigurationV2);
    }

    S3CryptoModuleAE(AWSKMS aWSKMS, S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfigurationV2 cryptoConfigurationV2) {
        this(aWSKMS, s3Direct, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfigurationV2);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) {
        S3Object s3Object;
        long[] lArray;
        boolean bl;
        long[] lArray2 = getObjectRequest.getRange();
        boolean bl2 = bl = lArray2 != null || getObjectRequest.getPartNumber() != null;
        if (bl) {
            this.assertCanGetPartialObject();
        }
        if ((lArray = S3CryptoModuleAE.getAdjustedCryptoRange(lArray2)) != null) {
            getObjectRequest.setRange(lArray[0], lArray[1]);
        }
        if ((s3Object = this.s3.getObject(getObjectRequest)) == null) {
            return null;
        }
        String string = null;
        if (getObjectRequest instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest encryptedGetObjectRequest = (EncryptedGetObjectRequest)getObjectRequest;
            string = encryptedGetObjectRequest.getInstructionFileSuffix();
        }
        try {
            return string == null || string.trim().isEmpty() ? this.decipher(getObjectRequest, lArray2, lArray, s3Object) : this.decipherWithInstFileSuffix(getObjectRequest, lArray2, lArray, s3Object, string);
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(s3Object, this.log);
            throw runtimeException;
        }
        catch (Error error) {
            IOUtils.closeQuietly(s3Object, this.log);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object decipher(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, S3Object s3Object) {
        S3ObjectWrapper s3ObjectWrapper = new S3ObjectWrapper(s3Object, getObjectRequest.getS3ObjectId());
        if (s3ObjectWrapper.hasEncryptionInfo()) {
            return this.decipherWithMetadata(getObjectRequest, lArray, lArray2, s3ObjectWrapper);
        }
        S3ObjectWrapper s3ObjectWrapper2 = this.fetchInstructionFile(getObjectRequest.getS3ObjectId(), null);
        if (s3ObjectWrapper2 != null) {
            try {
                S3Object s3Object2 = this.decipherWithInstructionFile(getObjectRequest, lArray, lArray2, s3ObjectWrapper, s3ObjectWrapper2);
                return s3Object2;
            }
            finally {
                IOUtils.closeQuietly(s3ObjectWrapper2, this.log);
            }
        }
        if (this.isStrict()) {
            IOUtils.closeQuietly(s3ObjectWrapper, this.log);
            throw new SecurityException("Unencrypted object found, cannot be decrypted in mode " + (Object)((Object)CryptoMode.StrictAuthenticatedEncryption) + "; bucket name: " + s3Object.getBucketName() + ", key: " + s3Object.getKey());
        }
        if (this.cryptoConfig.isUnsafeUndecryptableObjectPassthrough()) {
            this.log.warn(String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", s3Object.getKey(), s3Object.getBucketName()));
            S3ObjectWrapper s3ObjectWrapper3 = this.adjustToDesiredRange(s3ObjectWrapper, lArray, null);
            return s3ObjectWrapper3.getS3Object();
        }
        IOUtils.closeQuietly(s3ObjectWrapper, this.log);
        throw new SecurityException("Instruction file not found for S3 object with bucket name: " + s3Object.getBucketName() + ", key: " + s3Object.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object decipherWithInstFileSuffix(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, S3Object s3Object, String string) {
        S3ObjectId s3ObjectId = getObjectRequest.getS3ObjectId();
        S3ObjectWrapper s3ObjectWrapper = this.fetchInstructionFile(s3ObjectId, string);
        if (s3ObjectWrapper == null) {
            throw new SdkClientException("Instruction file with suffix " + string + " is not found for " + s3Object);
        }
        try {
            S3Object s3Object2 = this.decipherWithInstructionFile(getObjectRequest, lArray, lArray2, new S3ObjectWrapper(s3Object, s3ObjectId), s3ObjectWrapper);
            return s3Object2;
        }
        finally {
            IOUtils.closeQuietly(s3ObjectWrapper, this.log);
        }
    }

    private S3Object decipherWithInstructionFile(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, S3ObjectWrapper s3ObjectWrapper, S3ObjectWrapper s3ObjectWrapper2) {
        Object object;
        ExtraMaterialsDescription extraMaterialsDescription = ExtraMaterialsDescription.NONE;
        boolean bl = this.isStrict();
        if (getObjectRequest instanceof EncryptedGetObjectRequest) {
            object = (EncryptedGetObjectRequest)getObjectRequest;
            extraMaterialsDescription = ((EncryptedGetObjectRequest)object).getExtraMaterialDescription();
            if (!bl) {
                bl = ((EncryptedGetObjectRequest)object).isKeyWrapExpected();
            }
        }
        object = s3ObjectWrapper2.toJsonString();
        Map<String, String> map = Collections.unmodifiableMap(Jackson.stringMapFromJsonString((String)object));
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.fromInstructionFile(map, this.kekMaterialsProvider, this.cryptoConfig, lArray2, extraMaterialsDescription, bl, this.kms);
        boolean bl2 = lArray != null;
        this.securityCheck(contentCryptoMaterial, s3ObjectWrapper.getS3ObjectId(), bl2);
        S3ObjectWrapper s3ObjectWrapper3 = this.decrypt(s3ObjectWrapper, contentCryptoMaterial, lArray2);
        S3ObjectWrapper s3ObjectWrapper4 = this.adjustToDesiredRange(s3ObjectWrapper3, lArray, map);
        return s3ObjectWrapper4.getS3Object();
    }

    private S3Object decipherWithMetadata(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, S3ObjectWrapper s3ObjectWrapper) {
        Object object;
        ExtraMaterialsDescription extraMaterialsDescription = ExtraMaterialsDescription.NONE;
        boolean bl = this.isStrict();
        if (getObjectRequest instanceof EncryptedGetObjectRequest) {
            object = (EncryptedGetObjectRequest)getObjectRequest;
            extraMaterialsDescription = ((EncryptedGetObjectRequest)object).getExtraMaterialDescription();
            if (!bl) {
                bl = ((EncryptedGetObjectRequest)object).isKeyWrapExpected();
            }
        }
        object = ContentCryptoMaterial.fromObjectMetadata(s3ObjectWrapper.getObjectMetadata().getUserMetadata(), this.kekMaterialsProvider, this.cryptoConfig, lArray2, extraMaterialsDescription, bl, this.kms);
        boolean bl2 = lArray != null;
        this.securityCheck((ContentCryptoMaterial)object, s3ObjectWrapper.getS3ObjectId(), bl2);
        S3ObjectWrapper s3ObjectWrapper2 = this.decrypt(s3ObjectWrapper, (ContentCryptoMaterial)object, lArray2);
        S3ObjectWrapper s3ObjectWrapper3 = this.adjustToDesiredRange(s3ObjectWrapper2, lArray, null);
        return s3ObjectWrapper3.getS3Object();
    }

    protected final S3ObjectWrapper adjustToDesiredRange(S3ObjectWrapper s3ObjectWrapper, long[] lArray, Map<String, String> map) {
        if (lArray == null) {
            return s3ObjectWrapper;
        }
        ContentCryptoScheme contentCryptoScheme = s3ObjectWrapper.encryptionSchemeOf(map);
        long l = s3ObjectWrapper.getObjectMetadata().getInstanceLength();
        long l2 = l - (long)(contentCryptoScheme.getTagLengthInBits() / 8) - 1L;
        if (lArray[1] > l2) {
            lArray[1] = l2;
            if (lArray[0] > lArray[1]) {
                IOUtils.closeQuietly(s3ObjectWrapper.getObjectContent(), this.log);
                s3ObjectWrapper.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return s3ObjectWrapper;
            }
        }
        if (lArray[0] > lArray[1]) {
            return s3ObjectWrapper;
        }
        try {
            S3ObjectInputStream s3ObjectInputStream = s3ObjectWrapper.getObjectContent();
            AdjustedRangeInputStream adjustedRangeInputStream = new AdjustedRangeInputStream(s3ObjectInputStream, lArray[0], lArray[1]);
            s3ObjectWrapper.setObjectContent(new S3ObjectInputStream(adjustedRangeInputStream, s3ObjectInputStream.getHttpRequest()));
            return s3ObjectWrapper;
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error adjusting output to desired byte range: " + iOException.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) {
        this.assertParameterNotNull(file, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = this.getObjectSecurely(getObjectRequest);
        if (s3Object == null) {
            return null;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[10240];
            while ((n = s3Object.getObjectContent().read(byArray)) > -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                throw new SdkClientException("Unable to store object contents to disk: " + iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedOutputStream, this.log);
                IOUtils.closeQuietly(s3Object.getObjectContent(), this.log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bufferedOutputStream, this.log);
        IOUtils.closeQuietly(s3Object.getObjectContent(), this.log);
        return s3Object.getObjectMetadata();
    }

    @Override
    final MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest initiateMultipartUploadRequest, ContentCryptoMaterial contentCryptoMaterial) {
        return new MultipartUploadCryptoContext(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), contentCryptoMaterial);
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext multipartUploadCryptoContext) {
        return multipartUploadCryptoContext.getCipherLite();
    }

    @Override
    final SdkFilterInputStream wrapForMultipart(CipherLiteInputStream cipherLiteInputStream, long l) {
        return cipherLiteInputStream;
    }

    @Override
    final long computeLastPartSize(UploadPartRequest uploadPartRequest) {
        return uploadPartRequest.getPartSize() + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    @Override
    final void updateUploadContext(MultipartUploadCryptoContext multipartUploadCryptoContext, SdkFilterInputStream sdkFilterInputStream) {
    }

    private S3ObjectWrapper decrypt(S3ObjectWrapper s3ObjectWrapper, ContentCryptoMaterial contentCryptoMaterial, long[] lArray) {
        S3ObjectInputStream s3ObjectInputStream = s3ObjectWrapper.getObjectContent();
        s3ObjectWrapper.setObjectContent(new S3ObjectInputStream(new CipherLiteInputStream(s3ObjectInputStream, contentCryptoMaterial.getCipherLite(), 2048), s3ObjectInputStream.getHttpRequest()));
        return s3ObjectWrapper;
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    protected final long ciphertextLength(long l) {
        return l + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    private void assertCanGetPartialObject() {
        if (!this.isRangeGetEnabled()) {
            String string = "Unable to perform range get request: Range get support has been disabled. See https://docs.aws.amazon.com/general/latest/gr/aws_sdk_cryptography.html";
            throw new SecurityException(string);
        }
    }

    protected boolean isRangeGetEnabled() {
        CryptoRangeGetMode cryptoRangeGetMode = this.cryptoConfig.getRangeGetMode();
        switch (cryptoRangeGetMode) {
            case ALL: {
                return true;
            }
        }
        return false;
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

