/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v1;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.v1.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModuleAE;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModuleAEStrict;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModuleEO;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutInstructionFileRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class CryptoModuleDispatcher
extends S3CryptoModule<MultipartUploadContext> {
    private final CryptoMode defaultCryptoMode;
    private final S3CryptoModuleEO eo;
    private final S3CryptoModuleAE ae;

    public CryptoModuleDispatcher(AWSKMS aWSKMS, S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        cryptoConfiguration = cryptoConfiguration.clone();
        CryptoMode cryptoMode = cryptoConfiguration.getCryptoMode();
        if (cryptoMode == null) {
            cryptoMode = CryptoMode.EncryptionOnly;
            cryptoConfiguration.setCryptoMode(cryptoMode);
        }
        cryptoConfiguration = cryptoConfiguration.readOnly();
        this.defaultCryptoMode = cryptoConfiguration.getCryptoMode();
        switch (this.defaultCryptoMode) {
            case StrictAuthenticatedEncryption: {
                this.ae = new S3CryptoModuleAEStrict(aWSKMS, s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                this.eo = null;
                break;
            }
            case AuthenticatedEncryption: {
                this.ae = new S3CryptoModuleAE(aWSKMS, s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                this.eo = null;
                break;
            }
            case EncryptionOnly: {
                this.eo = new S3CryptoModuleEO(aWSKMS, s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
                CryptoConfiguration cryptoConfiguration2 = cryptoConfiguration.clone();
                try {
                    cryptoConfiguration2.setCryptoMode(CryptoMode.AuthenticatedEncryption);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                this.ae = new S3CryptoModuleAE(aWSKMS, s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration2.readOnly());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.putObjectSecurely(putObjectRequest) : this.ae.putObjectSecurely(putObjectRequest);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) {
        return this.ae.getObjectSecurely(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) {
        return this.ae.getObjectSecurely(getObjectRequest, file);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.completeMultipartUploadSecurely(completeMultipartUploadRequest) : this.ae.completeMultipartUploadSecurely(completeMultipartUploadRequest);
    }

    @Override
    public void abortMultipartUploadSecurely(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (this.defaultCryptoMode == CryptoMode.EncryptionOnly) {
            this.eo.abortMultipartUploadSecurely(abortMultipartUploadRequest);
        } else {
            this.ae.abortMultipartUploadSecurely(abortMultipartUploadRequest);
        }
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.initiateMultipartUploadSecurely(initiateMultipartUploadRequest) : this.ae.initiateMultipartUploadSecurely(initiateMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.uploadPartSecurely(uploadPartRequest) : this.ae.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.copyPartSecurely(copyPartRequest) : this.ae.copyPartSecurely(copyPartRequest);
    }

    @Override
    public PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest putInstructionFileRequest) {
        return this.defaultCryptoMode == CryptoMode.EncryptionOnly ? this.eo.putInstructionFileSecurely(putInstructionFileRequest) : this.ae.putInstructionFileSecurely(putInstructionFileRequest);
    }

    @Override
    public void putLocalObjectSecurely(UploadObjectRequest uploadObjectRequest, String string, OutputStream outputStream2) throws IOException {
        if (this.defaultCryptoMode == CryptoMode.EncryptionOnly) {
            this.eo.putLocalObjectSecurely(uploadObjectRequest, string, outputStream2);
        } else {
            this.ae.putLocalObjectSecurely(uploadObjectRequest, string, outputStream2);
        }
    }
}

