/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.keywrap;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kms.AWSKMS;
import java.util.Map;

public class KMSKeyWrapperContext {
    private final AWSKMS kms;
    private final AmazonWebServiceRequest originalRequest;
    private final Map<String, String> kmsMaterialsDescription;

    private KMSKeyWrapperContext(Builder builder) {
        this.kms = builder.kms;
        this.originalRequest = builder.originalRequest;
        this.kmsMaterialsDescription = builder.kmsMaterialsDescription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AmazonWebServiceRequest originalRequest() {
        return this.originalRequest;
    }

    public Map<String, String> kmsMaterialsDescription() {
        return this.kmsMaterialsDescription;
    }

    public AWSKMS kms() {
        return this.kms;
    }

    public static class Builder {
        private AWSKMS kms;
        private AmazonWebServiceRequest originalRequest;
        private Map<String, String> kmsMaterialsDescription;

        public Builder kms(AWSKMS aWSKMS) {
            this.kms = aWSKMS;
            return this;
        }

        public Builder originalRequest(AmazonWebServiceRequest amazonWebServiceRequest) {
            this.originalRequest = amazonWebServiceRequest;
            return this;
        }

        public Builder kmsMaterialsDescription(Map<String, String> map) {
            this.kmsMaterialsDescription = map;
            return this;
        }

        public KMSKeyWrapperContext build() {
            return new KMSKeyWrapperContext(this);
        }
    }
}

