/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoScheme;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class CipherLiteInputStream
extends SdkFilterInputStream {
    private static final int MAX_RETRY = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 512;
    private CipherLite cipherLite;
    private final boolean multipart;
    private final boolean lastMultiPart;
    private boolean eof;
    private byte[] bufin;
    private byte[] bufout;
    private int curr_pos;
    private int max_pos;

    public CipherLiteInputStream(InputStream inputStream2, CipherLite cipherLite) {
        this(inputStream2, cipherLite, 512, false, false);
    }

    public CipherLiteInputStream(InputStream inputStream2, CipherLite cipherLite, int n) {
        this(inputStream2, cipherLite, n, false, false);
    }

    public CipherLiteInputStream(InputStream inputStream2, CipherLite cipherLite, int n, boolean bl, boolean bl2) {
        super(inputStream2);
        if (bl2 && !bl) {
            throw new IllegalArgumentException("lastMultiPart can only be true if multipart is true");
        }
        this.multipart = bl;
        this.lastMultiPart = bl2;
        this.cipherLite = cipherLite;
        if (n <= 0 || n % 512 != 0) {
            throw new IllegalArgumentException("buffsize (" + n + ") must be a positive multiple of " + 512);
        }
        this.bufin = new byte[n];
    }

    public CipherLiteInputStream(InputStream inputStream2) {
        this(inputStream2, CipherLite.Null, 512, false, false);
    }

    @Override
    public int read() throws IOException {
        if (!this.readNextChunk()) {
            return -1;
        }
        return this.bufout[this.curr_pos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.readNextChunk()) {
            return -1;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.max_pos - this.curr_pos;
        if (n2 < n3) {
            n3 = n2;
        }
        System.arraycopy(this.bufout, this.curr_pos, byArray, n, n3);
        this.curr_pos += n3;
        return n3;
    }

    private boolean readNextChunk() throws IOException {
        if (this.curr_pos >= this.max_pos) {
            int n;
            if (this.eof) {
                return false;
            }
            int n2 = 0;
            do {
                if (n2 > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                n = this.nextChunk();
                if (this.bufout != null) continue;
                ++n2;
            } while (n == 0);
            if (n == -1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long skip(long l) throws IOException {
        this.abortIfNeeded();
        int n = this.max_pos - this.curr_pos;
        if (l > (long)n) {
            l = n;
        }
        if (l < 0L) {
            return 0L;
        }
        this.curr_pos = (int)((long)this.curr_pos + l);
        return l;
    }

    @Override
    public int available() {
        this.abortIfNeeded();
        return this.max_pos - this.curr_pos;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (!this.multipart && !S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) {
            try {
                this.cipherLite.doFinal();
            }
            catch (BadPaddingException badPaddingException) {
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                // empty catch block
            }
        }
        this.max_pos = 0;
        this.curr_pos = 0;
        this.abortIfNeeded();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported() && this.cipherLite.markSupported();
    }

    @Override
    public void mark(int n) {
        this.abortIfNeeded();
        this.in.mark(n);
        this.cipherLite.mark();
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
        this.cipherLite.reset();
        this.resetInternal();
    }

    final void resetInternal() {
        this.max_pos = 0;
        this.curr_pos = 0;
        this.eof = false;
    }

    private int nextChunk() throws IOException {
        this.abortIfNeeded();
        if (this.eof) {
            return -1;
        }
        this.bufout = null;
        int n = this.in.read(this.bufin);
        if (n == -1) {
            block7: {
                this.eof = true;
                if (!this.multipart || this.lastMultiPart) {
                    try {
                        this.bufout = this.cipherLite.doFinal();
                        if (this.bufout == null) {
                            return -1;
                        }
                        this.curr_pos = 0;
                        this.max_pos = this.bufout.length;
                        return this.max_pos;
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                    }
                    catch (BadPaddingException badPaddingException) {
                        if (!S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) break block7;
                        throw new SecurityException(badPaddingException);
                    }
                }
            }
            return -1;
        }
        this.bufout = this.cipherLite.update(this.bufin, 0, n);
        this.curr_pos = 0;
        this.max_pos = this.bufout == null ? 0 : this.bufout.length;
        return this.max_pos;
    }

    void renewCipherLite() {
        this.cipherLite = this.cipherLite.recreate();
    }
}

