/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.services.s3.internal.RestUtils;
import java.util.Date;

public class S3QueryStringSigner
extends AbstractAWSSigner {
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public S3QueryStringSigner(String string, String string2, Date date) {
        this.httpVerb = string;
        this.resourcePath = string2;
        this.expiration = date;
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials) throws SdkClientException {
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(signableRequest, (AWSSessionCredentials)aWSCredentials2);
        }
        String string = Long.toString(this.expiration.getTime() / 1000L);
        String string2 = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, signableRequest, string);
        String string3 = super.signAndBase64Encode(string2, aWSCredentials2.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        signableRequest.addParameter("AWSAccessKeyId", aWSCredentials2.getAWSAccessKeyId());
        signableRequest.addParameter("Expires", string);
        signableRequest.addParameter("Signature", string3);
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> signableRequest, AWSSessionCredentials aWSSessionCredentials) {
        signableRequest.addParameter("x-amz-security-token", aWSSessionCredentials.getSessionToken());
    }
}

