/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public final class S3OutpostResource
implements S3Resource {
    private final String partition;
    private final String region;
    private final String accountId;
    private final String outpostId;

    private S3OutpostResource(Builder builder) {
        this.partition = ValidationUtils.assertStringNotEmpty(builder.partition, "partition");
        this.region = ValidationUtils.assertStringNotEmpty(builder.region, "region");
        this.accountId = ValidationUtils.assertStringNotEmpty(builder.accountId, "accountId");
        this.outpostId = ValidationUtils.assertStringNotEmpty(builder.outpostId, "outpostId");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return S3ResourceType.OUTPOST.toString();
    }

    @Override
    public S3Resource getParentS3Resource() {
        return null;
    }

    @Override
    public String getPartition() {
        return this.partition;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public String getOutpostId() {
        return this.outpostId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        S3OutpostResource s3OutpostResource = (S3OutpostResource)object;
        if (this.partition != null ? !this.partition.equals(s3OutpostResource.partition) : s3OutpostResource.partition != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(s3OutpostResource.region) : s3OutpostResource.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(s3OutpostResource.accountId) : s3OutpostResource.accountId != null) {
            return false;
        }
        return this.outpostId.equals(s3OutpostResource.outpostId);
    }

    public int hashCode() {
        int n = this.partition != null ? this.partition.hashCode() : 0;
        n = 31 * n + (this.region != null ? this.region.hashCode() : 0);
        n = 31 * n + (this.accountId != null ? this.accountId.hashCode() : 0);
        n = 31 * n + this.outpostId.hashCode();
        return n;
    }

    public static final class Builder {
        private String outpostId;
        private String partition;
        private String region;
        private String accountId;

        private Builder() {
        }

        public Builder withPartition(String string) {
            this.partition = string;
            return this;
        }

        public Builder withRegion(String string) {
            this.region = string;
            return this;
        }

        public Builder withAccountId(String string) {
            this.accountId = string;
            return this;
        }

        public Builder withOutpostId(String string) {
            this.outpostId = string;
            return this;
        }

        public S3OutpostResource build() {
            return new S3OutpostResource(this);
        }
    }
}

