/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.HeaderHandler;
import com.amazonaws.services.s3.internal.ObjectRestoreResult;
import com.amazonaws.services.s3.internal.ServiceUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectRestoreHeaderHandler<T extends ObjectRestoreResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern ongoingPattern = Pattern.compile("ongoing-request=\"(.*?)\"");
    private static final Log log = LogFactory.getLog(ObjectRestoreHeaderHandler.class);

    @Override
    public void handle(T t2, HttpResponse httpResponse) {
        String string = httpResponse.getHeaders().get("x-amz-restore");
        if (string != null) {
            t2.setRestoreExpirationTime(this.parseDate(string));
            Boolean bl = this.parseBoolean(string);
            if (bl != null) {
                t2.setOngoingRestore(bl);
            }
        }
    }

    private Date parseDate(String string) {
        Matcher matcher = datePattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                return ServiceUtils.parseRfc822Date(string2);
            }
            catch (Exception exception) {
                log.warn("Error parsing expiry-date from x-amz-restore header.", exception);
            }
        }
        return null;
    }

    private Boolean parseBoolean(String string) {
        Matcher matcher = ongoingPattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return Boolean.parseBoolean(string2);
        }
        return null;
    }
}

