/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mimetypes {
    private static final Log log = LogFactory.getLog(Mimetypes.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    private static Mimetypes mimetypes = null;
    private HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private Mimetypes() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream inputStream2 = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (inputStream2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("Loading mime types from file in the classpath: mime.types");
            }
            try {
                mimetypes.loadAndReplaceMimetypes(inputStream2);
                return mimetypes;
            }
            catch (IOException iOException) {
                if (!log.isErrorEnabled()) return mimetypes;
                log.error("Failed to load mime types from file in the classpath: mime.types", iOException);
                return mimetypes;
            }
            finally {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    log.debug("", iOException);
                }
            }
        }
        if (!log.isWarnEnabled()) return mimetypes;
        log.warn("Unable to find 'mime.types' file in classpath");
        return mimetypes;
    }

    public void loadAndReplaceMimetypes(InputStream inputStream2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            if (stringTokenizer.countTokens() > 1) {
                String string2 = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.extensionToMimetypeMap.put(StringUtils.lowerCase(string3), string2);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Setting mime type for extension '" + StringUtils.lowerCase(string3) + "' to '" + string2 + "'");
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Ignoring mimetype with no associated file extensions: '" + string + "'");
        }
    }

    public String getMimetype(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0 && n + 1 < string.length()) {
            String string2 = StringUtils.lowerCase(string.substring(n + 1));
            if (this.extensionToMimetypeMap.keySet().contains(string2)) {
                String string3 = this.extensionToMimetypeMap.get(string2);
                if (log.isDebugEnabled()) {
                    log.debug("Recognised extension '" + string2 + "', mimetype is: '" + string3 + "'");
                }
                return string3;
            }
            if (log.isDebugEnabled()) {
                log.debug("Extension '" + string2 + "' is unrecognized in mime type listing, using default mime type: '" + MIMETYPE_OCTET_STREAM + "'");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("File name has no extension, mime type cannot be recognised for: " + string);
        }
        return MIMETYPE_OCTET_STREAM;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

