/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MD5DigestCalculatingInputStream
extends SdkFilterInputStream {
    private static Log log = LogFactory.getLog(MD5DigestCalculatingInputStream.class);
    private MessageDigest digest;
    private boolean digestCanBeCloned;
    private MessageDigest digestLastMarked;

    public MD5DigestCalculatingInputStream(InputStream inputStream2) {
        super(inputStream2);
        this.resetDigest();
        if (inputStream2.markSupported() && !this.digestCanBeCloned) {
            log.debug("Mark-and-reset disabled on MD5 calculation because the digest implementation does not support cloning. This will limit the SDK's ability to retry requests that failed. Consider pre-calculating the MD5 checksum for the request or switching to a security provider that supports message digest cloning.");
        }
    }

    private void resetDigest() {
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No message digest support for MD5 was found.", noSuchAlgorithmException);
        }
        this.digestCanBeCloned = this.canBeCloned(this.digest);
    }

    private boolean canBeCloned(MessageDigest messageDigest) {
        try {
            messageDigest.clone();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
    }

    private MessageDigest cloneFrom(MessageDigest messageDigest) {
        try {
            return (MessageDigest)messageDigest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Message digest implementation does not support cloning.", cloneNotSupportedException);
        }
    }

    @Override
    public boolean markSupported() {
        return super.markSupported() && this.digestCanBeCloned;
    }

    public byte[] getMd5Digest() {
        return this.digest.digest();
    }

    @Override
    public void mark(int n) {
        if (this.markSupported()) {
            super.mark(n);
            this.digestLastMarked = this.cloneFrom(this.digest);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.markSupported()) {
            super.reset();
            if (this.digestLastMarked == null) {
                this.resetDigest();
            } else {
                this.digest = this.cloneFrom(this.digestLastMarked);
            }
        } else {
            throw new IOException("mark/reset not supported");
        }
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.digest.update((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.digest.update(byArray, n, n3);
        }
        return n3;
    }
}

