/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.event;

import com.amazonaws.internal.DateTimeJsonSerializer;
import com.amazonaws.services.s3.model.S3Event;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.joda.time.DateTime;

public class S3EventNotification {
    private final List<S3EventNotificationRecord> records;

    @JsonCreator
    public S3EventNotification(@JsonProperty(value="Records") List<S3EventNotificationRecord> list) {
        this.records = list;
    }

    public static S3EventNotification parseJson(String string) {
        return Jackson.fromJsonString(string, S3EventNotification.class);
    }

    @JsonProperty(value="Records")
    public List<S3EventNotificationRecord> getRecords() {
        return this.records;
    }

    public String toJson() {
        return Jackson.toJsonString(this);
    }

    public static class S3EventNotificationRecord {
        private final String awsRegion;
        private final String eventName;
        private final String eventSource;
        private DateTime eventTime;
        private final String eventVersion;
        private final RequestParametersEntity requestParameters;
        private final ResponseElementsEntity responseElements;
        private final S3Entity s3;
        private final UserIdentityEntity userIdentity;
        private final GlacierEventDataEntity glacierEventData;

        @Deprecated
        public S3EventNotificationRecord(String string, String string2, String string3, String string4, String string5, RequestParametersEntity requestParametersEntity, ResponseElementsEntity responseElementsEntity, S3Entity s3Entity, UserIdentityEntity userIdentityEntity) {
            this(string, string2, string3, string4, string5, requestParametersEntity, responseElementsEntity, s3Entity, userIdentityEntity, null);
        }

        @JsonCreator
        public S3EventNotificationRecord(@JsonProperty(value="awsRegion") String string, @JsonProperty(value="eventName") String string2, @JsonProperty(value="eventSource") String string3, @JsonProperty(value="eventTime") String string4, @JsonProperty(value="eventVersion") String string5, @JsonProperty(value="requestParameters") RequestParametersEntity requestParametersEntity, @JsonProperty(value="responseElements") ResponseElementsEntity responseElementsEntity, @JsonProperty(value="s3") S3Entity s3Entity, @JsonProperty(value="userIdentity") UserIdentityEntity userIdentityEntity, @JsonProperty(value="glacierEventData") GlacierEventDataEntity glacierEventDataEntity) {
            this.awsRegion = string;
            this.eventName = string2;
            this.eventSource = string3;
            if (string4 != null) {
                this.eventTime = DateTime.parse(string4);
            }
            this.eventVersion = string5;
            this.requestParameters = requestParametersEntity;
            this.responseElements = responseElementsEntity;
            this.s3 = s3Entity;
            this.userIdentity = userIdentityEntity;
            this.glacierEventData = glacierEventDataEntity;
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public String getEventName() {
            return this.eventName;
        }

        @JsonIgnore
        public S3Event getEventNameAsEnum() {
            return S3Event.fromValue(this.eventName);
        }

        public String getEventSource() {
            return this.eventSource;
        }

        @JsonSerialize(using=DateTimeJsonSerializer.class)
        public DateTime getEventTime() {
            return this.eventTime;
        }

        public String getEventVersion() {
            return this.eventVersion;
        }

        public RequestParametersEntity getRequestParameters() {
            return this.requestParameters;
        }

        public ResponseElementsEntity getResponseElements() {
            return this.responseElements;
        }

        public S3Entity getS3() {
            return this.s3;
        }

        public UserIdentityEntity getUserIdentity() {
            return this.userIdentity;
        }

        public GlacierEventDataEntity getGlacierEventData() {
            return this.glacierEventData;
        }
    }

    public static class RestoreEventDataEntity {
        private DateTime lifecycleRestorationExpiryTime;
        private final String lifecycleRestoreStorageClass;

        @JsonCreator
        public RestoreEventDataEntity(@JsonProperty(value="lifecycleRestorationExpiryTime") String string, @JsonProperty(value="lifecycleRestoreStorageClass") String string2) {
            if (string != null) {
                this.lifecycleRestorationExpiryTime = DateTime.parse(string);
            }
            this.lifecycleRestoreStorageClass = string2;
        }

        @JsonSerialize(using=DateTimeJsonSerializer.class)
        public DateTime getLifecycleRestorationExpiryTime() {
            return this.lifecycleRestorationExpiryTime;
        }

        public String getLifecycleRestoreStorageClass() {
            return this.lifecycleRestoreStorageClass;
        }
    }

    public static class GlacierEventDataEntity {
        private final RestoreEventDataEntity restoreEventData;

        @JsonCreator
        public GlacierEventDataEntity(@JsonProperty(value="restoreEventData") RestoreEventDataEntity restoreEventDataEntity) {
            this.restoreEventData = restoreEventDataEntity;
        }

        public RestoreEventDataEntity getRestoreEventData() {
            return this.restoreEventData;
        }
    }

    public static class ResponseElementsEntity {
        private final String xAmzId2;
        private final String xAmzRequestId;

        @JsonCreator
        public ResponseElementsEntity(@JsonProperty(value="x-amz-id-2") String string, @JsonProperty(value="x-amz-request-id") String string2) {
            this.xAmzId2 = string;
            this.xAmzRequestId = string2;
        }

        @JsonProperty(value="x-amz-id-2")
        public String getxAmzId2() {
            return this.xAmzId2;
        }

        @JsonProperty(value="x-amz-request-id")
        public String getxAmzRequestId() {
            return this.xAmzRequestId;
        }
    }

    public static class RequestParametersEntity {
        private final String sourceIPAddress;

        @JsonCreator
        public RequestParametersEntity(@JsonProperty(value="sourceIPAddress") String string) {
            this.sourceIPAddress = string;
        }

        public String getSourceIPAddress() {
            return this.sourceIPAddress;
        }
    }

    public static class S3Entity {
        private final String configurationId;
        private final S3BucketEntity bucket;
        private final S3ObjectEntity object;
        private final String s3SchemaVersion;

        @JsonCreator
        public S3Entity(@JsonProperty(value="configurationId") String string, @JsonProperty(value="bucket") S3BucketEntity s3BucketEntity, @JsonProperty(value="object") S3ObjectEntity s3ObjectEntity, @JsonProperty(value="s3SchemaVersion") String string2) {
            this.configurationId = string;
            this.bucket = s3BucketEntity;
            this.object = s3ObjectEntity;
            this.s3SchemaVersion = string2;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }

        public S3BucketEntity getBucket() {
            return this.bucket;
        }

        public S3ObjectEntity getObject() {
            return this.object;
        }

        public String getS3SchemaVersion() {
            return this.s3SchemaVersion;
        }
    }

    public static class S3ObjectEntity {
        private final String key;
        private final Long size;
        private final String eTag;
        private final String versionId;
        private final String sequencer;

        @Deprecated
        public S3ObjectEntity(String string, Integer n, String string2, String string3) {
            this.key = string;
            this.size = n == null ? null : Long.valueOf(n.longValue());
            this.eTag = string2;
            this.versionId = string3;
            this.sequencer = null;
        }

        @Deprecated
        public S3ObjectEntity(String string, Long l, String string2, String string3) {
            this(string, l, string2, string3, null);
        }

        @JsonCreator
        public S3ObjectEntity(@JsonProperty(value="key") String string, @JsonProperty(value="size") Long l, @JsonProperty(value="eTag") String string2, @JsonProperty(value="versionId") String string3, @JsonProperty(value="sequencer") String string4) {
            this.key = string;
            this.size = l;
            this.eTag = string2;
            this.versionId = string3;
            this.sequencer = string4;
        }

        public String getKey() {
            return this.key;
        }

        public String getUrlDecodedKey() {
            return SdkHttpUtils.urlDecode(this.getKey());
        }

        @Deprecated
        @JsonIgnore
        public Integer getSize() {
            return this.size == null ? null : Integer.valueOf(this.size.intValue());
        }

        @JsonProperty(value="size")
        public Long getSizeAsLong() {
            return this.size;
        }

        public String geteTag() {
            return this.eTag;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getSequencer() {
            return this.sequencer;
        }
    }

    public static class S3BucketEntity {
        private final String name;
        private final UserIdentityEntity ownerIdentity;
        private final String arn;

        @JsonCreator
        public S3BucketEntity(@JsonProperty(value="name") String string, @JsonProperty(value="ownerIdentity") UserIdentityEntity userIdentityEntity, @JsonProperty(value="arn") String string2) {
            this.name = string;
            this.ownerIdentity = userIdentityEntity;
            this.arn = string2;
        }

        public String getName() {
            return this.name;
        }

        public UserIdentityEntity getOwnerIdentity() {
            return this.ownerIdentity;
        }

        public String getArn() {
            return this.arn;
        }
    }

    public static class UserIdentityEntity {
        private final String principalId;

        @JsonCreator
        public UserIdentityEntity(@JsonProperty(value="principalId") String string) {
            this.principalId = string;
        }

        public String getPrincipalId() {
            return this.principalId;
        }
    }
}

