/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.OnFileDelete;
import com.amazonaws.services.s3.internal.PartCreationEvent;
import com.amazonaws.services.s3.internal.S3DirectSpi;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.LogFactory;

public class UploadObjectObserver {
    private final List<Future<UploadPartResult>> futures = new ArrayList<Future<UploadPartResult>>();
    private UploadObjectRequest req;
    private String uploadId;
    private S3DirectSpi s3direct;
    private AmazonS3 s3;
    private ExecutorService es;

    public UploadObjectObserver init(UploadObjectRequest uploadObjectRequest, S3DirectSpi s3DirectSpi, AmazonS3 amazonS3, ExecutorService executorService) {
        this.req = uploadObjectRequest;
        this.s3direct = s3DirectSpi;
        this.s3 = amazonS3;
        this.es = executorService;
        return this;
    }

    protected InitiateMultipartUploadRequest newInitiateMultipartUploadRequest(UploadObjectRequest uploadObjectRequest) {
        return (InitiateMultipartUploadRequest)((AmazonWebServiceRequest)((AmazonWebServiceRequest)new EncryptedInitiateMultipartUploadRequest(uploadObjectRequest.getBucketName(), uploadObjectRequest.getKey(), uploadObjectRequest.getMetadata()).withMaterialsDescription(uploadObjectRequest.getMaterialsDescription()).withRedirectLocation(uploadObjectRequest.getRedirectLocation()).withSSEAwsKeyManagementParams(uploadObjectRequest.getSSEAwsKeyManagementParams()).withSSECustomerKey(uploadObjectRequest.getSSECustomerKey()).withStorageClass(uploadObjectRequest.getStorageClass()).withAccessControlList(uploadObjectRequest.getAccessControlList()).withCannedACL(uploadObjectRequest.getCannedAcl()).withGeneralProgressListener(uploadObjectRequest.getGeneralProgressListener())).withRequestMetricCollector(uploadObjectRequest.getRequestMetricCollector())).withRequestCredentialsProvider(uploadObjectRequest.getRequestCredentialsProvider());
    }

    public String onUploadInitiation(UploadObjectRequest uploadObjectRequest) {
        InitiateMultipartUploadResult initiateMultipartUploadResult = this.s3.initiateMultipartUpload(this.newInitiateMultipartUploadRequest(uploadObjectRequest));
        this.uploadId = initiateMultipartUploadResult.getUploadId();
        return this.uploadId;
    }

    public void onPartCreate(PartCreationEvent partCreationEvent) {
        final File file = partCreationEvent.getPart();
        final UploadPartRequest uploadPartRequest = this.newUploadPartRequest(partCreationEvent, file);
        final OnFileDelete onFileDelete = partCreationEvent.getFileDeleteObserver();
        this.futures.add(this.es.submit(new Callable<UploadPartResult>(){

            @Override
            public UploadPartResult call() {
                try {
                    UploadPartResult uploadPartResult = UploadObjectObserver.this.uploadPart(uploadPartRequest);
                    return uploadPartResult;
                }
                finally {
                    if (!file.delete()) {
                        LogFactory.getLog(this.getClass()).debug("Ignoring failure to delete file " + file + " which has already been uploaded");
                    } else if (onFileDelete != null) {
                        onFileDelete.onFileDelete(null);
                    }
                }
            }
        }));
    }

    public CompleteMultipartUploadResult onCompletion(List<PartETag> list) {
        return this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)new CompleteMultipartUploadRequest(this.req.getBucketName(), this.req.getKey(), this.uploadId, list).withRequestCredentialsProvider(this.req.getRequestCredentialsProvider()));
    }

    public void onAbort() {
        for (Future<UploadPartResult> future : this.getFutures()) {
            future.cancel(true);
        }
        if (this.uploadId != null) {
            try {
                this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(this.req.getBucketName(), this.req.getKey(), this.uploadId));
            }
            catch (Exception exception) {
                LogFactory.getLog(this.getClass()).debug("Failed to abort multi-part upload: " + this.uploadId, exception);
            }
        }
    }

    protected UploadPartRequest newUploadPartRequest(PartCreationEvent partCreationEvent, File file) {
        UploadPartRequest uploadPartRequest = (UploadPartRequest)new UploadPartRequest().withBucketName(this.req.getBucketName()).withFile(file).withKey(this.req.getKey()).withPartNumber(partCreationEvent.getPartNumber()).withPartSize(file.length()).withLastPart(partCreationEvent.isLastPart()).withUploadId(this.uploadId).withObjectMetadata(this.req.getUploadPartMetadata()).withRequestCredentialsProvider(this.req.getRequestCredentialsProvider());
        return uploadPartRequest;
    }

    protected UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) {
        return this.s3direct.uploadPart(uploadPartRequest);
    }

    protected <X extends AmazonWebServiceRequest> X appendUserAgent(X x, String string) {
        x.getRequestClientOptions().appendUserAgent(string);
        return x;
    }

    public List<Future<UploadPartResult>> getFutures() {
        return this.futures;
    }

    protected UploadObjectRequest getRequest() {
        return this.req;
    }

    protected String getUploadId() {
        return this.uploadId;
    }

    protected S3DirectSpi getS3DirectSpi() {
        return this.s3direct;
    }

    protected AmazonS3 getAmazonS3() {
        return this.s3;
    }

    protected ExecutorService getExecutorService() {
        return this.es;
    }
}

