/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.SdkClientException;

public class S3ClientOptions {
    public static final boolean DEFAULT_PATH_STYLE_ACCESS = false;
    public static final boolean DEFAULT_CHUNKED_ENCODING_DISABLED = false;
    public static final boolean DEFAULT_PAYLOAD_SIGNING_ENABLED = false;
    public static final boolean DEFAULT_ACCELERATE_MODE_ENABLED = false;
    public static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    public static final boolean DEFAULT_FORCE_GLOBAL_BUCKET_ACCESS_ENABLED = false;
    public static final boolean DEFAULT_USE_ARN_REGION = false;
    public static final boolean DEFAULT_US_EAST_1_REGION_ENDPOINT_ENABLED = false;
    private boolean pathStyleAccess;
    private boolean chunkedEncodingDisabled;
    private final boolean accelerateModeEnabled;
    private final boolean payloadSigningEnabled;
    private final boolean dualstackEnabled;
    private final boolean forceGlobalBucketAccessEnabled;
    private final boolean useArnRegion;
    private final boolean regionalUsEast1EndpointEnabled;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public S3ClientOptions() {
        this.pathStyleAccess = false;
        this.chunkedEncodingDisabled = false;
        this.accelerateModeEnabled = false;
        this.payloadSigningEnabled = false;
        this.dualstackEnabled = false;
        this.forceGlobalBucketAccessEnabled = false;
        this.useArnRegion = false;
        this.regionalUsEast1EndpointEnabled = false;
    }

    @Deprecated
    public S3ClientOptions(S3ClientOptions s3ClientOptions) {
        this.pathStyleAccess = s3ClientOptions.pathStyleAccess;
        this.chunkedEncodingDisabled = s3ClientOptions.chunkedEncodingDisabled;
        this.accelerateModeEnabled = s3ClientOptions.accelerateModeEnabled;
        this.payloadSigningEnabled = s3ClientOptions.payloadSigningEnabled;
        this.dualstackEnabled = s3ClientOptions.dualstackEnabled;
        this.forceGlobalBucketAccessEnabled = s3ClientOptions.forceGlobalBucketAccessEnabled;
        this.useArnRegion = s3ClientOptions.useArnRegion;
        this.regionalUsEast1EndpointEnabled = s3ClientOptions.regionalUsEast1EndpointEnabled;
    }

    private S3ClientOptions(Builder builder) {
        this.pathStyleAccess = builder.pathStyleAccess;
        this.chunkedEncodingDisabled = builder.chunkedEncodingDisabled;
        this.accelerateModeEnabled = builder.accelerateModeEnabled;
        this.payloadSigningEnabled = builder.payloadSigningEnabled;
        this.dualstackEnabled = builder.dualstackEnabled;
        this.forceGlobalBucketAccessEnabled = builder.forceGlobalBucketAccessEnabled;
        this.useArnRegion = Boolean.TRUE.equals(builder.useArnRegion);
        this.regionalUsEast1EndpointEnabled = builder.regionalUsEast1EndpointEnabled;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public boolean isDualstackEnabled() {
        return this.dualstackEnabled;
    }

    public boolean isForceGlobalBucketAccessEnabled() {
        return this.forceGlobalBucketAccessEnabled;
    }

    public boolean isUseArnRegion() {
        return this.useArnRegion;
    }

    public boolean isRegionalUsEast1EndpointEnabled() {
        return this.regionalUsEast1EndpointEnabled;
    }

    @Deprecated
    public void setPathStyleAccess(boolean bl) {
        this.pathStyleAccess = bl;
    }

    @Deprecated
    public S3ClientOptions withPathStyleAccess(boolean bl) {
        this.setPathStyleAccess(bl);
        return this;
    }

    @Deprecated
    public void setChunkedEncodingDisabled(boolean bl) {
        this.chunkedEncodingDisabled = bl;
    }

    @Deprecated
    public S3ClientOptions withChunkedEncodingDisabled(boolean bl) {
        this.setChunkedEncodingDisabled(bl);
        return this;
    }

    @Deprecated
    public S3ClientOptions disableChunkedEncoding() {
        return this.withChunkedEncodingDisabled(true);
    }

    public static class Builder {
        private boolean pathStyleAccess = false;
        private boolean chunkedEncodingDisabled = false;
        private boolean accelerateModeEnabled = false;
        private boolean payloadSigningEnabled = false;
        private boolean dualstackEnabled = false;
        private boolean forceGlobalBucketAccessEnabled = false;
        private Boolean useArnRegion = null;
        private boolean regionalUsEast1EndpointEnabled = false;

        private Builder() {
        }

        public S3ClientOptions build() {
            if (this.pathStyleAccess && this.accelerateModeEnabled) {
                throw new SdkClientException("Both accelerate mode and path style access are being enabled either through S3ClientOptions or AmazonS3ClientBuilder. These options are mutually exclusive and cannot be enabled together. Please disable one of them");
            }
            return new S3ClientOptions(this);
        }

        public Builder setPathStyleAccess(boolean bl) {
            this.pathStyleAccess = bl;
            return this;
        }

        public Builder setAccelerateModeEnabled(boolean bl) {
            this.accelerateModeEnabled = bl;
            return this;
        }

        public Builder setPayloadSigningEnabled(boolean bl) {
            this.payloadSigningEnabled = bl;
            return this;
        }

        public Builder disableChunkedEncoding() {
            this.chunkedEncodingDisabled = true;
            return this;
        }

        public Builder enableDualstack() {
            this.dualstackEnabled = true;
            return this;
        }

        public Builder enableForceGlobalBucketAccess() {
            this.forceGlobalBucketAccessEnabled = true;
            return this;
        }

        public Builder enableUseArnRegion() {
            this.useArnRegion = true;
            return this;
        }

        public Builder enableRegionalUsEast1Endpoint() {
            this.regionalUsEast1EndpointEnabled = true;
            return this;
        }
    }
}

