/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public final class S3AccessPointResource
implements S3Resource {
    private static final S3ResourceType S3_RESOURCE_TYPE = S3ResourceType.ACCESS_POINT;
    private final String partition;
    private final String region;
    private final String accountId;
    private final String accessPointName;
    private final S3Resource parentS3Resource;

    private S3AccessPointResource(Builder builder) {
        this.accessPointName = ValidationUtils.assertStringNotEmpty(builder.accessPointName, "accessPointName");
        if (builder.parentS3Resource == null) {
            this.parentS3Resource = null;
            this.partition = ValidationUtils.assertStringNotEmpty(builder.partition, "partition");
            this.region = ValidationUtils.assertStringNotEmpty(builder.region, "region");
            this.accountId = ValidationUtils.assertStringNotEmpty(builder.accountId, "accountId");
        } else {
            this.parentS3Resource = this.validateParentS3Resource(builder.parentS3Resource);
            ValidationUtils.assertAllAreNull("partition cannot be set on builder if it has parent resource", builder.partition);
            ValidationUtils.assertAllAreNull("region cannot be set on builder if it has parent resource", builder.region);
            ValidationUtils.assertAllAreNull("accountId cannot be set on builder if it has parent resource", builder.accountId);
            this.partition = this.parentS3Resource.getPartition();
            this.region = this.parentS3Resource.getRegion();
            this.accountId = this.parentS3Resource.getAccountId();
        }
    }

    private S3Resource validateParentS3Resource(S3Resource s3Resource) {
        String string = s3Resource.getType();
        if (!S3ResourceType.OUTPOST.toString().equals(string) && !S3ResourceType.OBJECT_LAMBDAS.toString().equals(string)) {
            throw new IllegalArgumentException("Invalid 'parentS3Resource' type. An S3 access point resource must be associated with an outpost or object lambdas parent resource.");
        }
        return s3Resource;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return S3_RESOURCE_TYPE.toString();
    }

    @Override
    public String getPartition() {
        return this.partition;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public String getAccessPointName() {
        return this.accessPointName;
    }

    @Override
    public S3Resource getParentS3Resource() {
        return this.parentS3Resource;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        S3AccessPointResource s3AccessPointResource = (S3AccessPointResource)object;
        if (this.partition != null ? !this.partition.equals(s3AccessPointResource.partition) : s3AccessPointResource.partition != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(s3AccessPointResource.region) : s3AccessPointResource.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(s3AccessPointResource.accountId) : s3AccessPointResource.accountId != null) {
            return false;
        }
        if (this.parentS3Resource != null ? !this.parentS3Resource.equals(s3AccessPointResource.parentS3Resource) : s3AccessPointResource.parentS3Resource != null) {
            return false;
        }
        return this.accessPointName.equals(s3AccessPointResource.accessPointName);
    }

    public int hashCode() {
        int n = this.partition != null ? this.partition.hashCode() : 0;
        n = 31 * n + (this.region != null ? this.region.hashCode() : 0);
        n = 31 * n + (this.accountId != null ? this.accountId.hashCode() : 0);
        n = 31 * n + this.accessPointName.hashCode();
        n = 31 * n + (this.parentS3Resource != null ? this.parentS3Resource.hashCode() : 0);
        return n;
    }

    public static final class Builder {
        private String partition;
        private String region;
        private String accountId;
        private String accessPointName;
        private S3Resource parentS3Resource;

        public void setPartition(String string) {
            this.partition = string;
        }

        public Builder withPartition(String string) {
            this.setPartition(string);
            return this;
        }

        public void setRegion(String string) {
            this.region = string;
        }

        public Builder withRegion(String string) {
            this.setRegion(string);
            return this;
        }

        public void setAccountId(String string) {
            this.accountId = string;
        }

        public Builder withAccountId(String string) {
            this.setAccountId(string);
            return this;
        }

        public void setAccessPointName(String string) {
            this.accessPointName = string;
        }

        public Builder withAccessPointName(String string) {
            this.setAccessPointName(string);
            return this;
        }

        public Builder withParentS3Resource(S3Resource s3Resource) {
            this.parentS3Resource = s3Resource;
            return this;
        }

        public S3AccessPointResource build() {
            return new S3AccessPointResource(this);
        }
    }
}

