/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientParams;
import com.amazonaws.services.s3.UploadObjectObserver;
import com.amazonaws.services.s3.internal.MultiFileOutputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.v1.CryptoModuleDispatcher;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModule;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.InstructionFileId;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutInstructionFileRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Deprecated
public class AmazonS3EncryptionClient
extends AmazonS3Client
implements AmazonS3Encryption {
    private static final String USER_AGENT_V1 = "S3CryptoV1n/" + VersionInfoUtils.getVersion();
    private final S3CryptoModule<?> crypto;
    private final AWSKMS kms;
    private final boolean isKMSClientInternal;

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterials encryptionMaterials) {
        this(new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(new AnonymousAWSCredentials()), encryptionMaterialsProvider, configFactory.getConfig(), new CryptoConfiguration());
    }

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfiguration) {
        this(new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(new AnonymousAWSCredentials()), encryptionMaterialsProvider, configFactory.getConfig(), cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials aWSCredentials, EncryptionMaterials encryptionMaterials) {
        this(aWSCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials aWSCredentials, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(aWSCredentials, encryptionMaterialsProvider, configFactory.getConfig(), new CryptoConfiguration());
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(aWSCredentialsProvider, encryptionMaterialsProvider, configFactory.getConfig(), new CryptoConfiguration());
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials aWSCredentials, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfiguration) {
        this(aWSCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials aWSCredentials, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(aWSCredentials, encryptionMaterialsProvider, configFactory.getConfig(), cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(aWSCredentialsProvider, encryptionMaterialsProvider, configFactory.getConfig(), cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials aWSCredentials, EncryptionMaterials encryptionMaterials, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration) {
        this(aWSCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfiguration, cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials aWSCredentials, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(aWSCredentials), encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration) {
        this(aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration, null);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration, RequestMetricCollector requestMetricCollector) {
        this(null, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration, requestMetricCollector);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSKMSClient aWSKMSClient, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration, RequestMetricCollector requestMetricCollector) {
        super(aWSCredentialsProvider, clientConfiguration, requestMetricCollector);
        this.assertParameterNotNull(encryptionMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfiguration, "CryptoConfiguration parameter must not be null.");
        this.isKMSClientInternal = aWSKMSClient == null;
        this.kms = this.isKMSClientInternal ? this.newAWSKMSClient(aWSCredentialsProvider, clientConfiguration, cryptoConfiguration, requestMetricCollector) : aWSKMSClient;
        this.crypto = new CryptoModuleDispatcher(this.kms, new S3DirectImpl(), aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
    }

    @SdkInternalApi
    AmazonS3EncryptionClient(AmazonS3EncryptionClientParams amazonS3EncryptionClientParams) {
        super(amazonS3EncryptionClientParams);
        this.assertParameterNotNull(amazonS3EncryptionClientParams.getEncryptionMaterials(), "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(amazonS3EncryptionClientParams.getCryptoConfiguration(), "CryptoConfiguration parameter must not be null.");
        this.isKMSClientInternal = amazonS3EncryptionClientParams.getKmsClient() == null;
        this.kms = this.isKMSClientInternal ? this.newAWSKMSClient(amazonS3EncryptionClientParams.getClientParams().getCredentialsProvider(), amazonS3EncryptionClientParams.getClientParams().getClientConfiguration(), amazonS3EncryptionClientParams.getCryptoConfiguration(), amazonS3EncryptionClientParams.getClientParams().getRequestMetricCollector()) : amazonS3EncryptionClientParams.getKmsClient();
        this.crypto = new CryptoModuleDispatcher(this.kms, new S3DirectImpl(), amazonS3EncryptionClientParams.getClientParams().getCredentialsProvider(), amazonS3EncryptionClientParams.getEncryptionMaterials(), amazonS3EncryptionClientParams.getCryptoConfiguration());
    }

    public static AmazonS3EncryptionClientBuilder encryptionBuilder() {
        return AmazonS3EncryptionClientBuilder.standard();
    }

    private AWSKMSClient newAWSKMSClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration, RequestMetricCollector requestMetricCollector) {
        AWSKMSClient aWSKMSClient = new AWSKMSClient(aWSCredentialsProvider, clientConfiguration, requestMetricCollector);
        Region region = cryptoConfiguration.getAwsKmsRegion();
        if (region != null) {
            aWSKMSClient.setRegion(region);
        }
        return aWSKMSClient;
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
        return this.crypto.putObjectSecurely(putObjectRequest.clone());
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) {
        return this.crypto.getObjectSecurely(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) {
        return this.crypto.getObjectSecurely(getObjectRequest, file);
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) {
        deleteObjectRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_V1);
        super.deleteObject(deleteObjectRequest);
        InstructionFileId instructionFileId = new S3ObjectId(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey()).instructionFileId();
        DeleteObjectRequest deleteObjectRequest2 = (DeleteObjectRequest)deleteObjectRequest.clone();
        deleteObjectRequest2.withBucketName(instructionFileId.getBucket()).withKey(instructionFileId.getKey());
        super.deleteObject(deleteObjectRequest2);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        return this.crypto.completeMultipartUploadSecurely(completeMultipartUploadRequest);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        boolean bl = true;
        if (initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest) {
            EncryptedInitiateMultipartUploadRequest encryptedInitiateMultipartUploadRequest = (EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest;
            bl = encryptedInitiateMultipartUploadRequest.isCreateEncryptionMaterial();
        }
        return bl ? this.crypto.initiateMultipartUploadSecurely(initiateMultipartUploadRequest) : super.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        return this.crypto.copyPartSecurely(copyPartRequest);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.crypto.abortMultipartUploadSecurely(abortMultipartUploadRequest);
    }

    public PutObjectResult putInstructionFile(PutInstructionFileRequest putInstructionFileRequest) {
        return this.crypto.putInstructionFileSecurely(putInstructionFileRequest);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.isKMSClientInternal) {
            this.kms.shutdown();
        }
    }

    @Override
    public CompleteMultipartUploadResult uploadObject(UploadObjectRequest uploadObjectRequest) throws IOException, InterruptedException, ExecutionException {
        UploadObjectObserver uploadObjectObserver;
        boolean bl;
        ExecutorService executorService = uploadObjectRequest.getExecutorService();
        boolean bl2 = bl = executorService == null;
        if (executorService == null) {
            executorService = Executors.newFixedThreadPool(this.clientConfiguration.getMaxConnections());
        }
        if ((uploadObjectObserver = uploadObjectRequest.getUploadObjectObserver()) == null) {
            uploadObjectObserver = new UploadObjectObserver();
        }
        uploadObjectObserver.init(uploadObjectRequest, new S3DirectImpl(), this, executorService);
        String string = uploadObjectObserver.onUploadInitiation(uploadObjectRequest);
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        MultiFileOutputStream multiFileOutputStream = uploadObjectRequest.getMultiFileOutputStream();
        if (multiFileOutputStream == null) {
            multiFileOutputStream = new MultiFileOutputStream();
        }
        try {
            multiFileOutputStream.init(uploadObjectObserver, uploadObjectRequest.getPartSize(), uploadObjectRequest.getDiskLimit());
            this.crypto.putLocalObjectSecurely(uploadObjectRequest, string, multiFileOutputStream);
            for (Future<UploadPartResult> future : uploadObjectObserver.getFutures()) {
                UploadPartResult uploadPartResult = future.get();
                arrayList.add(new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag()));
            }
        }
        catch (IOException iOException) {
            throw this.onAbort(uploadObjectObserver, iOException);
        }
        catch (InterruptedException interruptedException) {
            throw this.onAbort(uploadObjectObserver, interruptedException);
        }
        catch (ExecutionException executionException) {
            throw this.onAbort(uploadObjectObserver, executionException);
        }
        catch (RuntimeException runtimeException) {
            throw this.onAbort(uploadObjectObserver, runtimeException);
        }
        catch (Error error) {
            throw this.onAbort(uploadObjectObserver, error);
        }
        finally {
            if (bl) {
                executorService.shutdownNow();
            }
            multiFileOutputStream.cleanup();
        }
        return uploadObjectObserver.onCompletion(arrayList);
    }

    private <T extends Throwable> T onAbort(UploadObjectObserver uploadObjectObserver, T t2) {
        uploadObjectObserver.onAbort();
        return t2;
    }

    private final class S3DirectImpl
    extends S3Direct {
        private S3DirectImpl() {
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
            this.appendUserAgent(putObjectRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.putObject(putObjectRequest);
        }

        @Override
        public S3Object getObject(GetObjectRequest getObjectRequest) {
            this.appendUserAgent(getObjectRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.getObject(getObjectRequest);
        }

        @Override
        public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) {
            this.appendUserAgent(getObjectRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.getObject(getObjectRequest, file);
        }

        @Override
        public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) {
            this.appendUserAgent(getObjectMetadataRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.getObjectMetadata(getObjectMetadataRequest);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
            this.appendUserAgent(completeMultipartUploadRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.completeMultipartUpload(completeMultipartUploadRequest);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
            this.appendUserAgent(initiateMultipartUploadRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.initiateMultipartUpload(initiateMultipartUploadRequest);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
            this.appendUserAgent(uploadPartRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.uploadPart(uploadPartRequest);
        }

        @Override
        public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
            this.appendUserAgent(copyPartRequest, USER_AGENT_V1);
            return AmazonS3EncryptionClient.super.copyPart(copyPartRequest);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
            this.appendUserAgent(abortMultipartUploadRequest, USER_AGENT_V1);
            AmazonS3EncryptionClient.super.abortMultipartUpload(abortMultipartUploadRequest);
        }

        final <X extends AmazonWebServiceRequest> X appendUserAgent(X x, String string) {
            x.getRequestClientOptions().appendUserAgent(string);
            return x;
        }
    }
}

