/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.RequestConfig;
import com.amazonaws.ResetException;
import com.amazonaws.Response;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.arn.Arn;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressInputStream;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.AmazonWebServiceRequestAdapter;
import com.amazonaws.internal.DefaultServiceEndpointBuilder;
import com.amazonaws.internal.IdentityEndpointBuilder;
import com.amazonaws.internal.ReleasableInputStream;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.ServiceEndpointBuilder;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.internal.auth.NoOpSignerProvider;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3ClientConfigurationFactory;
import com.amazonaws.services.s3.AmazonS3ClientParams;
import com.amazonaws.services.s3.S3AccessPointResource;
import com.amazonaws.services.s3.S3ArnConverter;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.S3CredentialsProviderChain;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.UploadObjectObserver;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.internal.CompleteMultipartUploadRetryCondition;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.internal.DeleteObjectTaggingHeaderHandler;
import com.amazonaws.services.s3.internal.DeleteObjectsResponse;
import com.amazonaws.services.s3.internal.DigestValidationInputStream;
import com.amazonaws.services.s3.internal.DualstackEndpointBuilder;
import com.amazonaws.services.s3.internal.GetObjectTaggingResponseHeaderHandler;
import com.amazonaws.services.s3.internal.InitiateMultipartUploadHeaderHandler;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.ListPartsHeaderHandler;
import com.amazonaws.services.s3.internal.MD5DigestCalculatingInputStream;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.MultiFileOutputStream;
import com.amazonaws.services.s3.internal.ObjectExpirationHeaderHandler;
import com.amazonaws.services.s3.internal.RegionalEndpointsOptionResolver;
import com.amazonaws.services.s3.internal.ResponseHeaderHandlerChain;
import com.amazonaws.services.s3.internal.S3AbortableInputStream;
import com.amazonaws.services.s3.internal.S3AccessPointBuilder;
import com.amazonaws.services.s3.internal.S3ErrorResponseHandler;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.S3ObjectLambdaEndpointBuilder;
import com.amazonaws.services.s3.internal.S3ObjectLambdaOperationEndpointBuilder;
import com.amazonaws.services.s3.internal.S3ObjectResponseHandler;
import com.amazonaws.services.s3.internal.S3OutpostAccessPointBuilder;
import com.amazonaws.services.s3.internal.S3OutpostResource;
import com.amazonaws.services.s3.internal.S3QueryStringSigner;
import com.amazonaws.services.s3.internal.S3RequestEndpointResolver;
import com.amazonaws.services.s3.internal.S3RequesterChargedHeaderHandler;
import com.amazonaws.services.s3.internal.S3RestoreOutputPathHeaderHandler;
import com.amazonaws.services.s3.internal.S3Signer;
import com.amazonaws.services.s3.internal.S3StringResponseHandler;
import com.amazonaws.services.s3.internal.S3V4AuthErrorRetryStrategy;
import com.amazonaws.services.s3.internal.S3VersionHeaderHandler;
import com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import com.amazonaws.services.s3.internal.SSEResultBase;
import com.amazonaws.services.s3.internal.ServerSideEncryptionHeaderHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.SetObjectTaggingResponseHeaderHandler;
import com.amazonaws.services.s3.internal.SkipMd5CheckStrategy;
import com.amazonaws.services.s3.internal.UploadObjectStrategy;
import com.amazonaws.services.s3.internal.UseArnRegionResolver;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.internal.auth.S3SignerProvider;
import com.amazonaws.services.s3.metrics.S3ServiceMetric;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketEncryptionRequest;
import com.amazonaws.services.s3.model.DeleteBucketEncryptionResult;
import com.amazonaws.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.DeleteBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.DeleteBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.ExpectedSourceBucketOwnerRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GenericBucketRequest;
import com.amazonaws.services.s3.model.GetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAclRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.GetBucketEncryptionResult;
import com.amazonaws.services.s3.model.GetBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.GetBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyStatusRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyStatusResult;
import com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectAclRequest;
import com.amazonaws.services.s3.model.GetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.GetObjectLegalHoldResult;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRetentionRequest;
import com.amazonaws.services.s3.model.GetObjectRetentionResult;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3.model.GetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.GetS3AccountOwnerRequest;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.HeadBucketResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketAnalyticsConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketIntelligentTieringConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketMetricsConfigurationsResult;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultiFactorAuthentication;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.PresignedUrlDownloadResult;
import com.amazonaws.services.s3.model.PresignedUrlUploadRequest;
import com.amazonaws.services.s3.model.PresignedUrlUploadResult;
import com.amazonaws.services.s3.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.RequestPaymentConfiguration;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.RestoreObjectResult;
import com.amazonaws.services.s3.model.RestoreRequestType;
import com.amazonaws.services.s3.model.S3AccelerateUnsupported;
import com.amazonaws.services.s3.model.S3DataSource;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParamsProvider;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SSECustomerKeyProvider;
import com.amazonaws.services.s3.model.SelectObjectContentEventStream;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.ServerSideEncryptionConfiguration;
import com.amazonaws.services.s3.model.SetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAclRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketAnalyticsConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketEncryptionRequest;
import com.amazonaws.services.s3.model.SetBucketEncryptionResult;
import com.amazonaws.services.s3.model.SetBucketIntelligentTieringConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketIntelligentTieringConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketMetricsConfigurationResult;
import com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.SetBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest;
import com.amazonaws.services.s3.model.SetObjectAclRequest;
import com.amazonaws.services.s3.model.SetObjectLegalHoldRequest;
import com.amazonaws.services.s3.model.SetObjectLegalHoldResult;
import com.amazonaws.services.s3.model.SetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.SetObjectLockConfigurationResult;
import com.amazonaws.services.s3.model.SetObjectRetentionRequest;
import com.amazonaws.services.s3.model.SetObjectRetentionResult;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.SetObjectTaggingResult;
import com.amazonaws.services.s3.model.SetPublicAccessBlockRequest;
import com.amazonaws.services.s3.model.SetPublicAccessBlockResult;
import com.amazonaws.services.s3.model.SetRequestPaymentConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.WriteGetObjectResponseRequest;
import com.amazonaws.services.s3.model.WriteGetObjectResponseResult;
import com.amazonaws.services.s3.model.analytics.AnalyticsConfiguration;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringConfiguration;
import com.amazonaws.services.s3.model.inventory.InventoryConfiguration;
import com.amazonaws.services.s3.model.metrics.MetricsConfiguration;
import com.amazonaws.services.s3.model.ownership.OwnershipControls;
import com.amazonaws.services.s3.model.transform.AclXmlFactory;
import com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.BucketNotificationConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.GetBucketEncryptionStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.GetBucketPolicyStatusStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.GetPublicAccessBlockStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.HeadBucketResultHandler;
import com.amazonaws.services.s3.model.transform.MultiObjectDeleteXmlFactory;
import com.amazonaws.services.s3.model.transform.ObjectLockConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.ObjectLockLegalHoldXmlFactory;
import com.amazonaws.services.s3.model.transform.ObjectLockRetentionXmlFactory;
import com.amazonaws.services.s3.model.transform.ObjectTaggingXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestPaymentConfigurationXmlFactory;
import com.amazonaws.services.s3.model.transform.RequestXmlFactory;
import com.amazonaws.services.s3.model.transform.Unmarshallers;
import com.amazonaws.services.s3.model.transform.XmlResponsesSaxParser;
import com.amazonaws.services.s3.request.S3HandlerContextKeys;
import com.amazonaws.services.s3.waiters.AmazonS3Waiters;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.Base16;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.RuntimeHttpUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.ServiceClientHolderInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.Throwables;
import com.amazonaws.util.UriResourcePathUtils;
import com.amazonaws.util.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

@ThreadSafe
public class AmazonS3Client
extends AmazonWebServiceClient
implements AmazonS3 {
    public static final String S3_SERVICE_NAME = "s3";
    private static final String S3_SIGNER = "S3SignerType";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    private static final String SERVICE_ID = "S3";
    private static final String AWS_PARTITION_KEY = "aws";
    private static final String S3_OUTPOSTS_NAME = "s3-outposts";
    private static final String S3_OBJECT_LAMBDAS_NAME = "s3-object-lambda";
    protected static final AmazonS3ClientConfigurationFactory configFactory = new AmazonS3ClientConfigurationFactory();
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private volatile AmazonS3Waiters waiters;
    protected final AWSCredentialsProvider awsCredentialsProvider;
    protected final S3ErrorResponseHandler errorResponseHandler;
    private final S3XmlResponseHandler<Void> voidResponseHandler = new S3XmlResponseHandler(null);
    private static final BucketConfigurationXmlFactory bucketConfigurationXmlFactory;
    private static final RequestPaymentConfigurationXmlFactory requestPaymentConfigurationXmlFactory;
    private static final UseArnRegionResolver USE_ARN_REGION_RESOLVER;
    private volatile S3ClientOptions clientOptions = S3ClientOptions.builder().build();
    private volatile String clientRegion;
    private static RegionalEndpointsOptionResolver REGIONAL_ENDPOINTS_OPTION_RESOLVER;
    private static final int BUCKET_REGION_CACHE_SIZE = 300;
    private static final Map<String, String> bucketRegionCache;
    private final SkipMd5CheckStrategy skipMd5CheckStrategy;
    private final CompleteMultipartUploadRetryCondition completeMultipartUploadRetryCondition = new CompleteMultipartUploadRetryCondition();

    static Map<String, String> getBucketRegionCache() {
        return bucketRegionCache;
    }

    @Deprecated
    public AmazonS3Client() {
        this(new S3CredentialsProviderChain());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentials aWSCredentials) {
        this(aWSCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration) {
        this(new StaticCredentialsProvider(aWSCredentials), clientConfiguration);
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this(aWSCredentialsProvider, clientConfiguration, requestMetricCollector, SkipMd5CheckStrategy.INSTANCE);
    }

    @SdkTestInternalApi
    AmazonS3Client(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector, SkipMd5CheckStrategy skipMd5CheckStrategy) {
        super(clientConfiguration, requestMetricCollector, true);
        this.awsCredentialsProvider = aWSCredentialsProvider;
        this.skipMd5CheckStrategy = skipMd5CheckStrategy;
        this.errorResponseHandler = new S3ErrorResponseHandler(clientConfiguration);
        this.init();
    }

    @Deprecated
    public AmazonS3Client(ClientConfiguration clientConfiguration) {
        this(new S3CredentialsProviderChain(), clientConfiguration);
    }

    @SdkInternalApi
    AmazonS3Client(AmazonS3ClientParams amazonS3ClientParams) {
        super(amazonS3ClientParams.getClientParams());
        this.awsCredentialsProvider = amazonS3ClientParams.getClientParams().getCredentialsProvider();
        this.skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
        this.setS3ClientOptions(amazonS3ClientParams.getS3ClientOptions());
        this.errorResponseHandler = new S3ErrorResponseHandler(amazonS3ClientParams.getClientParams().getClientConfiguration());
        this.init();
    }

    public static AmazonS3ClientBuilder builder() {
        return AmazonS3ClientBuilder.standard();
    }

    private void init() {
        this.setEndpoint("s3.amazonaws.com");
        HandlerChainFactory handlerChainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandlerChain("/com/amazonaws/services/s3/request.handlers"));
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3/request.handler2s"));
        this.requestHandler2s.addAll(handlerChainFactory.getGlobalHandlers());
    }

    @Override
    @Deprecated
    public synchronized void setEndpoint(String string) {
        if (ServiceUtils.isS3AccelerateEndpoint(string)) {
            throw new IllegalStateException("To enable accelerate mode, please use AmazonS3ClientBuilder.withAccelerateModeEnabled(true)");
        }
        super.setEndpoint(string);
        if (!ServiceUtils.isS3USStandardEndpoint(string)) {
            this.clientRegion = AwsHostNameUtils.parseRegionName(this.endpoint.getHost(), S3_SERVICE_NAME);
        }
    }

    @Override
    @Deprecated
    public synchronized void setRegion(com.amazonaws.regions.Region region) {
        if (region.getName().equalsIgnoreCase("us-east-1") && (this.clientOptions.isRegionalUsEast1EndpointEnabled() || REGIONAL_ENDPOINTS_OPTION_RESOLVER.useRegionalMode())) {
            region = RegionUtils.getRegion("us-east-1-regional");
        }
        super.setRegion(region);
        this.clientRegion = region.getName();
    }

    @Override
    public synchronized void setS3ClientOptions(S3ClientOptions s3ClientOptions) {
        this.checkMutability();
        this.clientOptions = new S3ClientOptions(s3ClientOptions);
    }

    @Override
    protected boolean useStrictHostNameVerification() {
        return false;
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing versionListing) throws SdkClientException, AmazonServiceException {
        return this.listNextBatchOfVersions(new ListNextBatchOfVersionsRequest(versionListing));
    }

    @Override
    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) {
        listNextBatchOfVersionsRequest = this.beforeClientExecution(listNextBatchOfVersionsRequest);
        this.rejectNull(listNextBatchOfVersionsRequest, "The request object parameter must be specified when listing the next batch of versions in a bucket");
        VersionListing versionListing = listNextBatchOfVersionsRequest.getPreviousVersionListing();
        if (!versionListing.isTruncated()) {
            VersionListing versionListing2 = new VersionListing();
            versionListing2.setBucketName(versionListing.getBucketName());
            versionListing2.setDelimiter(versionListing.getDelimiter());
            versionListing2.setKeyMarker(versionListing.getNextKeyMarker());
            versionListing2.setVersionIdMarker(versionListing.getNextVersionIdMarker());
            versionListing2.setMaxKeys(versionListing.getMaxKeys());
            versionListing2.setPrefix(versionListing.getPrefix());
            versionListing2.setEncodingType(versionListing.getEncodingType());
            versionListing2.setTruncated(false);
            return versionListing2;
        }
        return this.listVersions(listNextBatchOfVersionsRequest.toListVersionsRequest());
    }

    @Override
    public VersionListing listVersions(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.listVersions(new ListVersionsRequest(string, string2, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String string, String string2, String string3, String string4, String string5, Integer n) throws SdkClientException, AmazonServiceException {
        ListVersionsRequest listVersionsRequest = new ListVersionsRequest().withBucketName(string).withPrefix(string2).withDelimiter(string5).withKeyMarker(string3).withVersionIdMarker(string4).withMaxResults(n);
        return this.listVersions(listVersionsRequest);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws SdkClientException, AmazonServiceException {
        listVersionsRequest = this.beforeClientExecution(listVersionsRequest);
        this.rejectNull(listVersionsRequest.getBucketName(), "The bucket name parameter must be specified when listing versions in a bucket");
        boolean bl = listVersionsRequest.getEncodingType() == null;
        Request<ListVersionsRequest> request = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListObjectVersions");
        request.addParameter("versions", null);
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listVersionsRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "key-marker", listVersionsRequest.getKeyMarker());
        AmazonS3Client.addParameterIfNotNull(request, "version-id-marker", listVersionsRequest.getVersionIdMarker());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listVersionsRequest.getDelimiter());
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            request.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        request.addParameter("encoding-type", bl ? "url" : listVersionsRequest.getEncodingType());
        return this.invoke(request, new Unmarshallers.VersionListUnmarshaller(bl), listVersionsRequest.getBucketName(), null);
    }

    @Override
    public ObjectListing listObjects(String string) throws SdkClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(string, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(string, string2, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws SdkClientException, AmazonServiceException {
        listObjectsRequest = this.beforeClientExecution(listObjectsRequest);
        this.rejectNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        boolean bl = listObjectsRequest.getEncodingType() == null;
        Request<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), null, listObjectsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListObjects");
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listObjectsRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "marker", listObjectsRequest.getMarker());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listObjectsRequest.getDelimiter());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        request.addParameter("encoding-type", bl ? "url" : listObjectsRequest.getEncodingType());
        AmazonS3Client.populateRequesterPaysHeader(request, listObjectsRequest.isRequesterPays());
        return this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(bl), listObjectsRequest.getBucketName(), null);
    }

    @Override
    public ListObjectsV2Result listObjectsV2(String string) throws SdkClientException, AmazonServiceException {
        return this.listObjectsV2(new ListObjectsV2Request().withBucketName(string));
    }

    @Override
    public ListObjectsV2Result listObjectsV2(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.listObjectsV2(new ListObjectsV2Request().withBucketName(string).withPrefix(string2));
    }

    @Override
    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws SdkClientException, AmazonServiceException {
        listObjectsV2Request = this.beforeClientExecution(listObjectsV2Request);
        this.rejectNull(listObjectsV2Request.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        Request<ListObjectsV2Request> request = this.createRequest(listObjectsV2Request.getBucketName(), null, listObjectsV2Request, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListObjectsV2");
        request.addParameter("list-type", "2");
        AmazonS3Client.addParameterIfNotNull(request, "start-after", listObjectsV2Request.getStartAfter());
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listObjectsV2Request.getContinuationToken());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listObjectsV2Request.getDelimiter());
        AmazonS3Client.addParameterIfNotNull(request, "max-keys", listObjectsV2Request.getMaxKeys());
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listObjectsV2Request.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "encoding-type", listObjectsV2Request.getEncodingType());
        request.addParameter("fetch-owner", Boolean.toString(listObjectsV2Request.isFetchOwner()));
        AmazonS3Client.populateRequesterPaysHeader(request, listObjectsV2Request.isRequesterPays());
        boolean bl = "url".equals(listObjectsV2Request.getEncodingType());
        return this.invoke(request, new Unmarshallers.ListObjectsV2Unmarshaller(bl), listObjectsV2Request.getBucketName(), null);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) throws SdkClientException, AmazonServiceException {
        return this.listNextBatchOfObjects(new ListNextBatchOfObjectsRequest(objectListing));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws SdkClientException, AmazonServiceException {
        listNextBatchOfObjectsRequest = this.beforeClientExecution(listNextBatchOfObjectsRequest);
        this.rejectNull(listNextBatchOfObjectsRequest, "The request object parameter must be specified when listing the next batch of objects in a bucket");
        ObjectListing objectListing = listNextBatchOfObjectsRequest.getPreviousObjectListing();
        if (!objectListing.isTruncated()) {
            ObjectListing objectListing2 = new ObjectListing();
            objectListing2.setBucketName(objectListing.getBucketName());
            objectListing2.setDelimiter(objectListing.getDelimiter());
            objectListing2.setMarker(objectListing.getNextMarker());
            objectListing2.setMaxKeys(objectListing.getMaxKeys());
            objectListing2.setPrefix(objectListing.getPrefix());
            objectListing2.setEncodingType(objectListing.getEncodingType());
            objectListing2.setTruncated(false);
            return objectListing2;
        }
        return this.listObjects(listNextBatchOfObjectsRequest.toListObjectsRequest());
    }

    @Override
    public Owner getS3AccountOwner() throws SdkClientException, AmazonServiceException {
        return this.getS3AccountOwner(new GetS3AccountOwnerRequest());
    }

    @Override
    public Owner getS3AccountOwner(GetS3AccountOwnerRequest getS3AccountOwnerRequest) throws SdkClientException, AmazonServiceException {
        getS3AccountOwnerRequest = this.beforeClientExecution(getS3AccountOwnerRequest);
        this.rejectNull(getS3AccountOwnerRequest, "The request object parameter getS3AccountOwnerRequest must be specified.");
        Request<GetS3AccountOwnerRequest> request = this.createRequest(null, null, getS3AccountOwnerRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBuckets");
        return this.invoke(request, new Unmarshallers.ListBucketsOwnerUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws SdkClientException, AmazonServiceException {
        listBucketsRequest = this.beforeClientExecution(listBucketsRequest);
        this.rejectNull(listBucketsRequest, "The request object parameter listBucketsRequest must be specified.");
        Request<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBuckets");
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets() throws SdkClientException, AmazonServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws SdkClientException, AmazonServiceException {
        getBucketLocationRequest = this.beforeClientExecution(getBucketLocationRequest);
        this.rejectNull(getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String string = getBucketLocationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's location");
        Request<GetBucketLocationRequest> request = this.createRequest(string, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketLocation");
        request.addParameter("location", null);
        return this.invoke(request, new Unmarshallers.BucketLocationUnmarshaller(), string, null);
    }

    @Override
    public String getBucketLocation(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(string));
    }

    @Override
    public Bucket createBucket(String string) throws SdkClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(string));
    }

    @Override
    @Deprecated
    public Bucket createBucket(String string, Region region) throws SdkClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(string, region));
    }

    @Override
    @Deprecated
    public Bucket createBucket(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(string, string2));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws SdkClientException, AmazonServiceException {
        createBucketRequest = this.beforeClientExecution(createBucketRequest);
        this.rejectNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String string = createBucketRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when creating a bucket");
        string = string.trim();
        String string2 = createBucketRequest.getRegion();
        URI uRI = this.getCreateBucketEndpoint(string2);
        BucketNameUtils.validateBucketName(string);
        Request<CreateBucketRequest> request = this.createRequest(string, null, createBucketRequest, HttpMethodName.PUT, uRI);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateBucket");
        if (createBucketRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", createBucketRequest.getCannedAcl().toString());
        }
        if (this.getSignerRegion() != null && !this.getSignerRegion().equals("us-east-1") && StringUtils.isNullOrEmpty(string2)) {
            string2 = AwsHostNameUtils.parseRegion(uRI.getHost(), S3_SERVICE_NAME);
        }
        if (string2 != null && !StringUtils.upperCase(string2).equals(Region.US_Standard.toString())) {
            XmlWriter xmlWriter = new XmlWriter();
            xmlWriter.start("CreateBucketConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
            xmlWriter.start("LocationConstraint").value(string2).end();
            xmlWriter.end();
            request.setContent(new ByteArrayInputStream(xmlWriter.getBytes()));
        }
        if (createBucketRequest.getObjectLockEnabledForBucket()) {
            request.addHeader("x-amz-bucket-object-lock-enabled", "true");
        }
        if (createBucketRequest.getObjectOwnership() != null) {
            request.addHeader("x-amz-object-ownership", createBucketRequest.getObjectOwnership());
        }
        this.invoke(request, this.voidResponseHandler, string, null);
        return new Bucket(string);
    }

    private URI getCreateBucketEndpoint(String string) {
        if (string == null || string.equals(this.clientRegion) || !this.clientOptions.isForceGlobalBucketAccessEnabled()) {
            return this.endpoint;
        }
        com.amazonaws.regions.Region region = com.amazonaws.regions.Region.getRegion(Regions.fromName(string));
        return new DefaultServiceEndpointBuilder(this.getEndpointPrefix(), this.clientConfiguration.getProtocol().toString()).withRegion(region).getServiceEndpoint();
    }

    @Override
    public AccessControlList getObjectAcl(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(string, string2));
    }

    @Override
    public AccessControlList getObjectAcl(String string, String string2, String string3) throws SdkClientException, AmazonServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(string, string2, string3));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) {
        getObjectAclRequest = this.beforeClientExecution(getObjectAclRequest);
        this.rejectNull(getObjectAclRequest, "The request parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getKey(), "The key parameter must be specified when requesting an object's ACL");
        return this.getAcl(getObjectAclRequest.getBucketName(), getObjectAclRequest.getKey(), getObjectAclRequest.getVersionId(), getObjectAclRequest.isRequesterPays(), getObjectAclRequest);
    }

    @Override
    public void setObjectAcl(String string, String string2, AccessControlList accessControlList) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(string, string2, null, accessControlList);
    }

    @Override
    public void setObjectAcl(String string, String string2, CannedAccessControlList cannedAccessControlList) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(string, string2, null, cannedAccessControlList);
    }

    @Override
    public void setObjectAcl(String string, String string2, String string3, AccessControlList accessControlList) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(new SetObjectAclRequest(string, string2, string3, accessControlList));
    }

    public void setObjectAcl(String string, String string2, String string3, AccessControlList accessControlList, RequestMetricCollector requestMetricCollector) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl((SetObjectAclRequest)new SetObjectAclRequest(string, string2, string3, accessControlList).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(new SetObjectAclRequest(string, string2, string3, cannedAccessControlList));
    }

    public void setObjectAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList, RequestMetricCollector requestMetricCollector) {
        this.setObjectAcl((SetObjectAclRequest)new SetObjectAclRequest(string, string2, string3, cannedAccessControlList).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws SdkClientException, AmazonServiceException {
        setObjectAclRequest = this.beforeClientExecution(setObjectAclRequest);
        this.rejectNull(setObjectAclRequest, "The request must not be null.");
        this.rejectNull(setObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when setting an object's ACL");
        this.rejectNull(setObjectAclRequest.getKey(), "The key parameter must be specified when setting an object's ACL");
        if (setObjectAclRequest.getAcl() != null && setObjectAclRequest.getCannedAcl() != null) {
            throw new IllegalArgumentException("Only one of the ACL and CannedACL parameters can be specified, not both.");
        }
        if (setObjectAclRequest.getAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getAcl(), setObjectAclRequest.isRequesterPays(), (AmazonWebServiceRequest)setObjectAclRequest);
        } else if (setObjectAclRequest.getCannedAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getCannedAcl(), setObjectAclRequest.isRequesterPays(), (AmazonWebServiceRequest)setObjectAclRequest);
        } else {
            throw new IllegalArgumentException("At least one of the ACL and CannedACL parameters should be specified");
        }
    }

    @Override
    public AccessControlList getBucketAcl(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketAcl(new GetBucketAclRequest(string));
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws SdkClientException, AmazonServiceException {
        getBucketAclRequest = this.beforeClientExecution(getBucketAclRequest);
        String string = getBucketAclRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(string, null, null, false, getBucketAclRequest);
    }

    @Override
    public void setBucketAcl(String string, AccessControlList accessControlList) throws SdkClientException, AmazonServiceException {
        this.setBucketAcl(new SetBucketAclRequest(string, accessControlList));
    }

    public void setBucketAcl(String string, AccessControlList accessControlList, RequestMetricCollector requestMetricCollector) {
        SetBucketAclRequest setBucketAclRequest = (SetBucketAclRequest)new SetBucketAclRequest(string, accessControlList).withRequestMetricCollector(requestMetricCollector);
        this.setBucketAcl(setBucketAclRequest);
    }

    @Override
    public void setBucketAcl(String string, CannedAccessControlList cannedAccessControlList) throws SdkClientException, AmazonServiceException {
        this.setBucketAcl(new SetBucketAclRequest(string, cannedAccessControlList));
    }

    public void setBucketAcl(String string, CannedAccessControlList cannedAccessControlList, RequestMetricCollector requestMetricCollector) throws SdkClientException, AmazonServiceException {
        SetBucketAclRequest setBucketAclRequest = (SetBucketAclRequest)new SetBucketAclRequest(string, cannedAccessControlList).withRequestMetricCollector(requestMetricCollector);
        this.setBucketAcl(setBucketAclRequest);
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws SdkClientException, AmazonServiceException {
        setBucketAclRequest = this.beforeClientExecution(setBucketAclRequest);
        String string = setBucketAclRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's ACL");
        AccessControlList accessControlList = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAccessControlList = setBucketAclRequest.getCannedAcl();
        if (accessControlList == null && cannedAccessControlList == null) {
            throw new IllegalArgumentException("The ACL parameter must be specified when setting a bucket's ACL");
        }
        if (accessControlList != null && cannedAccessControlList != null) {
            throw new IllegalArgumentException("Only one of the acl and cannedAcl parameter can be specified, not both.");
        }
        if (accessControlList != null) {
            this.setAcl(string, null, null, accessControlList, false, (AmazonWebServiceRequest)setBucketAclRequest);
        } else {
            this.setAcl(string, null, null, cannedAccessControlList, false, (AmazonWebServiceRequest)setBucketAclRequest);
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(string, string2));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws SdkClientException, AmazonServiceException {
        getObjectMetadataRequest = this.beforeClientExecution(getObjectMetadataRequest);
        this.rejectNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String string = getObjectMetadataRequest.getBucketName();
        String string2 = getObjectMetadataRequest.getKey();
        String string3 = getObjectMetadataRequest.getVersionId();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(string2, "The key parameter must be specified when requesting an object's metadata");
        Request<GetObjectMetadataRequest> request = this.createRequest(string, string2, getObjectMetadataRequest, HttpMethodName.HEAD);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "HeadObject");
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectMetadataRequest.isRequesterPays());
        this.addPartNumberIfNotNull(request, getObjectMetadataRequest.getPartNumber());
        AmazonS3Client.populateSSE_C(request, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(request, new S3MetadataResponseHandler(), string, string2);
    }

    @Override
    public S3Object getObject(String string, String string2) throws SdkClientException, AmazonServiceException {
        return this.getObject(new GetObjectRequest(string, string2));
    }

    @Override
    public boolean doesBucketExist(String string) throws SdkClientException, AmazonServiceException {
        try {
            ValidationUtils.assertStringNotEmpty(string, "bucketName");
            this.headBucket(new HeadBucketRequest(string));
            return true;
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getStatusCode() == 301 || amazonServiceException.getStatusCode() == 403) {
                return true;
            }
            if (amazonServiceException.getStatusCode() == 404) {
                return false;
            }
            throw amazonServiceException;
        }
    }

    @Override
    public boolean doesBucketExistV2(String string) throws SdkClientException {
        try {
            ValidationUtils.assertStringNotEmpty(string, "bucketName");
            this.getBucketAcl(string);
            return true;
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getStatusCode() == 301 || "AccessDenied".equals(amazonServiceException.getErrorCode())) {
                return true;
            }
            if (amazonServiceException.getStatusCode() == 404) {
                return false;
            }
            throw amazonServiceException;
        }
    }

    @Override
    public boolean doesObjectExist(String string, String string2) throws AmazonServiceException, SdkClientException {
        try {
            ValidationUtils.assertStringNotEmpty(string, "bucketName");
            ValidationUtils.assertStringNotEmpty(string2, "objectName");
            this.getObjectMetadata(string, string2);
            return true;
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 404) {
                return false;
            }
            throw amazonS3Exception;
        }
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws SdkClientException, AmazonServiceException {
        headBucketRequest = this.beforeClientExecution(headBucketRequest);
        String string = headBucketRequest.getBucketName();
        this.rejectNull(string, "The bucketName parameter must be specified.");
        Request<HeadBucketRequest> request = this.createRequest(string, null, headBucketRequest, HttpMethodName.HEAD);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "HeadBucket");
        return this.invoke(request, new HeadBucketResultHandler(), string, null);
    }

    @Override
    public void changeObjectStorageClass(String string, String string2, StorageClass storageClass) throws SdkClientException, AmazonServiceException {
        this.rejectNull(string, "The bucketName parameter must be specified when changing an object's storage class");
        this.rejectNull(string2, "The key parameter must be specified when changing an object's storage class");
        this.rejectNull((Object)storageClass, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(string, string2, string, string2).withStorageClass(storageClass.toString()));
    }

    @Override
    public void setObjectRedirectLocation(String string, String string2, String string3) throws SdkClientException, AmazonServiceException {
        this.rejectNull(string, "The bucketName parameter must be specified when changing an object's storage class");
        this.rejectNull(string2, "The key parameter must be specified when changing an object's storage class");
        this.rejectNull(string3, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(string, string2, string, string2).withRedirectLocation(string3));
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws SdkClientException, AmazonServiceException {
        getObjectRequest = this.beforeClientExecution(getObjectRequest);
        ValidationUtils.assertNotNull(getObjectRequest, "GetObjectRequest");
        ValidationUtils.assertStringNotEmpty(getObjectRequest.getBucketName(), "BucketName");
        ValidationUtils.assertStringNotEmpty(getObjectRequest.getKey(), "Key");
        Request<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObject");
        request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, Boolean.TRUE);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        this.addPartNumberIfNotNull(request, getObjectRequest.getPartNumber());
        long[] lArray = getObjectRequest.getRange();
        if (lArray != null) {
            request.addHeader("Range", "bytes=" + Long.toString(lArray[0]) + "-" + Long.toString(lArray[1]));
        }
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectRequest.isRequesterPays());
        AmazonS3Client.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        AmazonS3Client.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        AmazonS3Client.populateSSE_C(request, getObjectRequest.getSSECustomerKey());
        ProgressListener progressListener = getObjectRequest.getGeneralProgressListener();
        SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_STARTED_EVENT);
        try {
            S3Object s3Object = this.invoke(request, new S3ObjectResponseHandler(), getObjectRequest.getBucketName(), getObjectRequest.getKey());
            s3Object.setBucketName(getObjectRequest.getBucketName());
            s3Object.setKey(getObjectRequest.getKey());
            boolean bl = this.skipMd5CheckStrategy.skipClientSideValidation(getObjectRequest, s3Object.getObjectMetadata());
            this.postProcessS3Object(s3Object, bl, progressListener);
            return s3Object;
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 412 || amazonS3Exception.getStatusCode() == 304) {
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_CANCELED_EVENT);
                return null;
            }
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw amazonS3Exception;
        }
    }

    private void postProcessS3Object(S3Object s3Object, boolean bl, ProgressListener progressListener) {
        Object object;
        FilterInputStream filterInputStream = s3Object.getObjectContent();
        HttpRequestBase httpRequestBase = s3Object.getObjectContent().getHttpRequest();
        filterInputStream = new ServiceClientHolderInputStream(filterInputStream, this);
        ProgressInputStream progressInputStream = new ProgressInputStream(filterInputStream, progressListener){

            @Override
            protected void onEOF() {
                SDKProgressPublisher.publishProgress(this.getListener(), ProgressEventType.TRANSFER_COMPLETED_EVENT);
            }
        };
        filterInputStream = progressInputStream;
        if (!bl) {
            object = BinaryUtils.fromHex(s3Object.getObjectMetadata().getETag());
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                filterInputStream = new DigestValidationInputStream(filterInputStream, messageDigest, (byte[])object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                log.warn("No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", noSuchAlgorithmException);
            }
        } else {
            object = s3Object.getObjectMetadata().getRawMetadataValue("Content-Length");
            if (object != null) {
                filterInputStream = new LengthCheckInputStream(filterInputStream, s3Object.getObjectMetadata().getContentLength(), true);
            }
        }
        object = new S3AbortableInputStream(filterInputStream, httpRequestBase, s3Object.getObjectMetadata().getContentLength());
        s3Object.setObjectContent(new S3ObjectInputStream((InputStream)object, httpRequestBase, false));
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File file) throws SdkClientException, AmazonServiceException {
        this.rejectNull(file, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(file, new ServiceUtils.RetryableS3DownloadTask(){

            @Override
            public S3Object getS3ObjectStream() {
                return AmazonS3Client.this.getObject(getObjectRequest);
            }

            @Override
            public boolean needIntegrityCheck() {
                return !AmazonS3Client.this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(getObjectRequest);
            }
        }, false);
        if (s3Object == null) {
            return null;
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public String getObjectAsString(String string, String string2) throws AmazonServiceException, SdkClientException {
        this.rejectNull(string, "Bucket name must be provided");
        this.rejectNull(string2, "Object key must be provided");
        S3Object s3Object = this.getObject(string, string2);
        try {
            String string3 = IOUtils.toString(s3Object.getObjectContent());
            return string3;
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error streaming content from S3 during download", iOException);
        }
        finally {
            IOUtils.closeQuietly(s3Object, log);
        }
    }

    @Override
    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        getObjectTaggingRequest = this.beforeClientExecution(getObjectTaggingRequest);
        this.rejectNull(getObjectTaggingRequest, "The request parameter must be specified when getting the object tags");
        String string = ValidationUtils.assertStringNotEmpty(getObjectTaggingRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertNotNull(getObjectTaggingRequest.getKey(), "Key");
        Request<GetObjectTaggingRequest> request = this.createRequest(string, string2, getObjectTaggingRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObjectTagging");
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", getObjectTaggingRequest.getVersionId());
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectTaggingRequest.isRequesterPays());
        ResponseHeaderHandlerChain<GetObjectTaggingResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<GetObjectTaggingResult>(new Unmarshallers.GetObjectTaggingResponseUnmarshaller(), new GetObjectTaggingResponseHeaderHandler());
        return (GetObjectTaggingResult)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    @Override
    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        setObjectTaggingRequest = this.beforeClientExecution(setObjectTaggingRequest);
        this.rejectNull(setObjectTaggingRequest, "The request parameter must be specified setting the object tags");
        String string = ValidationUtils.assertStringNotEmpty(setObjectTaggingRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertNotNull(setObjectTaggingRequest.getKey(), "Key");
        ObjectTagging objectTagging = ValidationUtils.assertNotNull(setObjectTaggingRequest.getTagging(), "ObjectTagging");
        Request<SetObjectTaggingRequest> request = this.createRequest(string, string2, setObjectTaggingRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObjectTagging");
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", setObjectTaggingRequest.getVersionId());
        byte[] byArray = new ObjectTaggingXmlFactory().convertToXmlByteArray(objectTagging);
        this.setContent(request, byArray, "application/xml", true);
        AmazonS3Client.populateRequesterPaysHeader(request, setObjectTaggingRequest.isRequesterPays());
        ResponseHeaderHandlerChain<SetObjectTaggingResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<SetObjectTaggingResult>(new Unmarshallers.SetObjectTaggingResponseUnmarshaller(), new SetObjectTaggingResponseHeaderHandler());
        return (SetObjectTaggingResult)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    @Override
    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        deleteObjectTaggingRequest = this.beforeClientExecution(deleteObjectTaggingRequest);
        this.rejectNull(deleteObjectTaggingRequest, "The request parameter must be specified when delete the object tags");
        String string = ValidationUtils.assertStringNotEmpty(deleteObjectTaggingRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(deleteObjectTaggingRequest.getKey(), "Key");
        Request<DeleteObjectTaggingRequest> request = this.createRequest(string, string2, deleteObjectTaggingRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteObjectTagging");
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", deleteObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<DeleteObjectTaggingResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<DeleteObjectTaggingResult>(new Unmarshallers.DeleteObjectTaggingResponseUnmarshaller(), new DeleteObjectTaggingHeaderHandler());
        return (DeleteObjectTaggingResult)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    @Override
    public void deleteBucket(String string) throws SdkClientException, AmazonServiceException {
        this.deleteBucket(new DeleteBucketRequest(string));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws SdkClientException, AmazonServiceException {
        deleteBucketRequest = this.beforeClientExecution(deleteBucketRequest);
        this.rejectNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String string = deleteBucketRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting a bucket");
        Request<DeleteBucketRequest> request = this.createRequest(string, null, deleteBucketRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucket");
        this.invoke(request, this.voidResponseHandler, string, null);
        bucketRegionCache.remove(string);
    }

    @Override
    public PutObjectResult putObject(String string, String string2, File file) throws SdkClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(string, string2, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) throws SdkClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(string, string2, inputStream2, objectMetadata));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws SdkClientException, AmazonServiceException {
        Object object;
        putObjectRequest = this.beforeClientExecution(putObjectRequest);
        this.rejectNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        File file = putObjectRequest.getFile();
        InputStream inputStream2 = putObjectRequest.getInputStream();
        String string = putObjectRequest.getBucketName();
        String string2 = putObjectRequest.getKey();
        ProgressListener progressListener = putObjectRequest.getGeneralProgressListener();
        this.rejectNull(string, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(string2, "The key parameter must be specified when uploading an object");
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        Request<PutObjectRequest> request = this.createRequest(string, string2, putObjectRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObject");
        request.addHandlerContext(HandlerContextKey.REQUIRES_LENGTH, Boolean.TRUE);
        request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, Boolean.TRUE);
        Integer n = Constants.getS3StreamBufferSize();
        if (n != null) {
            object = request.getOriginalRequest();
            ((AmazonWebServiceRequest)object).getRequestClientOptions().setReadLimit(n);
        }
        if (putObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, putObjectRequest.getAccessControlList());
        } else if (putObjectRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", putObjectRequest.getCannedAcl().toString());
        }
        if (putObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", putObjectRequest.getStorageClass());
        }
        if (putObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", putObjectRequest.getRedirectLocation());
        }
        if ((object = putObjectRequest.getBucketKeyEnabled()) != null) {
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-bucket-key-enabled", String.valueOf(object));
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-tagging", this.urlEncodeTags(putObjectRequest.getTagging()));
        AmazonS3Client.populateRequesterPaysHeader(request, putObjectRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, putObjectRequest.getSSECustomerKey());
        AmazonS3Client.populateSSE_KMS(request, putObjectRequest.getSSEAwsKeyManagementParams());
        AmazonS3Client.populateObjectLockHeaders(request, putObjectRequest.getObjectLockMode(), putObjectRequest.getObjectLockRetainUntilDate(), putObjectRequest.getObjectLockLegalHoldStatus());
        return this.uploadObject(inputStream2, file, objectMetadata, progressListener, request, putObjectRequest, this.skipMd5CheckStrategy.skipServerSideValidation(putObjectRequest), this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(putObjectRequest), new PutObjectStrategy(string, string2), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RequestT, ResponseT> ResponseT uploadObject(InputStream inputStream2, File file, ObjectMetadata objectMetadata, ProgressListener progressListener, Request<RequestT> request, S3DataSource s3DataSource, boolean bl, boolean bl2, UploadObjectStrategy<RequestT, ResponseT> uploadObjectStrategy, boolean bl3) {
        byte[] byArray;
        byte[] byArray2;
        ObjectMetadata objectMetadata2;
        InputStream inputStream3 = this.getInputStream(inputStream2, file, objectMetadata, request, bl, bl3);
        MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream = null;
        try {
            if (objectMetadata.getContentMD5() == null && !bl2) {
                mD5DigestCalculatingInputStream = new MD5DigestCalculatingInputStream(inputStream3);
                inputStream3 = mD5DigestCalculatingInputStream;
            }
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
            request.setContent(inputStream3);
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_STARTED_EVENT);
            try {
                objectMetadata2 = uploadObjectStrategy.invokeServiceCall(request);
            }
            catch (Throwable throwable) {
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_FAILED_EVENT);
                throw Throwables.failure(throwable);
            }
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(s3DataSource, file, inputStream2, inputStream3, log);
        }
        String string = objectMetadata.getContentMD5();
        if (mD5DigestCalculatingInputStream != null) {
            string = Base64.encodeAsString(mD5DigestCalculatingInputStream.getMd5Digest());
        }
        String string2 = objectMetadata2.getETag();
        if (string != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerPutResponse(objectMetadata2) && !Arrays.equals(byArray2 = BinaryUtils.fromBase64(string), byArray = BinaryUtils.fromHex(string2))) {
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw new SdkClientException("Unable to verify integrity of data upload. Client calculated content hash (contentMD5: " + string + " in base 64) didn't match hash (etag: " + string2 + " in hex) calculated by Amazon S3.  You may need to delete the data stored in Amazon S3. (metadata.contentMD5: " + objectMetadata.getContentMD5() + ", md5DigestStream: " + mD5DigestCalculatingInputStream + uploadObjectStrategy.md5ValidationErrorSuffix() + ")");
        }
        SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        return uploadObjectStrategy.createResult(objectMetadata2, string);
    }

    private InputStream getInputStream(InputStream inputStream2, File file, ObjectMetadata objectMetadata, Request<?> request, boolean bl, boolean bl2) {
        Long l;
        InputStream inputStream3 = inputStream2;
        if (file == null) {
            if (inputStream3 != null) {
                inputStream3 = ReleasableInputStream.wrap(inputStream3);
            }
        } else {
            boolean bl3;
            objectMetadata.setContentLength(file.length());
            boolean bl4 = bl3 = objectMetadata.getContentMD5() == null;
            if (objectMetadata.getContentType() == null && bl2) {
                objectMetadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            if (bl3 && !bl) {
                try {
                    String string = Md5Utils.md5AsBase64(file);
                    objectMetadata.setContentMD5(string);
                }
                catch (Exception exception) {
                    throw new SdkClientException("Unable to calculate MD5 hash: " + exception.getMessage(), exception);
                }
            }
            inputStream3 = ResettableInputStream.newResettableInputStream(file, "Unable to find file to upload");
        }
        if (objectMetadata.getContentType() == null && bl2) {
            objectMetadata.setContentType("application/octet-stream");
        }
        if (request.getHeaders().get("x-amz-website-redirect-location") != null && inputStream3 == null) {
            inputStream3 = new ByteArrayInputStream(new byte[0]);
        }
        if ((l = (Long)objectMetadata.getRawMetadataValue("Content-Length")) == null) {
            log.warn("No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
        } else {
            long l2 = l;
            if (l2 >= 0L) {
                LengthCheckInputStream lengthCheckInputStream = new LengthCheckInputStream(inputStream3, l2, false);
                inputStream3 = lengthCheckInputStream;
            }
        }
        return inputStream3;
    }

    private static PutObjectResult createPutObjectResult(ObjectMetadata objectMetadata) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.setVersionId(objectMetadata.getVersionId());
        putObjectResult.setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
        putObjectResult.setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
        putObjectResult.setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
        putObjectResult.setExpirationTime(objectMetadata.getExpirationTime());
        putObjectResult.setExpirationTimeRuleId(objectMetadata.getExpirationTimeRuleId());
        putObjectResult.setETag(objectMetadata.getETag());
        putObjectResult.setMetadata(objectMetadata);
        putObjectResult.setRequesterCharged(objectMetadata.isRequesterCharged());
        putObjectResult.setBucketKeyEnabled(objectMetadata.getBucketKeyEnabled());
        return putObjectResult;
    }

    private static void addAclHeaders(Request<? extends AmazonWebServiceRequest> request, AccessControlList accessControlList) {
        List<Grant> list = accessControlList.getGrantsAsList();
        HashMap hashMap = new HashMap();
        for (Grant grant : list) {
            if (!hashMap.containsKey((Object)grant.getPermission())) {
                hashMap.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)hashMap.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!hashMap.containsKey((Object)permission)) continue;
            Collection collection = (Collection)hashMap.get((Object)permission);
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (Grantee grantee : collection) {
                if (!bl) {
                    bl = true;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            request.addHeader(permission.getHeaderName(), stringBuilder.toString());
        }
    }

    @Override
    public CopyObjectResult copyObject(String string, String string2, String string3, String string4) throws SdkClientException, AmazonServiceException {
        return this.copyObject(new CopyObjectRequest(string, string2, string3, string4));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws SdkClientException, AmazonServiceException {
        Object object;
        copyObjectRequest = this.beforeClientExecution(copyObjectRequest);
        this.rejectNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String string = copyObjectRequest.getDestinationKey();
        String string2 = copyObjectRequest.getDestinationBucketName();
        Request<CopyObjectRequest> request = this.createRequest(string2, string, copyObjectRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CopyObject");
        Boolean bl = copyObjectRequest.getBucketKeyEnabled();
        if (bl != null) {
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-bucket-key-enabled", String.valueOf(bl));
        }
        this.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        AmazonS3Client.populateSSE_KMS(request, copyObjectRequest.getSSEAwsKeyManagementParams());
        AmazonS3Client.populateObjectLockHeaders(request, copyObjectRequest.getObjectLockMode(), copyObjectRequest.getObjectLockRetainUntilDate(), copyObjectRequest.getObjectLockLegalHoldStatus());
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            object = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler(), new ObjectExpirationHeaderHandler(), new S3RequesterChargedHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke((Request)request, (HttpResponseHandler)object, string2, string);
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 412) {
                return null;
            }
            throw amazonS3Exception;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            object = copyObjectResultHandler.getErrorCode();
            String string3 = copyObjectResultHandler.getErrorMessage();
            String string4 = copyObjectResultHandler.getErrorRequestId();
            String string5 = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception amazonS3Exception = new AmazonS3Exception(string3);
            amazonS3Exception.setErrorCode((String)object);
            amazonS3Exception.setErrorType(AmazonServiceException.ErrorType.Service);
            amazonS3Exception.setRequestId(string4);
            amazonS3Exception.setExtendedRequestId(string5);
            amazonS3Exception.setServiceName(request.getServiceName());
            amazonS3Exception.setStatusCode(200);
            amazonS3Exception.setProxyHost(this.clientConfiguration.getProxyHost());
            throw amazonS3Exception;
        }
        object = new CopyObjectResult();
        ((CopyObjectResult)object).setETag(copyObjectResultHandler.getETag());
        ((CopyObjectResult)object).setLastModifiedDate(copyObjectResultHandler.getLastModified());
        ((CopyObjectResult)object).setVersionId(copyObjectResultHandler.getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        ((SSEResultBase)object).setBucketKeyEnabled(copyObjectResultHandler.getBucketKeyEnabled());
        ((CopyObjectResult)object).setExpirationTime(copyObjectResultHandler.getExpirationTime());
        ((CopyObjectResult)object).setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        ((CopyObjectResult)object).setRequesterCharged(copyObjectResultHandler.isRequesterCharged());
        return object;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        Object object;
        copyPartRequest = this.beforeClientExecution(copyPartRequest);
        this.rejectNull(copyPartRequest.getSourceBucketName(), "The source bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getSourceKey(), "The source object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getUploadId(), "The upload id must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationKey(), "The destination object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getPartNumber(), "The part number must be specified when copying a part");
        String string = copyPartRequest.getDestinationKey();
        String string2 = copyPartRequest.getDestinationBucketName();
        Request<CopyPartRequest> request = this.createRequest(string2, string, copyPartRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UploadPartCopy");
        this.populateRequestWithCopyPartParameters(request, copyPartRequest);
        request.addParameter("uploadId", copyPartRequest.getUploadId());
        request.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
        AmazonS3Client.populateRequesterPaysHeader(request, copyPartRequest.isRequesterPays());
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            object = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke((Request)request, (HttpResponseHandler)object, string2, string);
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 412) {
                return null;
            }
            throw amazonS3Exception;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            object = copyObjectResultHandler.getErrorCode();
            String string3 = copyObjectResultHandler.getErrorMessage();
            String string4 = copyObjectResultHandler.getErrorRequestId();
            String string5 = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception amazonS3Exception = new AmazonS3Exception(string3);
            amazonS3Exception.setErrorCode((String)object);
            amazonS3Exception.setErrorType(AmazonServiceException.ErrorType.Service);
            amazonS3Exception.setRequestId(string4);
            amazonS3Exception.setExtendedRequestId(string5);
            amazonS3Exception.setServiceName(request.getServiceName());
            amazonS3Exception.setStatusCode(200);
            amazonS3Exception.setProxyHost(this.clientConfiguration.getProxyHost());
            throw amazonS3Exception;
        }
        object = new CopyPartResult();
        ((CopyPartResult)object).setETag(copyObjectResultHandler.getETag());
        ((CopyPartResult)object).setPartNumber(copyPartRequest.getPartNumber());
        ((CopyPartResult)object).setLastModifiedDate(copyObjectResultHandler.getLastModified());
        ((CopyPartResult)object).setVersionId(copyObjectResultHandler.getVersionId());
        ((SSEResultBase)object).setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        ((SSEResultBase)object).setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        ((SSEResultBase)object).setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        ((SSEResultBase)object).setBucketKeyEnabled(copyObjectResultHandler.getBucketKeyEnabled());
        return object;
    }

    @Override
    public void deleteObject(String string, String string2) throws SdkClientException, AmazonServiceException {
        this.deleteObject(new DeleteObjectRequest(string, string2));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws SdkClientException, AmazonServiceException {
        deleteObjectRequest = this.beforeClientExecution(deleteObjectRequest);
        this.rejectNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        Request<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteObject");
        this.invoke(request, this.voidResponseHandler, deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey());
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        deleteObjectsRequest = this.beforeClientExecution(deleteObjectsRequest);
        Request<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteObjects");
        request.addParameter("delete", null);
        if (deleteObjectsRequest.getBypassGovernanceRetention()) {
            request.addHeader("x-amz-bypass-governance-retention", "true");
        }
        if (deleteObjectsRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteObjectsRequest.getMfa());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, deleteObjectsRequest.isRequesterPays());
        byte[] byArray = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        ResponseHeaderHandlerChain<DeleteObjectsResponse> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<DeleteObjectsResponse>(new Unmarshallers.DeleteObjectsResultUnmarshaller(), new S3RequesterChargedHeaderHandler());
        DeleteObjectsResponse deleteObjectsResponse = (DeleteObjectsResponse)this.invoke(request, responseHeaderHandlerChain, deleteObjectsRequest.getBucketName(), null);
        if (!deleteObjectsResponse.getErrors().isEmpty()) {
            Map<String, String> map = responseHeaderHandlerChain.getResponseHeaders();
            MultiObjectDeleteException multiObjectDeleteException = new MultiObjectDeleteException(deleteObjectsResponse.getErrors(), deleteObjectsResponse.getDeletedObjects());
            multiObjectDeleteException.setStatusCode(200);
            multiObjectDeleteException.setRequestId(map.get("x-amz-request-id"));
            multiObjectDeleteException.setExtendedRequestId(map.get("x-amz-id-2"));
            multiObjectDeleteException.setCloudFrontId(map.get("X-Amz-Cf-Id"));
            multiObjectDeleteException.setProxyHost(this.clientConfiguration.getProxyHost());
            throw multiObjectDeleteException;
        }
        DeleteObjectsResult deleteObjectsResult = new DeleteObjectsResult(deleteObjectsResponse.getDeletedObjects(), deleteObjectsResponse.isRequesterCharged());
        return deleteObjectsResult;
    }

    @Override
    public void deleteVersion(String string, String string2, String string3) throws SdkClientException, AmazonServiceException {
        this.deleteVersion(new DeleteVersionRequest(string, string2, string3));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws SdkClientException, AmazonServiceException {
        deleteVersionRequest = this.beforeClientExecution(deleteVersionRequest);
        this.rejectNull(deleteVersionRequest, "The delete version request object must be specified when deleting a version");
        String string = deleteVersionRequest.getBucketName();
        String string2 = deleteVersionRequest.getKey();
        String string3 = deleteVersionRequest.getVersionId();
        this.rejectNull(string, "The bucket name must be specified when deleting a version");
        this.rejectNull(string2, "The key must be specified when deleting a version");
        this.rejectNull(string3, "The version ID must be specified when deleting a version");
        Request<DeleteVersionRequest> request = this.createRequest(string, string2, deleteVersionRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteObject");
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        if (deleteVersionRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteVersionRequest.getMfa());
        }
        if (deleteVersionRequest.getBypassGovernanceRetention()) {
            request.addHeader("x-amz-bypass-governance-retention", "true");
        }
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketVersioningConfigurationRequest = this.beforeClientExecution(setBucketVersioningConfigurationRequest);
        this.rejectNull(setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String string = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration bucketVersioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting versioning configuration");
        this.rejectNull(bucketVersioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        if (bucketVersioningConfiguration.isMfaDeleteEnabled() != null) {
            this.rejectNull(setBucketVersioningConfigurationRequest.getMfa(), "The MFA parameter must be specified when changing MFA Delete status in the versioning configuration");
        }
        Request<SetBucketVersioningConfigurationRequest> request = this.createRequest(string, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketVersioning");
        request.addParameter("versioning", null);
        if (bucketVersioningConfiguration.isMfaDeleteEnabled() != null && setBucketVersioningConfigurationRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, setBucketVersioningConfigurationRequest.getMfa());
        }
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketVersioningConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketVersioningConfiguration(new GetBucketVersioningConfigurationRequest(string));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws SdkClientException, AmazonServiceException {
        getBucketVersioningConfigurationRequest = this.beforeClientExecution(getBucketVersioningConfigurationRequest);
        this.rejectNull(getBucketVersioningConfigurationRequest, "The request object parameter getBucketVersioningConfigurationRequest must be specified.");
        String string = getBucketVersioningConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when querying versioning configuration");
        Request<GetBucketVersioningConfigurationRequest> request = this.createRequest(string, null, getBucketVersioningConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketVersioning");
        request.addParameter("versioning", null);
        return this.invoke(request, new Unmarshallers.BucketVersioningConfigurationUnmarshaller(), string, null);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketWebsiteConfiguration(new GetBucketWebsiteConfigurationRequest(string));
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws SdkClientException, AmazonServiceException {
        getBucketWebsiteConfigurationRequest = this.beforeClientExecution(getBucketWebsiteConfigurationRequest);
        this.rejectNull(getBucketWebsiteConfigurationRequest, "The request object parameter getBucketWebsiteConfigurationRequest must be specified.");
        String string = getBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's website configuration");
        Request<GetBucketWebsiteConfigurationRequest> request = this.createRequest(string, null, getBucketWebsiteConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketWebsite");
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        try {
            return this.invoke(request, new Unmarshallers.BucketWebsiteConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getStatusCode() == 404) {
                return null;
            }
            throw amazonServiceException;
        }
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String string) {
        return this.getBucketLifecycleConfiguration(new GetBucketLifecycleConfigurationRequest(string));
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        getBucketLifecycleConfigurationRequest = this.beforeClientExecution(getBucketLifecycleConfigurationRequest);
        this.rejectNull(getBucketLifecycleConfigurationRequest, "The request object pamameter getBucketLifecycleConfigurationRequest must be specified.");
        String string = getBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        Request<GetBucketLifecycleConfigurationRequest> request = this.createRequest(string, null, getBucketLifecycleConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketLifecycleConfiguration");
        request.addParameter("lifecycle", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            switch (amazonServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketLifecycleConfiguration(String string, BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(string, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) {
        setBucketLifecycleConfigurationRequest = this.beforeClientExecution(setBucketLifecycleConfigurationRequest);
        this.rejectNull(setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String string = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        Request<SetBucketLifecycleConfigurationRequest> request = this.createRequest(string, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketLifecycleConfiguration");
        request.addParameter("lifecycle", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String string) {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(string));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        deleteBucketLifecycleConfigurationRequest = this.beforeClientExecution(deleteBucketLifecycleConfigurationRequest);
        this.rejectNull(deleteBucketLifecycleConfigurationRequest, "The delete bucket lifecycle configuration request object must be specified.");
        String string = deleteBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        Request<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(string, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketLifecycle");
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String string) {
        return this.getBucketCrossOriginConfiguration(new GetBucketCrossOriginConfigurationRequest(string));
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) {
        getBucketCrossOriginConfigurationRequest = this.beforeClientExecution(getBucketCrossOriginConfigurationRequest);
        this.rejectNull(getBucketCrossOriginConfigurationRequest, "The request object parameter getBucketCrossOriginConfigurationRequest must be specified.");
        String string = getBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket cross origin configuration.");
        Request<GetBucketCrossOriginConfigurationRequest> request = this.createRequest(string, null, getBucketCrossOriginConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketCors");
        request.addParameter("cors", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            switch (amazonServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String string, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(string, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) {
        setBucketCrossOriginConfigurationRequest = this.beforeClientExecution(setBucketCrossOriginConfigurationRequest);
        this.rejectNull(setBucketCrossOriginConfigurationRequest, "The set bucket cross origin configuration request object must be specified.");
        String string = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket cross origin configuration.");
        this.rejectNull(bucketCrossOriginConfiguration, "The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        Request<SetBucketCrossOriginConfigurationRequest> request = this.createRequest(string, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketCors");
        request.addParameter("cors", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String string) {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(string));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) {
        deleteBucketCrossOriginConfigurationRequest = this.beforeClientExecution(deleteBucketCrossOriginConfigurationRequest);
        this.rejectNull(deleteBucketCrossOriginConfigurationRequest, "The delete bucket cross origin configuration request object must be specified.");
        String string = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        Request<DeleteBucketCrossOriginConfigurationRequest> request = this.createRequest(string, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketCors");
        request.addParameter("cors", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(String string) {
        return this.getBucketTaggingConfiguration(new GetBucketTaggingConfigurationRequest(string));
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest getBucketTaggingConfigurationRequest) {
        getBucketTaggingConfigurationRequest = this.beforeClientExecution(getBucketTaggingConfigurationRequest);
        this.rejectNull(getBucketTaggingConfigurationRequest, "The request object parameter getBucketTaggingConfigurationRequest must be specifed.");
        String string = getBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when retrieving the bucket tagging configuration.");
        Request<GetBucketTaggingConfigurationRequest> request = this.createRequest(string, null, getBucketTaggingConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketTagging");
        request.addParameter("tagging", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketTaggingConfigurationUnmarshaller(), string, null);
        }
        catch (AmazonServiceException amazonServiceException) {
            switch (amazonServiceException.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketTaggingConfiguration(String string, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.setBucketTaggingConfiguration(new SetBucketTaggingConfigurationRequest(string, bucketTaggingConfiguration));
    }

    @Override
    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        setBucketTaggingConfigurationRequest = this.beforeClientExecution(setBucketTaggingConfigurationRequest);
        this.rejectNull(setBucketTaggingConfigurationRequest, "The set bucket tagging configuration request object must be specified.");
        String string = setBucketTaggingConfigurationRequest.getBucketName();
        BucketTaggingConfiguration bucketTaggingConfiguration = setBucketTaggingConfigurationRequest.getTaggingConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket tagging configuration.");
        this.rejectNull(bucketTaggingConfiguration, "The tagging configuration parameter must be specified when setting bucket tagging configuration.");
        Request<SetBucketTaggingConfigurationRequest> request = this.createRequest(string, null, setBucketTaggingConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketTagging");
        request.addParameter("tagging", null);
        byte[] byArray = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketTaggingConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketTaggingConfiguration(String string) {
        this.deleteBucketTaggingConfiguration(new DeleteBucketTaggingConfigurationRequest(string));
    }

    @Override
    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        deleteBucketTaggingConfigurationRequest = this.beforeClientExecution(deleteBucketTaggingConfigurationRequest);
        this.rejectNull(deleteBucketTaggingConfigurationRequest, "The delete bucket tagging configuration request object must be specified.");
        String string = deleteBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting bucket tagging configuration.");
        Request<DeleteBucketTaggingConfigurationRequest> request = this.createRequest(string, null, deleteBucketTaggingConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketTagging");
        request.addParameter("tagging", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void setBucketWebsiteConfiguration(String string, BucketWebsiteConfiguration bucketWebsiteConfiguration) throws SdkClientException, AmazonServiceException {
        this.setBucketWebsiteConfiguration(new SetBucketWebsiteConfigurationRequest(string, bucketWebsiteConfiguration));
    }

    @Override
    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketWebsiteConfigurationRequest = this.beforeClientExecution(setBucketWebsiteConfigurationRequest);
        String string = setBucketWebsiteConfigurationRequest.getBucketName();
        BucketWebsiteConfiguration bucketWebsiteConfiguration = setBucketWebsiteConfigurationRequest.getConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting a bucket's website configuration");
        this.rejectNull(bucketWebsiteConfiguration, "The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        if (bucketWebsiteConfiguration.getRedirectAllRequestsTo() == null) {
            this.rejectNull(bucketWebsiteConfiguration.getIndexDocumentSuffix(), "The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        }
        Request<SetBucketWebsiteConfigurationRequest> request = this.createRequest(string, null, setBucketWebsiteConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketWebsite");
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketWebsiteConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String string) throws SdkClientException, AmazonServiceException {
        this.deleteBucketWebsiteConfiguration(new DeleteBucketWebsiteConfigurationRequest(string));
    }

    @Override
    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws SdkClientException, AmazonServiceException {
        deleteBucketWebsiteConfigurationRequest = this.beforeClientExecution(deleteBucketWebsiteConfigurationRequest);
        String string = deleteBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting a bucket's website configuration");
        Request<DeleteBucketWebsiteConfigurationRequest> request = this.createRequest(string, null, deleteBucketWebsiteConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketWebsite");
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void setBucketNotificationConfiguration(String string, BucketNotificationConfiguration bucketNotificationConfiguration) throws SdkClientException, AmazonServiceException {
        this.setBucketNotificationConfiguration(new SetBucketNotificationConfigurationRequest(string, bucketNotificationConfiguration));
    }

    @Override
    public void setBucketNotificationConfiguration(SetBucketNotificationConfigurationRequest setBucketNotificationConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketNotificationConfigurationRequest = this.beforeClientExecution(setBucketNotificationConfigurationRequest);
        this.rejectNull(setBucketNotificationConfigurationRequest, "The set bucket notification configuration request object must be specified.");
        String string = setBucketNotificationConfigurationRequest.getBucketName();
        BucketNotificationConfiguration bucketNotificationConfiguration = setBucketNotificationConfigurationRequest.getNotificationConfiguration();
        Boolean bl = setBucketNotificationConfigurationRequest.getSkipDestinationValidation();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket notification configuration.");
        this.rejectNull(bucketNotificationConfiguration, "The notification configuration parameter must be specified when setting bucket notification configuration.");
        Request<SetBucketNotificationConfigurationRequest> request = this.createRequest(string, null, setBucketNotificationConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketNotificationConfiguration");
        request.addParameter("notification", null);
        if (bl != null) {
            request.addHeader("x-amz-skip-destination-validation", Boolean.toString(bl));
        }
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketNotificationConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketNotificationConfiguration getBucketNotificationConfiguration(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketNotificationConfiguration(new GetBucketNotificationConfigurationRequest(string));
    }

    @Override
    public BucketNotificationConfiguration getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws SdkClientException, AmazonServiceException {
        getBucketNotificationConfigurationRequest = this.beforeClientExecution(getBucketNotificationConfigurationRequest);
        this.rejectNull(getBucketNotificationConfigurationRequest, "The bucket request parameter must be specified when querying notification configuration");
        String string = getBucketNotificationConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket request must specify a bucket name when querying notification configuration");
        Request<GetBucketNotificationConfigurationRequest> request = this.createRequest(string, null, getBucketNotificationConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketNotificationConfiguration");
        request.addParameter("notification", null);
        return this.invoke(request, BucketNotificationConfigurationStaxUnmarshaller.getInstance(), string, null);
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketLoggingConfiguration(new GetBucketLoggingConfigurationRequest(string));
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(GetBucketLoggingConfigurationRequest getBucketLoggingConfigurationRequest) throws SdkClientException, AmazonServiceException {
        getBucketLoggingConfigurationRequest = this.beforeClientExecution(getBucketLoggingConfigurationRequest);
        this.rejectNull(getBucketLoggingConfigurationRequest, "The request object parameter getBucketLoggingConfigurationRequest must be specifed.");
        String string = getBucketLoggingConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when requesting a bucket's logging status");
        Request<GetBucketLoggingConfigurationRequest> request = this.createRequest(string, null, getBucketLoggingConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketLogging");
        request.addParameter("logging", null);
        return this.invoke(request, new Unmarshallers.BucketLoggingConfigurationnmarshaller(), string, null);
    }

    @Override
    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketLoggingConfigurationRequest = this.beforeClientExecution(setBucketLoggingConfigurationRequest);
        this.rejectNull(setBucketLoggingConfigurationRequest, "The set bucket logging configuration request object must be specified when enabling server access logging");
        String string = setBucketLoggingConfigurationRequest.getBucketName();
        BucketLoggingConfiguration bucketLoggingConfiguration = setBucketLoggingConfigurationRequest.getLoggingConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when enabling server access logging");
        this.rejectNull(bucketLoggingConfiguration, "The logging configuration parameter must be specified when enabling server access logging");
        Request<SetBucketLoggingConfigurationRequest> request = this.createRequest(string, null, setBucketLoggingConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketLogging");
        request.addParameter("logging", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketLoggingConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketAccelerateConfiguration getBucketAccelerateConfiguration(String string) throws AmazonServiceException, SdkClientException {
        return this.getBucketAccelerateConfiguration(new GetBucketAccelerateConfigurationRequest(string));
    }

    @Override
    public BucketAccelerateConfiguration getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws AmazonServiceException, SdkClientException {
        getBucketAccelerateConfigurationRequest = this.beforeClientExecution(getBucketAccelerateConfigurationRequest);
        this.rejectNull(getBucketAccelerateConfigurationRequest, "getBucketAccelerateConfigurationRequest must be specified.");
        String string = getBucketAccelerateConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when querying accelerate configuration");
        Request<GetBucketAccelerateConfigurationRequest> request = this.createRequest(string, null, getBucketAccelerateConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketAccelerateConfiguration");
        request.addParameter("accelerate", null);
        return this.invoke(request, new Unmarshallers.BucketAccelerateConfigurationUnmarshaller(), string, null);
    }

    @Override
    public void setBucketAccelerateConfiguration(String string, BucketAccelerateConfiguration bucketAccelerateConfiguration) throws AmazonServiceException, SdkClientException {
        this.setBucketAccelerateConfiguration(new SetBucketAccelerateConfigurationRequest(string, bucketAccelerateConfiguration));
    }

    @Override
    public void setBucketAccelerateConfiguration(SetBucketAccelerateConfigurationRequest setBucketAccelerateConfigurationRequest) throws AmazonServiceException, SdkClientException {
        setBucketAccelerateConfigurationRequest = this.beforeClientExecution(setBucketAccelerateConfigurationRequest);
        this.rejectNull(setBucketAccelerateConfigurationRequest, "setBucketAccelerateConfigurationRequest must be specified");
        String string = setBucketAccelerateConfigurationRequest.getBucketName();
        BucketAccelerateConfiguration bucketAccelerateConfiguration = setBucketAccelerateConfigurationRequest.getAccelerateConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting accelerate configuration.");
        this.rejectNull(bucketAccelerateConfiguration, "The bucket accelerate configuration parameter must be specified.");
        this.rejectNull(bucketAccelerateConfiguration.getStatus(), "The status parameter must be specified when updating bucket accelerate configuration.");
        Request<SetBucketAccelerateConfigurationRequest> request = this.createRequest(string, null, setBucketAccelerateConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketAccelerateConfiguration");
        request.addParameter("accelerate", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketAccelerateConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketPolicy getBucketPolicy(String string) throws SdkClientException, AmazonServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(string));
    }

    @Override
    public void deleteBucketPolicy(String string) throws SdkClientException, AmazonServiceException {
        this.deleteBucketPolicy(new DeleteBucketPolicyRequest(string));
    }

    @Override
    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws SdkClientException, AmazonServiceException {
        getBucketPolicyRequest = this.beforeClientExecution(getBucketPolicyRequest);
        this.rejectNull(getBucketPolicyRequest, "The request object must be specified when getting a bucket policy");
        String string = getBucketPolicyRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when getting a bucket policy");
        Request<GetBucketPolicyRequest> request = this.createRequest(string, null, getBucketPolicyRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketPolicy");
        request.addParameter("policy", null);
        BucketPolicy bucketPolicy = new BucketPolicy();
        try {
            String string2 = this.invoke(request, new S3StringResponseHandler(), string, null);
            bucketPolicy.setPolicyText(string2);
            return bucketPolicy;
        }
        catch (AmazonServiceException amazonServiceException) {
            if (amazonServiceException.getErrorCode().equals("NoSuchBucketPolicy")) {
                return bucketPolicy;
            }
            throw amazonServiceException;
        }
    }

    @Override
    public void setBucketPolicy(String string, String string2) throws SdkClientException, AmazonServiceException {
        this.setBucketPolicy(new SetBucketPolicyRequest(string, string2));
    }

    @Override
    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws SdkClientException, AmazonServiceException {
        setBucketPolicyRequest = this.beforeClientExecution(setBucketPolicyRequest);
        this.rejectNull(setBucketPolicyRequest, "The request object must be specified when setting a bucket policy");
        String string = setBucketPolicyRequest.getBucketName();
        String string2 = setBucketPolicyRequest.getPolicyText();
        this.rejectNull(string, "The bucket name must be specified when setting a bucket policy");
        this.rejectNull(string2, "The policy text must be specified when setting a bucket policy");
        Request<SetBucketPolicyRequest> request = this.createRequest(string, null, setBucketPolicyRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketPolicy");
        request.addParameter("policy", null);
        byte[] byArray = ServiceUtils.toByteArray(string2);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        if (setBucketPolicyRequest.getConfirmRemoveSelfBucketAccess() != null && setBucketPolicyRequest.getConfirmRemoveSelfBucketAccess().booleanValue()) {
            request.addHeader("x-amz-confirm-remove-self-bucket-access", "true");
        }
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws SdkClientException, AmazonServiceException {
        deleteBucketPolicyRequest = this.beforeClientExecution(deleteBucketPolicyRequest);
        this.rejectNull(deleteBucketPolicyRequest, "The request object must be specified when deleting a bucket policy");
        String string = deleteBucketPolicyRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when deleting a bucket policy");
        Request<DeleteBucketPolicyRequest> request = this.createRequest(string, null, deleteBucketPolicyRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketPolicy");
        request.addParameter("policy", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public DeleteBucketEncryptionResult deleteBucketEncryption(String string) throws SdkClientException {
        return this.deleteBucketEncryption(new DeleteBucketEncryptionRequest().withBucketName(string));
    }

    @Override
    public DeleteBucketEncryptionResult deleteBucketEncryption(DeleteBucketEncryptionRequest deleteBucketEncryptionRequest) throws SdkClientException {
        deleteBucketEncryptionRequest = this.beforeClientExecution(deleteBucketEncryptionRequest);
        this.rejectNull(deleteBucketEncryptionRequest, "The request object must be specified when deleting a bucket encryption configuration");
        String string = deleteBucketEncryptionRequest.getBucketName();
        this.rejectNull(string, "The bucket name must be specified when deleting a bucket encryption configuration");
        Request<DeleteBucketEncryptionRequest> request = this.createRequest(string, null, deleteBucketEncryptionRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketEncryption");
        request.addParameter("encryption", null);
        return this.invoke(request, new Unmarshallers.DeleteBucketEncryptionUnmarshaller(), string, null);
    }

    @Override
    public GetBucketEncryptionResult getBucketEncryption(String string) throws SdkClientException {
        return this.getBucketEncryption(new GetBucketEncryptionRequest().withBucketName(string));
    }

    @Override
    public GetBucketEncryptionResult getBucketEncryption(GetBucketEncryptionRequest getBucketEncryptionRequest) throws SdkClientException {
        getBucketEncryptionRequest = this.beforeClientExecution(getBucketEncryptionRequest);
        this.rejectNull(getBucketEncryptionRequest, "The bucket request parameter must be specified when querying encryption configuration");
        String string = getBucketEncryptionRequest.getBucketName();
        this.rejectNull(string, "The bucket request must specify a bucket name when querying encryption configuration");
        Request<GetBucketEncryptionRequest> request = this.createRequest(string, null, getBucketEncryptionRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketEncryption");
        request.addParameter("encryption", null);
        return this.invoke(request, GetBucketEncryptionStaxUnmarshaller.getInstance(), string, null);
    }

    @Override
    public SetBucketEncryptionResult setBucketEncryption(SetBucketEncryptionRequest setBucketEncryptionRequest) throws AmazonServiceException, SdkClientException {
        setBucketEncryptionRequest = this.beforeClientExecution(setBucketEncryptionRequest);
        this.rejectNull(setBucketEncryptionRequest, "The request object must be specified.");
        String string = setBucketEncryptionRequest.getBucketName();
        ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = setBucketEncryptionRequest.getServerSideEncryptionConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting bucket encryption configuration.");
        this.rejectNull(serverSideEncryptionConfiguration, "The SSE configuration parameter must be specified when setting bucket encryption configuration.");
        Request<SetBucketEncryptionRequest> request = this.createRequest(string, null, setBucketEncryptionRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketEncryption");
        request.addParameter("encryption", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(serverSideEncryptionConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        return this.invoke(request, new Unmarshallers.SetBucketEncryptionUnmarshaller(), string, null);
    }

    @Override
    public SetPublicAccessBlockResult setPublicAccessBlock(SetPublicAccessBlockRequest setPublicAccessBlockRequest) {
        setPublicAccessBlockRequest = this.beforeClientExecution(setPublicAccessBlockRequest);
        this.rejectNull(setPublicAccessBlockRequest, "The request object must be specified.");
        String string = setPublicAccessBlockRequest.getBucketName();
        PublicAccessBlockConfiguration publicAccessBlockConfiguration = setPublicAccessBlockRequest.getPublicAccessBlockConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting public block configuration.");
        this.rejectNull(publicAccessBlockConfiguration, "The PublicAccessBlockConfiguration parameter must be specified when setting public block");
        Request<SetPublicAccessBlockRequest> request = this.createRequest(string, null, setPublicAccessBlockRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutPublicAccessBlock");
        request.addParameter("publicAccessBlock", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(publicAccessBlockConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        return this.invoke(request, new Unmarshallers.SetPublicAccessBlockUnmarshaller(), string, null);
    }

    @Override
    public GetPublicAccessBlockResult getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        getPublicAccessBlockRequest = this.beforeClientExecution(getPublicAccessBlockRequest);
        this.rejectNull(getPublicAccessBlockRequest, "The request object must be specified.");
        String string = getPublicAccessBlockRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when getting public block configuration.");
        Request<GetPublicAccessBlockRequest> request = this.createRequest(string, null, getPublicAccessBlockRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetPublicAccessBlock");
        request.addParameter("publicAccessBlock", null);
        return this.invoke(request, GetPublicAccessBlockStaxUnmarshaller.getInstance(), string, null);
    }

    @Override
    public DeletePublicAccessBlockResult deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        deletePublicAccessBlockRequest = this.beforeClientExecution(deletePublicAccessBlockRequest);
        this.rejectNull(deletePublicAccessBlockRequest, "The request object must be specified.");
        String string = deletePublicAccessBlockRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting public block configuration.");
        Request<DeletePublicAccessBlockRequest> request = this.createRequest(string, null, deletePublicAccessBlockRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeletePublicAccessBlock");
        request.addParameter("publicAccessBlock", null);
        return this.invoke(request, new Unmarshallers.DeletePublicAccessBlockUnmarshaller(), string, null);
    }

    @Override
    public GetBucketPolicyStatusResult getBucketPolicyStatus(GetBucketPolicyStatusRequest getBucketPolicyStatusRequest) {
        getBucketPolicyStatusRequest = this.beforeClientExecution(getBucketPolicyStatusRequest);
        this.rejectNull(getBucketPolicyStatusRequest, "The request object must be specified.");
        String string = getBucketPolicyStatusRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when getting bucket policy status");
        Request<GetBucketPolicyStatusRequest> request = this.createRequest(string, null, getBucketPolicyStatusRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketPolicyStatus");
        request.addParameter("policyStatus", null);
        return this.invoke(request, GetBucketPolicyStatusStaxUnmarshaller.getInstance(), string, null);
    }

    @Override
    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest selectObjectContentRequest) throws AmazonServiceException, SdkClientException {
        selectObjectContentRequest = this.beforeClientExecution(selectObjectContentRequest);
        this.rejectNull(selectObjectContentRequest, "The request parameter must be specified");
        this.rejectNull(selectObjectContentRequest.getBucketName(), "The bucket name parameter must be specified when selecting object content.");
        this.rejectNull(selectObjectContentRequest.getKey(), "The key parameter must be specified when selecting object content.");
        Request<SelectObjectContentRequest> request = this.createRequest(selectObjectContentRequest.getBucketName(), selectObjectContentRequest.getKey(), selectObjectContentRequest, HttpMethodName.POST);
        request.addParameter("select", null);
        request.addParameter("select-type", "2");
        AmazonS3Client.populateSSE_C(request, selectObjectContentRequest.getSSECustomerKey());
        this.setContent(request, RequestXmlFactory.convertToXmlByteArray(selectObjectContentRequest), ContentType.APPLICATION_XML.toString(), true);
        S3Object s3Object = this.invoke(request, new S3ObjectResponseHandler(), selectObjectContentRequest.getBucketName(), selectObjectContentRequest.getKey());
        ServiceClientHolderInputStream serviceClientHolderInputStream = new ServiceClientHolderInputStream(s3Object.getObjectContent(), this);
        return new SelectObjectContentResult().withPayload(new SelectObjectContentEventStream(serviceClientHolderInputStream));
    }

    @Override
    public SetObjectLegalHoldResult setObjectLegalHold(SetObjectLegalHoldRequest setObjectLegalHoldRequest) {
        setObjectLegalHoldRequest = this.beforeClientExecution(setObjectLegalHoldRequest);
        this.rejectNull(setObjectLegalHoldRequest, "The request parameter must be specified");
        String string = setObjectLegalHoldRequest.getBucketName();
        String string2 = setObjectLegalHoldRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when setting the object legal hold.");
        this.rejectNull(string2, "The key parameter must be specified when setting the object legal hold.");
        Request<SetObjectLegalHoldRequest> request = this.createRequest(string, string2, setObjectLegalHoldRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObjectLegalHold");
        this.setContent(request, new ObjectLockLegalHoldXmlFactory().convertToXmlByteArray(setObjectLegalHoldRequest.getLegalHold()), ContentType.APPLICATION_XML.toString(), true);
        request.addParameter("legal-hold", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", setObjectLegalHoldRequest.getVersionId());
        AmazonS3Client.populateRequesterPaysHeader(request, setObjectLegalHoldRequest.isRequesterPays());
        ResponseHeaderHandlerChain<SetObjectLegalHoldResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<SetObjectLegalHoldResult>(new Unmarshallers.SetObjectLegalHoldResultUnmarshaller(), new S3RequesterChargedHeaderHandler());
        return (SetObjectLegalHoldResult)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    @Override
    public GetObjectLegalHoldResult getObjectLegalHold(GetObjectLegalHoldRequest getObjectLegalHoldRequest) {
        getObjectLegalHoldRequest = this.beforeClientExecution(getObjectLegalHoldRequest);
        this.rejectNull(getObjectLegalHoldRequest, "The request parameter must be specified");
        String string = getObjectLegalHoldRequest.getBucketName();
        String string2 = getObjectLegalHoldRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when getting the object legal hold.");
        this.rejectNull(string2, "The key parameter must be specified when getting the object legal hold.");
        Request<GetObjectLegalHoldRequest> request = this.createRequest(string, string2, getObjectLegalHoldRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObjectLegalHold");
        request.addParameter("legal-hold", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", getObjectLegalHoldRequest.getVersionId());
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectLegalHoldRequest.isRequesterPays());
        return this.invoke(request, new Unmarshallers.GetObjectLegalHoldResultUnmarshaller(), string, string2);
    }

    @Override
    public SetObjectLockConfigurationResult setObjectLockConfiguration(SetObjectLockConfigurationRequest setObjectLockConfigurationRequest) {
        setObjectLockConfigurationRequest = this.beforeClientExecution(setObjectLockConfigurationRequest);
        this.rejectNull(setObjectLockConfigurationRequest, "The request parameter must be specified");
        String string = setObjectLockConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when setting the object lock configuration");
        Request<SetObjectLockConfigurationRequest> request = this.createRequest(string, null, setObjectLockConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObjectLockConfiguration");
        request.addParameter("object-lock", null);
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-bucket-object-lock-token", setObjectLockConfigurationRequest.getToken());
        AmazonS3Client.populateRequesterPaysHeader(request, setObjectLockConfigurationRequest.isRequesterPays());
        this.setContent(request, new ObjectLockConfigurationXmlFactory().convertToXmlByteArray(setObjectLockConfigurationRequest.getObjectLockConfiguration()), ContentType.APPLICATION_XML.toString(), true);
        ResponseHeaderHandlerChain<SetObjectLockConfigurationResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<SetObjectLockConfigurationResult>(new Unmarshallers.SetObjectLockConfigurationResultUnmarshaller(), new S3RequesterChargedHeaderHandler());
        return (SetObjectLockConfigurationResult)this.invoke(request, responseHeaderHandlerChain, string, null);
    }

    @Override
    public GetObjectLockConfigurationResult getObjectLockConfiguration(GetObjectLockConfigurationRequest getObjectLockConfigurationRequest) {
        getObjectLockConfigurationRequest = this.beforeClientExecution(getObjectLockConfigurationRequest);
        this.rejectNull(getObjectLockConfigurationRequest, "The request parameter must be specified");
        String string = getObjectLockConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when getting the object lock configuration");
        Request<GetObjectLockConfigurationRequest> request = this.createRequest(string, null, getObjectLockConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObjectLockConfiguration");
        request.addParameter("object-lock", null);
        return this.invoke(request, new Unmarshallers.GetObjectLockConfigurationResultUnmarshaller(), string, null);
    }

    @Override
    public SetObjectRetentionResult setObjectRetention(SetObjectRetentionRequest setObjectRetentionRequest) {
        setObjectRetentionRequest = this.beforeClientExecution(setObjectRetentionRequest);
        this.rejectNull(setObjectRetentionRequest, "The request parameter must be specified");
        String string = setObjectRetentionRequest.getBucketName();
        String string2 = setObjectRetentionRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when setting the object retention.");
        this.rejectNull(string2, "The key parameter must be specified when setting the object retention.");
        Request<SetObjectRetentionRequest> request = this.createRequest(string, string2, setObjectRetentionRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObjectRetention");
        request.addParameter("retention", null);
        if (setObjectRetentionRequest.getBypassGovernanceRetention()) {
            request.addHeader("x-amz-bypass-governance-retention", "true");
        }
        AmazonS3Client.addParameterIfNotNull(request, "versionId", setObjectRetentionRequest.getVersionId());
        AmazonS3Client.populateRequesterPaysHeader(request, setObjectRetentionRequest.isRequesterPays());
        this.setContent(request, new ObjectLockRetentionXmlFactory().convertToXmlByteArray(setObjectRetentionRequest.getRetention()), ContentType.APPLICATION_XML.toString(), true);
        ResponseHeaderHandlerChain<SetObjectRetentionResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<SetObjectRetentionResult>(new Unmarshallers.SetObjectRetentionResultUnmarshaller(), new S3RequesterChargedHeaderHandler());
        return (SetObjectRetentionResult)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    @Override
    public GetObjectRetentionResult getObjectRetention(GetObjectRetentionRequest getObjectRetentionRequest) {
        getObjectRetentionRequest = this.beforeClientExecution(getObjectRetentionRequest);
        this.rejectNull(getObjectRetentionRequest, "The request parameter must be specified");
        String string = getObjectRetentionRequest.getBucketName();
        String string2 = getObjectRetentionRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when getting the object retention.");
        this.rejectNull(string2, "The key parameter must be specified when getting the object retention.");
        Request<GetObjectRetentionRequest> request = this.createRequest(string, string2, getObjectRetentionRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObjectRetention");
        request.addParameter("retention", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", getObjectRetentionRequest.getVersionId());
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectRetentionRequest.isRequesterPays());
        return this.invoke(request, new Unmarshallers.GetObjectRetentionResultUnmarshaller(), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteGetObjectResponseResult writeGetObjectResponse(WriteGetObjectResponseRequest writeGetObjectResponseRequest) {
        WriteGetObjectResponseResult writeGetObjectResponseResult;
        ObjectMetadata objectMetadata;
        writeGetObjectResponseRequest = this.beforeClientExecution(writeGetObjectResponseRequest);
        this.rejectNull(writeGetObjectResponseRequest, "The request parameter must be specified");
        Request<WriteGetObjectResponseRequest> request = this.createRequest(null, null, writeGetObjectResponseRequest, HttpMethodName.POST);
        request.setResourcePath("/WriteGetObjectResponse");
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "WriteGetObjectResponse");
        request.addHandlerContext(HandlerContextKey.REQUIRES_LENGTH, false);
        request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, true);
        request.addHandlerContext(S3HandlerContextKeys.IS_CHUNKED_ENCODING_DISABLED, true);
        request.addHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED, false);
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-request-route", writeGetObjectResponseRequest.getRequestRoute());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-request-token", writeGetObjectResponseRequest.getRequestToken());
        AmazonS3Client.addIntegerHeaderIfNotNull(request, "x-amz-fwd-status", writeGetObjectResponseRequest.getStatusCode());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-error-code", writeGetObjectResponseRequest.getErrorCode());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-error-message", writeGetObjectResponseRequest.getErrorMessage());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-accept-ranges", writeGetObjectResponseRequest.getAcceptRanges());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-Cache-Control", writeGetObjectResponseRequest.getCacheControl());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-Content-Disposition", writeGetObjectResponseRequest.getContentDisposition());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-Content-Encoding", writeGetObjectResponseRequest.getContentEncoding());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-Content-Language", writeGetObjectResponseRequest.getContentLanguage());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-Content-Range", writeGetObjectResponseRequest.getContentRange());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-Content-Type", writeGetObjectResponseRequest.getContentType());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-delete-marker", writeGetObjectResponseRequest.getDeleteMarker());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-ETag", writeGetObjectResponseRequest.getETag());
        AmazonS3Client.addDateHeader(request, "x-amz-fwd-header-Expires", writeGetObjectResponseRequest.getExpires());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-expiration", writeGetObjectResponseRequest.getExpiration());
        AmazonS3Client.addDateHeader(request, "x-amz-fwd-header-Last-Modified", writeGetObjectResponseRequest.getLastModified());
        AmazonS3Client.addIntegerHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-missing-meta", writeGetObjectResponseRequest.getMissingMeta());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-object-lock-mode", writeGetObjectResponseRequest.getObjectLockMode());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-object-lock-legal-hold", writeGetObjectResponseRequest.getObjectLockLegalHoldStatus());
        AmazonS3Client.addDateHeader(request, "x-amz-fwd-header-x-amz-object-lock-retain-until-date", writeGetObjectResponseRequest.getObjectLockRetainUntilDate());
        AmazonS3Client.addIntegerHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-mp-parts-count", writeGetObjectResponseRequest.getPartsCount());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-replication-status", writeGetObjectResponseRequest.getReplicationStatus());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-request-charged", writeGetObjectResponseRequest.getRequestCharged());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-restore", writeGetObjectResponseRequest.getRestore());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-server-side-encryption", writeGetObjectResponseRequest.getServerSideEncryption());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-server-side-encryption-customer-algorithm", writeGetObjectResponseRequest.getSSECustomerAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-server-side-encryption-aws-kms-key-id", writeGetObjectResponseRequest.getSSEKMSKeyId());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-server-side-encryption-customer-key-MD5", writeGetObjectResponseRequest.getSSECustomerKeyMD5());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-storage-class", writeGetObjectResponseRequest.getStorageClass());
        AmazonS3Client.addIntegerHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-tagging-count", writeGetObjectResponseRequest.getTagCount());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-fwd-header-x-amz-version-id", writeGetObjectResponseRequest.getVersionId());
        if (writeGetObjectResponseRequest.getBucketKeyEnabled() != null) {
            request.addHeader("x-amz-fwd-header-x-amz-server-side-encryption-bucket-key-enabled", writeGetObjectResponseRequest.getBucketKeyEnabled().toString());
        }
        if ((objectMetadata = writeGetObjectResponseRequest.getMetadata()) == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (writeGetObjectResponseRequest.getContentLength() != null) {
            objectMetadata.setContentLength(writeGetObjectResponseRequest.getContentLength());
        }
        InputStream inputStream2 = writeGetObjectResponseRequest.getInputStream();
        File file = writeGetObjectResponseRequest.getFile();
        InputStream inputStream3 = null;
        try {
            inputStream3 = this.getInputStream(writeGetObjectResponseRequest.getInputStream(), writeGetObjectResponseRequest.getFile(), objectMetadata, request, false, true);
            request.setContent(inputStream3);
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
            writeGetObjectResponseResult = this.invoke(request, new Unmarshallers.WriteGetObjectResponseResultUnmarshaller(), null, null);
        }
        catch (Throwable throwable) {
            S3DataSource.Utils.cleanupDataSource(writeGetObjectResponseRequest, file, inputStream2, inputStream3, log);
            throw throwable;
        }
        S3DataSource.Utils.cleanupDataSource(writeGetObjectResponseRequest, file, inputStream2, inputStream3, log);
        return writeGetObjectResponseResult;
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date) throws SdkClientException {
        return this.generatePresignedUrl(string, string2, date, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String string, String string2, Date date, HttpMethod httpMethod) throws SdkClientException {
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(string, string2, httpMethod);
        generatePresignedUrlRequest.setExpiration(date);
        return this.generatePresignedUrl(generatePresignedUrlRequest);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) {
        this.rejectNull(generatePresignedUrlRequest, "The request parameter must be specified when generating a pre-signed URL");
        generatePresignedUrlRequest.rejectIllegalArguments();
        String string = generatePresignedUrlRequest.getBucketName();
        String string2 = generatePresignedUrlRequest.getKey();
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethodName = HttpMethodName.valueOf(generatePresignedUrlRequest.getMethod().toString());
        Request<GeneratePresignedUrlRequest> request = this.createRequest(string, string2, generatePresignedUrlRequest, httpMethodName);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GeneratePresignedUrl");
        AmazonS3Client.addParameterIfNotNull(request, "versionId", generatePresignedUrlRequest.getVersionId());
        if (generatePresignedUrlRequest.isZeroByteContent()) {
            request.setContent(new ByteArrayInputStream(new byte[0]));
        }
        for (Map.Entry<String, String> object2 : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            request.addParameter(object2.getKey(), object2.getValue());
        }
        AmazonS3Client.addHeaderIfNotNull(request, "Content-Type", generatePresignedUrlRequest.getContentType());
        AmazonS3Client.addHeaderIfNotNull(request, "Content-MD5", generatePresignedUrlRequest.getContentMd5());
        AmazonS3Client.populateSSE_C(request, generatePresignedUrlRequest.getSSECustomerKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption", generatePresignedUrlRequest.getSSEAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-aws-kms-key-id", generatePresignedUrlRequest.getKmsCmkId());
        Map<String, String> map = generatePresignedUrlRequest.getCustomRequestHeaders();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                request.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        AmazonS3Client.addResponseHeaderParameters(request, generatePresignedUrlRequest.getResponseHeaders());
        Signer signer = this.createSigner(request, string, string2);
        if (request.getHandlerContext(HandlerContextKey.SIGNING_NAME) != null && !this.isSignerOverridden()) {
            String string3 = request.getHandlerContext(HandlerContextKey.SIGNING_NAME);
            if (signer instanceof ServiceAwareSigner) {
                ((ServiceAwareSigner)signer).setServiceName(string3);
            }
        }
        if (signer instanceof Presigner) {
            ((Presigner)((Object)signer)).presignRequest(request, CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider).getCredentials(), generatePresignedUrlRequest.getExpiration());
        } else {
            this.presignRequest(request, generatePresignedUrlRequest.getMethod(), string, string2, generatePresignedUrlRequest.getExpiration(), null);
        }
        return ServiceUtils.convertRequestToUrl(request, true, false);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        abortMultipartUploadRequest = this.beforeClientExecution(abortMultipartUploadRequest);
        this.rejectNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        String string = abortMultipartUploadRequest.getBucketName();
        String string2 = abortMultipartUploadRequest.getKey();
        Request<AbortMultipartUploadRequest> request = this.createRequest(string, string2, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AbortMultipartUpload");
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        AmazonS3Client.populateRequesterPaysHeader(request, abortMultipartUploadRequest.isRequesterPays());
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        XmlResponsesSaxParser.CompleteMultipartUploadHandler completeMultipartUploadHandler;
        completeMultipartUploadRequest = this.beforeClientExecution(completeMultipartUploadRequest);
        this.rejectNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String string = completeMultipartUploadRequest.getBucketName();
        String string2 = completeMultipartUploadRequest.getKey();
        String string3 = completeMultipartUploadRequest.getUploadId();
        this.rejectNull(string, "The bucket name parameter must be specified when completing a multipart upload");
        this.rejectNull(string2, "The key parameter must be specified when completing a multipart upload");
        this.rejectNull(string3, "The upload ID parameter must be specified when completing a multipart upload");
        this.rejectNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        int n = 0;
        do {
            Request<CompleteMultipartUploadRequest> request = this.createRequest(string, string2, completeMultipartUploadRequest, HttpMethodName.POST);
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CompleteMultipartUpload");
            request.addParameter("uploadId", string3);
            AmazonS3Client.populateRequesterPaysHeader(request, completeMultipartUploadRequest.isRequesterPays());
            byte[] byArray = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
            request.addHeader("Content-Type", "application/xml");
            request.addHeader("Content-Length", String.valueOf(byArray.length));
            request.setContent(new ByteArrayInputStream(byArray));
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new S3VersionHeaderHandler(), new S3RequesterChargedHeaderHandler());
            completeMultipartUploadHandler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHeaderHandlerChain, string, string2);
            if (completeMultipartUploadHandler.getCompleteMultipartUploadResult() == null) continue;
            return completeMultipartUploadHandler.getCompleteMultipartUploadResult();
        } while (this.shouldRetryCompleteMultipartUpload(completeMultipartUploadRequest, completeMultipartUploadHandler.getAmazonS3Exception(), n++));
        throw completeMultipartUploadHandler.getAmazonS3Exception();
    }

    private boolean shouldRetryCompleteMultipartUpload(AmazonWebServiceRequest amazonWebServiceRequest, AmazonS3Exception amazonS3Exception, int n) {
        RetryPolicy retryPolicy = this.clientConfiguration.getRetryPolicy();
        if (retryPolicy == null || retryPolicy.getRetryCondition() == null) {
            return false;
        }
        if (retryPolicy == PredefinedRetryPolicies.NO_RETRY_POLICY) {
            return false;
        }
        return this.completeMultipartUploadRetryCondition.shouldRetry(amazonWebServiceRequest, amazonS3Exception, n);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        Boolean bl;
        initiateMultipartUploadRequest = this.beforeClientExecution(initiateMultipartUploadRequest);
        this.rejectNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        Request<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateMultipartUpload");
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-amz-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        if ((bl = initiateMultipartUploadRequest.getBucketKeyEnabled()) != null) {
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-bucket-key-enabled", String.valueOf(bl));
        }
        AmazonS3Client.populateRequesterPaysHeader(request, initiateMultipartUploadRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, initiateMultipartUploadRequest.getSSECustomerKey());
        AmazonS3Client.populateSSE_KMS(request, initiateMultipartUploadRequest.getSSEAwsKeyManagementParams());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-tagging", this.urlEncodeTags(initiateMultipartUploadRequest.getTagging()));
        AmazonS3Client.populateObjectLockHeaders(request, initiateMultipartUploadRequest.getObjectLockMode(), initiateMultipartUploadRequest.getObjectLockRetainUntilDate(), initiateMultipartUploadRequest.getObjectLockLegalHoldStatus());
        this.setZeroContentLength(request);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3RequesterChargedHeaderHandler(), new InitiateMultipartUploadHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHeaderHandlerChain, initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey());
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws SdkClientException, AmazonServiceException {
        listMultipartUploadsRequest = this.beforeClientExecution(listMultipartUploadsRequest);
        this.rejectNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.rejectNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        Request<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListMultipartUploads");
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller(), listMultipartUploadsRequest.getBucketName(), null);
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws SdkClientException, AmazonServiceException {
        listPartsRequest = this.beforeClientExecution(listPartsRequest);
        this.rejectNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        Request<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListParts");
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, listPartsRequest.isRequesterPays());
        ResponseHeaderHandlerChain<PartListing> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<PartListing>(new Unmarshallers.ListPartsResultUnmarshaller(), new S3RequesterChargedHeaderHandler(), new ListPartsHeaderHandler());
        return (PartListing)this.invoke(request, responseHeaderHandlerChain, listPartsRequest.getBucketName(), listPartsRequest.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        uploadPartRequest = this.beforeClientExecution(uploadPartRequest);
        this.rejectNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        File file = uploadPartRequest.getFile();
        InputStream inputStream2 = uploadPartRequest.getInputStream();
        String string = uploadPartRequest.getBucketName();
        String string2 = uploadPartRequest.getKey();
        String string3 = uploadPartRequest.getUploadId();
        int n = uploadPartRequest.getPartNumber();
        long l = uploadPartRequest.getPartSize();
        this.rejectNull(string, "The bucket name parameter must be specified when uploading a part");
        this.rejectNull(string2, "The key parameter must be specified when uploading a part");
        this.rejectNull(string3, "The upload ID parameter must be specified when uploading a part");
        Request<UploadPartRequest> request = this.createRequest(string, string2, uploadPartRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UploadPart");
        request.addHandlerContext(HandlerContextKey.REQUIRES_LENGTH, Boolean.TRUE);
        request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, Boolean.TRUE);
        request.addParameter("uploadId", string3);
        request.addParameter("partNumber", Integer.toString(n));
        ObjectMetadata objectMetadata = uploadPartRequest.getObjectMetadata();
        if (objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        }
        AmazonS3Client.addHeaderIfNotNull(request, "Content-MD5", uploadPartRequest.getMd5Digest());
        request.addHeader("Content-Length", Long.toString(l));
        AmazonS3Client.populateRequesterPaysHeader(request, uploadPartRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, uploadPartRequest.getSSECustomerKey());
        InputStream inputStream3 = inputStream2;
        try {
            Object object;
            Object object2;
            if (file == null) {
                if (inputStream2 == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                inputStream3 = ReleasableInputStream.wrap(inputStream3);
                object2 = Constants.getS3StreamBufferSize();
                if (object2 != null) {
                    object = request.getOriginalRequest();
                    ((AmazonWebServiceRequest)object).getRequestClientOptions().setReadLimit((Integer)object2);
                }
            } else {
                try {
                    inputStream3 = new ResettableInputStream(file);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Failed to open file " + file, iOException);
                }
            }
            inputStream3 = new InputSubstream(inputStream3, uploadPartRequest.getFileOffset(), l, uploadPartRequest.isLastPart());
            object2 = null;
            if (uploadPartRequest.getMd5Digest() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(uploadPartRequest)) {
                object2 = new MD5DigestCalculatingInputStream(inputStream3);
                inputStream3 = object2;
            }
            object = uploadPartRequest.getGeneralProgressListener();
            SDKProgressPublisher.publishProgress((ProgressListener)object, ProgressEventType.TRANSFER_PART_STARTED_EVENT);
            UploadPartResult uploadPartResult = this.doUploadPart(string, string2, string3, n, l, request, inputStream3, (MD5DigestCalculatingInputStream)object2, (ProgressListener)object);
            return uploadPartResult;
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(uploadPartRequest, file, inputStream2, inputStream3, log);
        }
    }

    private UploadPartResult doUploadPart(String string, String string2, String string3, int n, long l, Request<UploadPartRequest> request, InputStream inputStream2, MD5DigestCalculatingInputStream mD5DigestCalculatingInputStream, ProgressListener progressListener) {
        try {
            byte[] byArray;
            Object object;
            request.setContent(inputStream2);
            ObjectMetadata objectMetadata = this.invoke(request, new S3MetadataResponseHandler(), string, string2);
            String string4 = objectMetadata.getETag();
            if (mD5DigestCalculatingInputStream != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerUploadPartResponse(objectMetadata) && !Arrays.equals((byte[])(object = mD5DigestCalculatingInputStream.getMd5Digest()), byArray = BinaryUtils.fromHex(string4))) {
                String string5 = "bucketName: " + string + ", key: " + string2 + ", uploadId: " + string3 + ", partNumber: " + n + ", partSize: " + l;
                throw new SdkClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + Base16.encodeAsString((byte[])object) + " in hex) didn't match hash (etag: " + string4 + " in hex) calculated by Amazon S3.  You may need to delete the data stored in Amazon S3. (" + string5 + ")");
            }
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_PART_COMPLETED_EVENT);
            object = new UploadPartResult();
            ((UploadPartResult)object).setETag(string4);
            ((UploadPartResult)object).setPartNumber(n);
            ((SSEResultBase)object).setSSEAlgorithm(objectMetadata.getSSEAlgorithm());
            ((SSEResultBase)object).setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
            ((SSEResultBase)object).setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
            ((UploadPartResult)object).setRequesterCharged(objectMetadata.isRequesterCharged());
            ((SSEResultBase)object).setBucketKeyEnabled(objectMetadata.getBucketKeyEnabled());
            return object;
        }
        catch (Throwable throwable) {
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_PART_FAILED_EVENT);
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_PART_COMPLETED_EVENT);
            throw Throwables.failure(throwable);
        }
    }

    @Override
    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest amazonWebServiceRequest) {
        return (S3ResponseMetadata)this.client.getResponseMetadataForRequest(amazonWebServiceRequest);
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws AmazonServiceException {
        this.restoreObjectV2(restoreObjectRequest);
    }

    @Override
    public RestoreObjectResult restoreObjectV2(RestoreObjectRequest restoreObjectRequest) throws AmazonServiceException {
        restoreObjectRequest = this.beforeClientExecution(restoreObjectRequest);
        String string = restoreObjectRequest.getBucketName();
        String string2 = restoreObjectRequest.getKey();
        this.rejectNull(string, "The bucket name parameter must be specified when restoring a glacier object");
        this.rejectNull(string2, "The key parameter must be specified when restoring a glacier object");
        if (restoreObjectRequest.getOutputLocation() != null) {
            this.rejectNull(restoreObjectRequest.getType(), "The restore request type must be specified with restores that specify OutputLocation");
            if (RestoreRequestType.SELECT.toString().equals(restoreObjectRequest.getType())) {
                this.rejectNull(restoreObjectRequest.getSelectParameters(), "The select parameters must be specified when restoring a glacier object with SELECT restore request type");
            }
        }
        Request<RestoreObjectRequest> request = this.createRestoreObjectRequest(restoreObjectRequest);
        ResponseHeaderHandlerChain<RestoreObjectResult> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<RestoreObjectResult>(new Unmarshallers.RestoreObjectResultUnmarshaller(), new S3RequesterChargedHeaderHandler(), new S3RestoreOutputPathHeaderHandler());
        return (RestoreObjectResult)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    @Override
    public void restoreObject(String string, String string2, int n) throws AmazonServiceException {
        this.restoreObject(new RestoreObjectRequest(string, string2, n));
    }

    @Override
    public PutObjectResult putObject(String string, String string2, String string3) throws AmazonServiceException, SdkClientException {
        this.rejectNull(string, "Bucket name must be provided");
        this.rejectNull(string2, "Object key must be provided");
        this.rejectNull(string3, "String content must be provided");
        byte[] byArray = string3.getBytes(StringUtils.UTF8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("text/plain");
        objectMetadata.setContentLength(byArray.length);
        return this.putObject(new PutObjectRequest(string, string2, byteArrayInputStream, objectMetadata));
    }

    private void rejectNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    private AccessControlList getAcl(String string, String string2, String string3, boolean bl, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest == null) {
            amazonWebServiceRequest = new GenericBucketRequest(string);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(string, string2, amazonWebServiceRequest, HttpMethodName.GET);
        if (string != null && string2 != null) {
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObjectAcl");
        } else if (string != null) {
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketAcl");
        }
        request.addParameter("acl", null);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, bl);
        ResponseHeaderHandlerChain<AccessControlList> responseHeaderHandlerChain = new ResponseHeaderHandlerChain<AccessControlList>(new Unmarshallers.AccessControlListUnmarshaller(), new S3RequesterChargedHeaderHandler());
        return (AccessControlList)this.invoke(request, responseHeaderHandlerChain, string, string2);
    }

    private void setAcl(String string, String string2, String string3, CannedAccessControlList cannedAccessControlList, boolean bl, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest == null) {
            amazonWebServiceRequest = new GenericBucketRequest(string);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(string, string2, amazonWebServiceRequest, HttpMethodName.PUT);
        if (string != null && string2 != null) {
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObjectAcl");
        } else if (string != null) {
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketAcl");
        }
        request.addParameter("acl", null);
        request.addHeader("x-amz-acl", cannedAccessControlList.toString());
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, bl);
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    private void setAcl(String string, String string2, String string3, AccessControlList accessControlList, boolean bl, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest == null) {
            amazonWebServiceRequest = new GenericBucketRequest(string);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(string, string2, amazonWebServiceRequest, HttpMethodName.PUT);
        if (string != null && string2 != null) {
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObjectAcl");
        } else if (string != null) {
            request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketAcl");
        }
        request.addParameter("acl", null);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, bl);
        byte[] byArray = new AclXmlFactory().convertToXmlByteArray(accessControlList);
        request.addHeader("Content-Type", "application/xml");
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, string2);
    }

    protected Signer createSigner(Request<?> request, String string, String string2) {
        return this.createSigner(request, string, string2, false);
    }

    protected Signer createSigner(Request<?> request, String string, String string2, boolean bl) {
        Signer signer;
        Object object;
        Object object2;
        URI uRI;
        URI uRI2 = uRI = this.clientOptions.isAccelerateModeEnabled() ? this.endpoint : request.getEndpoint();
        if (this.isAccessPointArn(string)) {
            object2 = Arn.fromString(string);
            object = S3ArnConverter.getInstance().convertArn((Arn)object2);
            String string3 = object.getRegion();
            String string4 = RegionUtils.getRegion(string3).getServiceEndpoint(S3_SERVICE_NAME);
            signer = this.getSignerByURI(URI.create(uRI.getScheme() + "://" + string4));
        } else {
            signer = this.getSignerByURI(uRI);
        }
        if (!this.isSignerOverridden()) {
            if (signer instanceof AWSS3V4Signer && this.bucketRegionShouldBeCached(request)) {
                object2 = bucketRegionCache.get(string);
                if (object2 != null) {
                    request.addHandlerContext(HandlerContextKey.SIGNING_REGION, object2);
                    if (!this.clientOptions.isAccelerateModeEnabled()) {
                        this.resolveRequestEndpoint(request, string, string2, RuntimeHttpUtils.toUri(RegionUtils.getRegion((String)object2).getServiceEndpoint(S3_SERVICE_NAME), this.clientConfiguration));
                    }
                    return this.updateSigV4SignerWithServiceAndRegion((AWSS3V4Signer)signer, request, (String)object2);
                }
                if (request.getOriginalRequest() instanceof GeneratePresignedUrlRequest) {
                    object = this.getSignerRegion();
                    if (object == null) {
                        return this.createSigV2Signer(request, string, string2);
                    }
                    return this.updateSigV4SignerWithServiceAndRegion((AWSS3V4Signer)signer, request, (String)object);
                }
                if (bl) {
                    return this.updateSigV4SignerWithServiceAndRegion((AWSS3V4Signer)signer, request, "us-east-1");
                }
            }
            if ((object2 = this.getSignerRegionOverride()) != null) {
                return this.updateSigV4SignerWithServiceAndRegion(new AWSS3V4Signer(), request, (String)object2);
            }
        }
        if (signer instanceof S3Signer) {
            return this.createSigV2Signer(request, string, string2);
        }
        return signer;
    }

    private S3Signer createSigV2Signer(Request<?> request, String string, String string2) {
        String string3 = "/" + (string != null ? string + "/" : "") + (string2 != null ? string2 : "");
        return new S3Signer(request.getHttpMethod().toString(), string3);
    }

    private AWSS3V4Signer updateSigV4SignerWithServiceAndRegion(AWSS3V4Signer aWSS3V4Signer, Request<?> request, String string) {
        String string2 = request.getHandlerContext(HandlerContextKey.SIGNING_NAME);
        if (string2 != null) {
            aWSS3V4Signer.setServiceName(string2);
        } else {
            aWSS3V4Signer.setServiceName(this.getServiceNameIntern());
        }
        String string3 = request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
        if (string3 != null) {
            aWSS3V4Signer.setRegionName(string3);
        } else {
            aWSS3V4Signer.setRegionName(string);
        }
        return aWSS3V4Signer;
    }

    private String getSignerRegion() {
        String string = this.getSignerRegionOverride();
        if (string == null) {
            string = this.clientRegion;
        }
        return string;
    }

    private boolean isSignerOverridden() {
        return this.clientConfiguration != null && this.clientConfiguration.getSignerOverride() != null;
    }

    private boolean noExplicitRegionProvided(Request<?> request) {
        return this.isStandardEndpoint(request.getEndpoint()) && this.getSignerRegion() == null;
    }

    private boolean isStandardEndpoint(URI uRI) {
        return uRI.getHost().endsWith("s3.amazonaws.com");
    }

    protected <T> void presignRequest(Request<T> request, HttpMethod httpMethod, String string, String string2, Date date, String string3) {
        this.beforeRequest(request);
        String string4 = "/" + (string != null ? string + "/" : "") + (string2 != null ? SdkHttpUtils.urlEncode(string2, true) : "") + (string3 != null ? "?" + string3 : "");
        string4 = string4.replaceAll("(?<=/)/", "%2F");
        new S3QueryStringSigner(httpMethod.toString(), string4, date).sign(request, CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider).getCredentials());
        if (request.getHeaders().containsKey("x-amz-security-token")) {
            String string5 = request.getHeaders().get("x-amz-security-token");
            request.addParameter("x-amz-security-token", string5);
            request.getHeaders().remove("x-amz-security-token");
        }
    }

    private <T> void beforeRequest(Request<T> request) {
        if (this.requestHandler2s != null) {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.beforeRequest(request);
            }
        }
    }

    protected static void populateRequestMetadata(Request<?> request, ObjectMetadata objectMetadata) {
        Object object;
        Object object2;
        Map<String, Object> map = objectMetadata.getRawMetadata();
        if (map != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                request.addHeader((String)object.getKey(), object.getValue().toString());
            }
        }
        if ((object2 = objectMetadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", DateUtils.formatRFC822Date((Date)object2));
        }
        if ((object = objectMetadata.getUserMetadata()) != null) {
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string != null) {
                    string = string.trim();
                }
                if (string2 != null) {
                    string2 = string2.trim();
                }
                request.addHeader("x-amz-meta-" + string, string2);
            }
        }
    }

    protected static void populateRequesterPaysHeader(Request<?> request, boolean bl) {
        if (bl) {
            request.addHeader("x-amz-request-payer", "requester");
        }
    }

    private void populateRequestWithMfaDetails(Request<?> request, MultiFactorAuthentication multiFactorAuthentication) {
        if (multiFactorAuthentication == null) {
            return;
        }
        String string = request.getEndpoint().toString();
        if (string.startsWith("http://")) {
            String string2 = string.replace("http://", "https://");
            request.setEndpoint(URI.create(string2));
            log.info("Overriding current endpoint to use HTTPS as required by S3 for requests containing an MFA header");
        }
        request.addHeader("x-amz-mfa", multiFactorAuthentication.getDeviceSerialNumber() + " " + multiFactorAuthentication.getToken());
    }

    private void populateRequestWithCopyObjectParameters(Request<? extends AmazonWebServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        ObjectTagging objectTagging;
        String string = this.assembleCopySourceHeader(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceKey(), copyObjectRequest.getSourceVersionId());
        request.addHeader("x-amz-copy-source", string);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-amz-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, copyObjectRequest.isRequesterPays());
        ObjectMetadata objectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (copyObjectRequest.getMetadataDirective() != null) {
            request.addHeader("x-amz-metadata-directive", copyObjectRequest.getMetadataDirective());
        } else if (objectMetadata != null) {
            request.addHeader("x-amz-metadata-directive", "REPLACE");
        }
        if (objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        }
        if ((objectTagging = copyObjectRequest.getNewObjectTagging()) != null) {
            request.addHeader("x-amz-tagging-directive", "REPLACE");
            request.addHeader("x-amz-tagging", this.urlEncodeTags(objectTagging));
        }
        AmazonS3Client.populateSourceSSE_C(request, copyObjectRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSSE_C(request, copyObjectRequest.getDestinationSSECustomerKey());
    }

    private void populateRequestWithCopyPartParameters(Request<?> request, CopyPartRequest copyPartRequest) {
        String string = this.assembleCopySourceHeader(copyPartRequest.getSourceBucketName(), copyPartRequest.getSourceKey(), copyPartRequest.getSourceVersionId());
        request.addHeader("x-amz-copy-source", string);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String string2 = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            request.addHeader("x-amz-copy-source-range", string2);
        }
        AmazonS3Client.populateSourceSSE_C(request, copyPartRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSSE_C(request, copyPartRequest.getDestinationSSECustomerKey());
    }

    private void populateRequestHeaderWithMd5(Request<?> request, byte[] byArray) {
        try {
            byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
            String string = BinaryUtils.toBase64(byArray2);
            request.addHeader("Content-MD5", string);
        }
        catch (Exception exception) {
            throw new SdkClientException("Couldn't compute md5 sum", exception);
        }
    }

    private String assembleCopySourceHeader(String string, String string2, String string3) {
        String string4;
        if (string == null) {
            throw new IllegalArgumentException("Copy source bucket name should not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Copy source object key should not be null");
        }
        if (this.isArn(string)) {
            S3Resource s3Resource;
            Arn arn = Arn.fromString(string);
            try {
                s3Resource = S3ArnConverter.getInstance().convertArn(arn);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.", runtimeException);
            }
            if (!S3ResourceType.ACCESS_POINT.toString().equals(s3Resource.getType())) {
                throw new IllegalArgumentException("An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.");
            }
            string4 = SdkHttpUtils.urlEncode(string + "/object/" + string2, false);
        } else {
            string4 = "/" + SdkHttpUtils.urlEncode(string, true) + "/" + SdkHttpUtils.urlEncode(string2, true);
        }
        if (string3 != null) {
            string4 = string4 + "?versionId=" + string3;
        }
        return string4;
    }

    private static void populateSSE_C(Request<?> request, SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-algorithm", sSECustomerKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key", sSECustomerKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key-MD5", sSECustomerKey.getMd5());
        if (sSECustomerKey.getKey() != null && sSECustomerKey.getMd5() == null) {
            String string = sSECustomerKey.getKey();
            byte[] byArray = Base64.decode(string);
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(byArray));
        }
    }

    private static void populateSourceSSE_C(Request<?> request, SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-algorithm", sSECustomerKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key", sSECustomerKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key-MD5", sSECustomerKey.getMd5());
        if (sSECustomerKey.getKey() != null && sSECustomerKey.getMd5() == null) {
            String string = sSECustomerKey.getKey();
            byte[] byArray = Base64.decode(string);
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(byArray));
        }
    }

    private static void populateSSE_KMS(Request<?> request, SSEAwsKeyManagementParams sSEAwsKeyManagementParams) {
        if (sSEAwsKeyManagementParams != null) {
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption", sSEAwsKeyManagementParams.getEncryption());
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-aws-kms-key-id", sSEAwsKeyManagementParams.getAwsKmsKeyId());
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-context", sSEAwsKeyManagementParams.getAwsKmsEncryptionContext());
        }
    }

    private void addPartNumberIfNotNull(Request<?> request, Integer n) {
        if (n != null) {
            request.addParameter("partNumber", n.toString());
        }
    }

    private static void addHeaderIfNotNull(Request<?> request, String string, String string2) {
        if (string2 != null) {
            request.addHeader(string, string2);
        }
    }

    private static void addIntegerHeaderIfNotNull(Request<?> request, String string, Integer n) {
        if (n != null) {
            request.addHeader(string, Integer.toString(n));
        }
    }

    private static void addParameterIfNotNull(Request<?> request, String string, Integer n) {
        if (n != null) {
            AmazonS3Client.addParameterIfNotNull(request, string, n.toString());
        }
    }

    private static void addParameterIfNotNull(Request<?> request, String string, String string2) {
        if (string2 != null) {
            request.addParameter(string, string2);
        }
    }

    private static void addDateHeader(Request<?> request, String string, Date date) {
        if (date != null) {
            request.addHeader(string, ServiceUtils.formatRfc822Date(date));
        }
    }

    private static void addStringListHeader(Request<?> request, String string, List<String> list) {
        if (list != null && !list.isEmpty()) {
            request.addHeader(string, ServiceUtils.join(list));
        }
    }

    private static void addResponseHeaderParameters(Request<?> request, ResponseHeaderOverrides responseHeaderOverrides) {
        if (responseHeaderOverrides != null) {
            if (responseHeaderOverrides.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaderOverrides.getCacheControl());
            }
            if (responseHeaderOverrides.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaderOverrides.getContentDisposition());
            }
            if (responseHeaderOverrides.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaderOverrides.getContentEncoding());
            }
            if (responseHeaderOverrides.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaderOverrides.getContentLanguage());
            }
            if (responseHeaderOverrides.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaderOverrides.getContentType());
            }
            if (responseHeaderOverrides.getExpires() != null) {
                request.addParameter("response-expires", responseHeaderOverrides.getExpires());
            }
        }
    }

    public String getResourceUrl(String string, String string2) {
        try {
            return this.getUrl(string, string2).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public URL getUrl(String string, String string2) {
        if (this.isArn(string)) {
            throw new IllegalArgumentException("ARNs are not supported for getUrl in this SDK version. Please use S3Utilities in the AWS SDK for Java 2.x.");
        }
        DefaultRequest defaultRequest = new DefaultRequest("Amazon S3");
        this.resolveRequestEndpoint(defaultRequest, string, string2, this.endpoint);
        return ServiceUtils.convertRequestToUrl(defaultRequest, false, false);
    }

    @Override
    public synchronized Region getRegion() {
        String string = this.endpoint.getAuthority();
        if ("s3.amazonaws.com".equals(string)) {
            return Region.US_Standard;
        }
        Matcher matcher = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            return Region.fromValue(matcher.group(1));
        }
        String string2 = this.getSignerRegion();
        if (string2 != null) {
            return Region.fromValue(string2);
        }
        throw new IllegalStateException("Unable to determine region from configured S3 endpoint (" + string + ") or signing region.");
    }

    @Override
    public String getRegionName() {
        String string = this.endpoint.getAuthority();
        if ("s3.amazonaws.com".equals(string)) {
            return "us-east-1";
        }
        return this.getRegionNameFromAuthorityOrSigner();
    }

    private String getRegionNameFromAuthorityOrSigner() {
        String string = this.endpoint.getAuthority();
        Matcher matcher = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                return RegionUtils.getRegion(matcher.group(1)).getName();
            }
            catch (Exception exception) {
                throw new IllegalStateException("No valid region has been specified. Unable to return region name.", exception);
            }
        }
        String string2 = this.getSignerRegion();
        if (string2 != null) {
            return string2;
        }
        throw new IllegalStateException("Unable to determine region from configured S3 endpoint (" + string + ") or signing region.");
    }

    private static boolean isRegionFipsEnabled(String string) {
        return string.startsWith("fips-") || string.endsWith("-fips");
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String string, String string2, X x, HttpMethodName httpMethodName) {
        return this.createRequest(string, string2, x, httpMethodName, this.endpoint);
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String string, String string2, X x, HttpMethodName httpMethodName, URI uRI) {
        Object object;
        DefaultRequest defaultRequest = new DefaultRequest(x, "Amazon S3");
        defaultRequest.setHttpMethod(httpMethodName);
        defaultRequest.addHandlerContext(S3HandlerContextKeys.IS_CHUNKED_ENCODING_DISABLED, this.clientOptions.isChunkedEncodingDisabled());
        defaultRequest.addHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED, this.clientOptions.isPayloadSigningEnabled());
        defaultRequest.addHandlerContext(HandlerContextKey.SERVICE_ID, SERVICE_ID);
        if (x instanceof ExpectedBucketOwnerRequest) {
            object = (ExpectedBucketOwnerRequest)((Object)x);
            AmazonS3Client.addHeaderIfNotNull(defaultRequest, "x-amz-expected-bucket-owner", object.getExpectedBucketOwner());
        }
        if (x instanceof ExpectedSourceBucketOwnerRequest) {
            object = (ExpectedSourceBucketOwnerRequest)((Object)x);
            AmazonS3Client.addHeaderIfNotNull(defaultRequest, "x-amz-source-expected-bucket-owner", object.getExpectedSourceBucketOwner());
        }
        if (this.isAccessPointArn(string)) {
            object = Arn.fromString(string);
            S3Resource s3Resource = S3ArnConverter.getInstance().convertArn((Arn)object);
            this.validateConfiguration(s3Resource);
            com.amazonaws.regions.Region region = RegionUtils.getRegion(this.getRegionNameFromAuthorityOrSigner());
            this.validateS3ResourceArn((Arn)object, region);
            this.validateParentResourceIfNeeded((S3AccessPointResource)s3Resource, this.getRegionName());
            uRI = this.getEndpointForAccessPoint((S3AccessPointResource)s3Resource, region.getDomain());
            String string3 = s3Resource.getRegion();
            defaultRequest.addHandlerContext(HandlerContextKey.SIGNING_REGION, string3);
            this.resolveAccessPointEndpoint(defaultRequest, null, string2, uRI);
            if (this.isOutpostAccessPointArn(string)) {
                defaultRequest.addHandlerContext(HandlerContextKey.SIGNING_NAME, S3_OUTPOSTS_NAME);
            } else if (this.isObjectLambdasArn(string)) {
                defaultRequest.addHandlerContext(HandlerContextKey.SIGNING_NAME, S3_OBJECT_LAMBDAS_NAME);
            }
            return defaultRequest;
        }
        if (this.isObjectLambdasRequest(x)) {
            this.validateConfigurationForObjectLambdaOperation();
            object = RegionUtils.getRegion(this.getRegionName());
            uRI = this.getEndpointForObjectLambdas(((com.amazonaws.regions.Region)object).getDomain(), ((com.amazonaws.regions.Region)object).getName());
            this.resolveRequestEndpoint(defaultRequest, null, null, uRI);
            if (x instanceof WriteGetObjectResponseRequest && !this.clientConfiguration.isDisableHostPrefixInjection()) {
                WriteGetObjectResponseRequest writeGetObjectResponseRequest = (WriteGetObjectResponseRequest)x;
                this.rejectNull(writeGetObjectResponseRequest.getRequestRoute(), "requestRoute must not be null");
                String string4 = writeGetObjectResponseRequest.getRequestRoute() + ".";
                URI uRI2 = UriResourcePathUtils.updateUriHost(defaultRequest.getEndpoint(), string4);
                this.resolveEndpointIdentity(defaultRequest, null, null, uRI2);
            }
            defaultRequest.addHandlerContext(HandlerContextKey.SIGNING_NAME, S3_OBJECT_LAMBDAS_NAME);
            return defaultRequest;
        }
        String string5 = this.getSigningRegion();
        if (this.clientOptions.isAccelerateModeEnabled() && !(x instanceof S3AccelerateUnsupported)) {
            uRI = this.clientOptions.isDualstackEnabled() ? RuntimeHttpUtils.toUri("s3-accelerate.dualstack.amazonaws.com", this.clientConfiguration) : RuntimeHttpUtils.toUri("s3-accelerate.amazonaws.com", this.clientConfiguration);
        }
        this.resolveRequestEndpoint(defaultRequest, string, string2, uRI);
        defaultRequest.addHandlerContext(HandlerContextKey.SIGNING_REGION, string5);
        return defaultRequest;
    }

    private void validateParentResourceIfNeeded(S3AccessPointResource s3AccessPointResource, String string) {
        if (s3AccessPointResource.getParentS3Resource() == null) {
            return;
        }
        String string2 = s3AccessPointResource.getParentS3Resource().getType();
        if (S3ResourceType.fromValue(string2) == S3ResourceType.OUTPOST) {
            if (this.clientOptions.isDualstackEnabled()) {
                throw new IllegalArgumentException(String.format("An ARN of type %s cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with dualstack", string2));
            }
            if (AmazonS3Client.isRegionFipsEnabled(string)) {
                throw new IllegalArgumentException(String.format("An ARN of type %s cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with a FIPS enabled region.", string2));
            }
        }
    }

    private URI getEndpointForAccessPoint(S3AccessPointResource s3AccessPointResource, String string) {
        URI uRI = this.isEndpointOverridden() ? this.getEndpoint() : null;
        S3Resource s3Resource = s3AccessPointResource.getParentS3Resource();
        String string2 = this.clientConfiguration.getProtocol().toString();
        if (s3Resource instanceof S3OutpostResource) {
            S3OutpostResource s3OutpostResource = (S3OutpostResource)s3Resource;
            return S3OutpostAccessPointBuilder.create().withEndpointOverride(uRI).withAccountId(s3AccessPointResource.getAccountId()).withOutpostId(s3OutpostResource.getOutpostId()).withRegion(s3AccessPointResource.getRegion()).withAccessPointName(s3AccessPointResource.getAccessPointName()).withProtocol(string2).withDomain(string).toURI();
        }
        com.amazonaws.regions.Region region = RegionUtils.getRegion(this.getRegionName());
        boolean bl = AmazonS3Client.isRegionFipsEnabled(region.getName());
        if (s3Resource != null && S3ResourceType.OBJECT_LAMBDAS.toString().equals(s3Resource.getType())) {
            return S3ObjectLambdaEndpointBuilder.create().withEndpointOverride(uRI).withAccessPointName(s3AccessPointResource.getAccessPointName()).withAccountId(s3AccessPointResource.getAccountId()).withRegion(s3AccessPointResource.getRegion()).withProtocol(string2).withDomain(string).withFipsEnabled(bl).withDualstackEnabled(this.clientOptions.isDualstackEnabled()).toURI();
        }
        return S3AccessPointBuilder.create().withEndpointOverride(uRI).withAccessPointName(s3AccessPointResource.getAccessPointName()).withAccountId(s3AccessPointResource.getAccountId()).withRegion(s3AccessPointResource.getRegion()).withProtocol(string2).withDomain(string).withDualstackEnabled(this.clientOptions.isDualstackEnabled()).withFipsEnabled(bl).toURI();
    }

    private URI getEndpointForObjectLambdas(String string, String string2) {
        if (this.isEndpointOverridden()) {
            return this.getEndpoint();
        }
        String string3 = null;
        if (this.clientConfiguration.getProtocol() != null) {
            string3 = this.clientConfiguration.getProtocol().toString();
        }
        return S3ObjectLambdaOperationEndpointBuilder.create().withProtocol(string3).withDomain(string).withRegion(string2).toURI();
    }

    private void validateConfiguration(S3Resource s3Resource) {
        String string = s3Resource.getType();
        if (S3ResourceType.fromValue(string) != S3ResourceType.ACCESS_POINT) {
            throw new IllegalArgumentException("An unsupported ARN was passed as a bucket parameter to an S3 operation");
        }
        if (this.clientOptions.isAccelerateModeEnabled()) {
            throw new IllegalArgumentException(String.format("An ARN of type %s cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with accelerate mode enabled.", string));
        }
        if (this.clientOptions.isPathStyleAccess()) {
            throw new IllegalArgumentException(String.format("An ARN of type %s cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with path style addressing enabled.", string));
        }
    }

    private void validateConfigurationForObjectLambdaOperation() {
        if (this.clientOptions.isDualstackEnabled()) {
            throw new IllegalArgumentException("S3 Object Lambda does not support dualstack endpoints");
        }
        if (this.clientOptions.isAccelerateModeEnabled()) {
            throw new IllegalArgumentException("S3 Object Lambda does not support accelerate endpoints");
        }
    }

    private void validateS3ResourceArn(Arn arn, com.amazonaws.regions.Region region) {
        String string;
        String string2 = string = region == null ? null : region.getPartition();
        if (this.isMultiRegionAccessPointArn(arn.toString())) {
            throw new IllegalArgumentException("AWS SDK for Java version 1.x does not support passing a multi-region access point Amazon Resource Names (ARNs) as a bucket parameter to an S3 operation. If this functionality is required by your application, please upgrade to AWS SDK for Java version 2.x");
        }
        if (string == null || !string.equals(arn.getPartition())) {
            throw new IllegalArgumentException("The partition field of the ARN being passed as a bucket parameter to an S3 operation does not match the partition the S3 client has been configured with. Provided partition: '" + arn.getPartition() + "'; client partition: '" + string + "'.");
        }
        this.validateIsTrue(!AmazonS3Client.isRegionFipsEnabled(arn.getRegion()), "Invalid ARN, FIPS region is not allowed in ARN. Provided arn region: '" + arn.getRegion() + "'.", new Object[0]);
        if (!this.clientOptions.isForceGlobalBucketAccessEnabled() && !this.useArnRegion() || AmazonS3Client.isRegionFipsEnabled(region.getName())) {
            this.validateIsTrue(this.removeFipsIfNeeded(region.getName()).equals(arn.getRegion()), "The region field of the ARN being passed as a bucket parameter to an S3 operation does not match the region the client was configured with. Provided region: '" + arn.getRegion() + "'; client region: '" + region.getName() + "'.", new Object[0]);
        }
    }

    private String removeFipsIfNeeded(String string) {
        if (string.startsWith("fips-")) {
            return string.replace("fips-", "");
        }
        if (string.endsWith("-fips")) {
            return string.replace("-fips", "");
        }
        return string;
    }

    private boolean useArnRegion() {
        if (this.clientOptions.isUseArnRegion()) {
            return this.clientOptions.isUseArnRegion();
        }
        return USE_ARN_REGION_RESOLVER.useArnRegion();
    }

    private void resolveAccessPointEndpoint(Request<?> request, String string, String string2, URI uRI) {
        this.resolveEndpointIdentity(request, string, string2, uRI);
    }

    private void resolveEndpointIdentity(Request<?> request, String string, String string2, URI uRI) {
        IdentityEndpointBuilder identityEndpointBuilder = new IdentityEndpointBuilder(uRI);
        this.buildEndpointResolver(identityEndpointBuilder, string, string2).resolveRequestEndpoint(request);
    }

    private void resolveRequestEndpoint(Request<?> request, String string, String string2, URI uRI) {
        ServiceEndpointBuilder serviceEndpointBuilder = this.getBuilder(uRI, uRI.getScheme(), false);
        this.buildEndpointResolver(serviceEndpointBuilder, string, string2).resolveRequestEndpoint(request);
    }

    private S3RequestEndpointResolver buildDefaultEndpointResolver(String string, String string2, String string3) {
        ServiceEndpointBuilder serviceEndpointBuilder = this.getBuilder(this.endpoint, string, true);
        return new S3RequestEndpointResolver(serviceEndpointBuilder, this.clientOptions.isPathStyleAccess(), string2, string3);
    }

    private ServiceEndpointBuilder getBuilder(URI uRI, String string, boolean bl) {
        if (this.clientOptions.isDualstackEnabled() && !this.clientOptions.isAccelerateModeEnabled()) {
            return new DualstackEndpointBuilder(this.getServiceNameIntern(), string, this.getRegion().toAWSRegion());
        }
        if (bl) {
            return new DefaultServiceEndpointBuilder(this.getServiceName(), string);
        }
        return new IdentityEndpointBuilder(uRI);
    }

    @Override
    public PresignedUrlDownloadResult download(PresignedUrlDownloadRequest presignedUrlDownloadRequest) throws SdkClientException {
        ValidationUtils.assertNotNull(presignedUrlDownloadRequest.getPresignedUrl(), "Presigned URL");
        ProgressListener progressListener = presignedUrlDownloadRequest.getGeneralProgressListener();
        Request<PresignedUrlDownloadRequest> request = this.createRequestForPresignedUrl(presignedUrlDownloadRequest, HttpMethodName.GET, presignedUrlDownloadRequest.getPresignedUrl());
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetObject");
        request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, Boolean.TRUE);
        long[] lArray = presignedUrlDownloadRequest.getRange();
        if (lArray != null) {
            request.addHeader("Range", "bytes=" + Long.toString(lArray[0]) + "-" + Long.toString(lArray[1]));
        }
        try {
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_STARTED_EVENT);
            S3Object s3Object = this.client.execute(request, new S3ObjectResponseHandler(), this.errorResponseHandler, this.createExecutionContext(AmazonWebServiceRequest.NOOP, new NoOpSignerProvider()), this.requestConfigWithSkipAppendUriPath(request)).getAwsResponse();
            boolean bl = this.skipMd5CheckStrategy.skipClientSideValidation(presignedUrlDownloadRequest, s3Object.getObjectMetadata());
            this.postProcessS3Object(s3Object, bl, progressListener);
            return new PresignedUrlDownloadResult().withS3Object(s3Object);
        }
        catch (AmazonS3Exception amazonS3Exception) {
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw amazonS3Exception;
        }
    }

    @Override
    public void download(final PresignedUrlDownloadRequest presignedUrlDownloadRequest, File file) throws SdkClientException {
        ValidationUtils.assertNotNull(file, "Destination file");
        ServiceUtils.retryableDownloadS3ObjectToFile(file, new ServiceUtils.RetryableS3DownloadTask(){

            @Override
            public S3Object getS3ObjectStream() {
                return AmazonS3Client.this.download(presignedUrlDownloadRequest).getS3Object();
            }

            @Override
            public boolean needIntegrityCheck() {
                return !AmazonS3Client.this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(presignedUrlDownloadRequest);
            }
        }, false);
    }

    @Override
    public PresignedUrlUploadResult upload(PresignedUrlUploadRequest presignedUrlUploadRequest) {
        presignedUrlUploadRequest = this.beforeClientExecution(presignedUrlUploadRequest);
        this.rejectNull(presignedUrlUploadRequest, "The PresignedUrlUploadRequest object cannot be null");
        this.rejectNull(presignedUrlUploadRequest.getPresignedUrl(), "Presigned URL");
        File file = presignedUrlUploadRequest.getFile();
        InputStream inputStream2 = presignedUrlUploadRequest.getInputStream();
        ProgressListener progressListener = presignedUrlUploadRequest.getGeneralProgressListener();
        ObjectMetadata objectMetadata = presignedUrlUploadRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        Request<PresignedUrlUploadRequest> request = this.createRequestForPresignedUrl(presignedUrlUploadRequest, presignedUrlUploadRequest.getHttpMethodName(), presignedUrlUploadRequest.getPresignedUrl());
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutObject");
        Integer n = Constants.getS3StreamBufferSize();
        if (n != null) {
            AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
            amazonWebServiceRequest.getRequestClientOptions().setReadLimit(n);
        }
        return this.uploadObject(inputStream2, file, objectMetadata, progressListener, request, presignedUrlUploadRequest, true, this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(presignedUrlUploadRequest), new PresignedUrlUploadStrategy(presignedUrlUploadRequest.getPresignedUrl()), !this.isSigV2PresignedUrl(presignedUrlUploadRequest.getPresignedUrl()));
    }

    private RequestConfig requestConfigWithSkipAppendUriPath(Request request) {
        AmazonWebServiceRequestAdapter amazonWebServiceRequestAdapter = new AmazonWebServiceRequestAdapter(request.getOriginalRequest());
        ((RequestConfig)amazonWebServiceRequestAdapter).getRequestClientOptions().setSkipAppendUriPath(true);
        return amazonWebServiceRequestAdapter;
    }

    private <X extends AmazonWebServiceRequest> Request<X> createRequestForPresignedUrl(X x, HttpMethodName httpMethodName, URL uRL) {
        DefaultRequest defaultRequest = new DefaultRequest(x, "Amazon S3");
        defaultRequest.setHttpMethod(httpMethodName);
        try {
            defaultRequest.setEndpoint(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SdkClientException(uRISyntaxException);
        }
        if (x.getCustomRequestHeaders() != null) {
            for (Map.Entry<String, String> entry : x.getCustomRequestHeaders().entrySet()) {
                defaultRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (defaultRequest.getHeaders().get("Content-Type") == null && this.isSigV2PresignedUrl(uRL)) {
            defaultRequest.addHeader("Content-Type", "");
        }
        defaultRequest.addHandlerContext(S3HandlerContextKeys.IS_CHUNKED_ENCODING_DISABLED, this.clientOptions.isChunkedEncodingDisabled());
        defaultRequest.addHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED, this.clientOptions.isPayloadSigningEnabled());
        defaultRequest.addHandlerContext(HandlerContextKey.SERVICE_ID, SERVICE_ID);
        return defaultRequest;
    }

    private boolean isSigV2PresignedUrl(URL uRL) {
        String string = uRL.toString();
        return string.contains("AWSAccessKeyId=") && !uRL.toString().contains("X-Amz-Algorithm=AWS4-HMAC-SHA256");
    }

    private S3RequestEndpointResolver buildEndpointResolver(ServiceEndpointBuilder serviceEndpointBuilder, String string, String string2) {
        return new S3RequestEndpointResolver(serviceEndpointBuilder, this.clientOptions.isPathStyleAccess(), string, string2);
    }

    @Override
    protected final SignerProvider createSignerProvider(Signer signer) {
        return new S3SignerProvider(this, signer);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, InputStream> unmarshaller, String string, String string2) {
        return this.invoke(request, new S3XmlResponseHandler<X>(unmarshaller), string, string2);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> httpResponseHandler, String string, String string2) {
        return this.invoke(request, httpResponseHandler, string, string2, false);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> httpResponseHandler, String string, String string2, boolean bl) {
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        this.checkHttps(amazonWebServiceRequest);
        S3SignerProvider s3SignerProvider = new S3SignerProvider(this, this.getSigner());
        ExecutionContext executionContext = this.createExecutionContext(amazonWebServiceRequest, s3SignerProvider);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        request.setAWSRequestMetrics(aWSRequestMetrics);
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Response response = null;
        try {
            request.setTimeOffset(this.timeOffset);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/octet-stream");
            }
            if (!bl && this.shouldPerformHeadRequestToFindRegion(request, string)) {
                this.fetchRegionFromCache(string);
            }
            Signer signer = this.createSigner(request, string, string2, bl);
            s3SignerProvider.setSigner(signer);
            if (this.isSignerOverridden() && !(signer instanceof AWSS3V4Signer)) {
                executionContext.setAuthErrorRetryStrategy(new S3V4AuthErrorRetryStrategy(this.buildDefaultEndpointResolver(AmazonS3Client.getProtocol(request), string, string2)));
            }
            executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
            this.validateRequestBeforeTransmit(request);
            response = this.client.execute(request, httpResponseHandler, this.errorResponseHandler, executionContext);
            Object t2 = response.getAwsResponse();
            return (X)t2;
        }
        catch (ResetException resetException) {
            resetException.setExtraInfo("If the request involves an input stream, the maximum stream buffer size can be configured via request.getRequestClientOptions().setReadLimit(int)");
            throw resetException;
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 301 && amazonS3Exception.getAdditionalDetails() != null) {
                String string3 = amazonS3Exception.getAdditionalDetails().get("x-amz-bucket-region");
                bucketRegionCache.put(string, string3);
                amazonS3Exception.setErrorMessage("The bucket is in this region: " + string3 + ". Please use this region to retry the request");
            }
            throw amazonS3Exception;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response);
        }
    }

    private void validateRequestBeforeTransmit(Request<?> request) {
        boolean bl = this.areImplicitGlobalClientsDisabled();
        boolean bl2 = this.clientOptions.isForceGlobalBucketAccessEnabled();
        if (this.noExplicitRegionProvided(request) && bl && !bl2) {
            String string = String.format("While the %s system property is enabled, Amazon S3 clients cannot be used without first configuring a region or explicitly enabling global bucket access discovery in the S3 client builder.", "com.amazonaws.services.s3.disableImplicitGlobalClients");
            throw new IllegalStateException(string);
        }
    }

    private boolean areImplicitGlobalClientsDisabled() {
        String string = System.getProperty("com.amazonaws.services.s3.disableImplicitGlobalClients");
        return string != null && !string.equals("false");
    }

    private boolean shouldPerformHeadRequestToFindRegion(Request<?> request, String string) {
        return string != null && !this.isAccessPointArn(string) && !(request.getOriginalRequest() instanceof CreateBucketRequest) && this.bucketRegionShouldBeCached(request);
    }

    private boolean isAccessPointArn(String string) {
        return string != null && string.startsWith("arn:") && (this.isS3AccessPointArn(string) || this.isOutpostAccessPointArn(string) || this.isObjectLambdasArn(string));
    }

    private boolean isS3AccessPointArn(String string) {
        return string.contains(":accesspoint");
    }

    private boolean isOutpostAccessPointArn(String string) {
        return string.contains(":s3-outposts");
    }

    private boolean isObjectLambdasArn(String string) {
        return string.contains(":s3-object-lambda");
    }

    private boolean isObjectLambdasRequest(AmazonWebServiceRequest amazonWebServiceRequest) {
        return amazonWebServiceRequest instanceof WriteGetObjectResponseRequest;
    }

    private boolean isMultiRegionAccessPointArn(String string) {
        return string.contains(":global");
    }

    private boolean isArn(String string) {
        return string != null && string.startsWith("arn:");
    }

    private boolean bucketRegionShouldBeCached(Request<?> request) {
        return this.clientOptions.isForceGlobalBucketAccessEnabled() || this.noExplicitRegionProvided(request);
    }

    @Override
    public void enableRequesterPays(String string) {
        RequestPaymentConfiguration requestPaymentConfiguration = new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.Requester);
        this.setRequestPaymentConfiguration(new SetRequestPaymentConfigurationRequest(string, requestPaymentConfiguration));
    }

    @Override
    public void disableRequesterPays(String string) {
        RequestPaymentConfiguration requestPaymentConfiguration = new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.BucketOwner);
        this.setRequestPaymentConfiguration(new SetRequestPaymentConfigurationRequest(string, requestPaymentConfiguration));
    }

    @Override
    public boolean isRequesterPaysEnabled(String string) {
        RequestPaymentConfiguration requestPaymentConfiguration = this.getBucketRequestPayment(new GetRequestPaymentConfigurationRequest(string));
        return requestPaymentConfiguration.getPayer() == RequestPaymentConfiguration.Payer.Requester;
    }

    @Override
    public void setRequestPaymentConfiguration(SetRequestPaymentConfigurationRequest setRequestPaymentConfigurationRequest) {
        String string = setRequestPaymentConfigurationRequest.getBucketName();
        RequestPaymentConfiguration requestPaymentConfiguration = setRequestPaymentConfigurationRequest.getConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified while setting the Requester Pays.");
        this.rejectNull(requestPaymentConfiguration, "The request payment configuration parameter must be specified when setting the Requester Pays.");
        Request<SetRequestPaymentConfigurationRequest> request = this.createRequest(string, null, setRequestPaymentConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketRequestPayment");
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] byArray = requestPaymentConfigurationXmlFactory.convertToXmlByteArray(requestPaymentConfiguration);
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    private RequestPaymentConfiguration getBucketRequestPayment(GetRequestPaymentConfigurationRequest getRequestPaymentConfigurationRequest) {
        String string = getRequestPaymentConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified while getting the Request Payment Configuration.");
        Request<GetRequestPaymentConfigurationRequest> request = this.createRequest(string, null, getRequestPaymentConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketRequestPayment");
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        return this.invoke(request, new Unmarshallers.RequestPaymentConfigurationUnmarshaller(), string, null);
    }

    private void setZeroContentLength(Request<?> request) {
        request.addHeader("Content-Length", String.valueOf(0));
    }

    private void checkHttps(AmazonWebServiceRequest amazonWebServiceRequest) {
        Object object;
        if (amazonWebServiceRequest instanceof SSECustomerKeyProvider) {
            object = (SSECustomerKeyProvider)((Object)amazonWebServiceRequest);
            if (object.getSSECustomerKey() != null) {
                this.assertHttps();
            }
        } else if (amazonWebServiceRequest instanceof CopyObjectRequest) {
            object = (CopyObjectRequest)amazonWebServiceRequest;
            if (((CopyObjectRequest)object).getSourceSSECustomerKey() != null || ((CopyObjectRequest)object).getDestinationSSECustomerKey() != null) {
                this.assertHttps();
            }
        } else if (amazonWebServiceRequest instanceof CopyPartRequest && (((CopyPartRequest)(object = (CopyPartRequest)amazonWebServiceRequest)).getSourceSSECustomerKey() != null || ((CopyPartRequest)object).getDestinationSSECustomerKey() != null)) {
            this.assertHttps();
        }
        if (amazonWebServiceRequest instanceof SSEAwsKeyManagementParamsProvider && (object = (SSEAwsKeyManagementParamsProvider)((Object)amazonWebServiceRequest)).getSSEAwsKeyManagementParams() != null) {
            this.assertHttps();
        }
    }

    private void assertHttps() {
        String string;
        URI uRI = this.endpoint;
        String string2 = string = uRI == null ? null : uRI.getScheme();
        if (!Protocol.HTTPS.toString().equalsIgnoreCase(string)) {
            throw new IllegalArgumentException("HTTPS must be used when sending customer encryption keys (SSE-C) to S3, in order to protect your encryption keys.");
        }
    }

    synchronized URI getEndpoint() {
        return this.endpoint;
    }

    private static String getProtocol(Request<?> request) {
        if (request == null || request.getEndpoint() == null) {
            return null;
        }
        return request.getEndpoint().getScheme();
    }

    protected final InitiateMultipartUploadRequest newInitiateMultipartUploadRequest(UploadObjectRequest uploadObjectRequest) {
        return (InitiateMultipartUploadRequest)((AmazonWebServiceRequest)new InitiateMultipartUploadRequest(uploadObjectRequest.getBucketName(), uploadObjectRequest.getKey(), uploadObjectRequest.getMetadata()).withRedirectLocation(uploadObjectRequest.getRedirectLocation()).withSSEAwsKeyManagementParams(uploadObjectRequest.getSSEAwsKeyManagementParams()).withSSECustomerKey(uploadObjectRequest.getSSECustomerKey()).withStorageClass(uploadObjectRequest.getStorageClass()).withAccessControlList(uploadObjectRequest.getAccessControlList()).withCannedACL(uploadObjectRequest.getCannedAcl()).withGeneralProgressListener(uploadObjectRequest.getGeneralProgressListener())).withRequestMetricCollector(uploadObjectRequest.getRequestMetricCollector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLocalObject(UploadObjectRequest uploadObjectRequest, OutputStream outputStream2) throws IOException {
        UploadObjectRequest uploadObjectRequest2 = uploadObjectRequest.clone();
        File file = uploadObjectRequest2.getFile();
        InputStream inputStream2 = uploadObjectRequest2.getInputStream();
        if (inputStream2 == null) {
            if (file == null) {
                throw new IllegalArgumentException("Either a file lor input stream must be specified");
            }
            uploadObjectRequest2.setInputStream(new FileInputStream(file));
            uploadObjectRequest2.setFile(null);
        }
        try {
            IOUtils.copy(uploadObjectRequest2.getInputStream(), outputStream2);
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(uploadObjectRequest2, file, inputStream2, uploadObjectRequest2.getInputStream(), log);
            IOUtils.closeQuietly(outputStream2, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompleteMultipartUploadResult uploadObject(UploadObjectRequest uploadObjectRequest) throws IOException, InterruptedException, ExecutionException {
        UploadObjectObserver uploadObjectObserver;
        boolean bl;
        ExecutorService executorService = uploadObjectRequest.getExecutorService();
        boolean bl2 = bl = executorService == null;
        if (executorService == null) {
            executorService = Executors.newFixedThreadPool(this.clientConfiguration.getMaxConnections());
        }
        if ((uploadObjectObserver = uploadObjectRequest.getUploadObjectObserver()) == null) {
            uploadObjectObserver = new UploadObjectObserver();
        }
        uploadObjectObserver.init(uploadObjectRequest, this, this, executorService);
        uploadObjectObserver.onUploadInitiation(uploadObjectRequest);
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        MultiFileOutputStream multiFileOutputStream = uploadObjectRequest.getMultiFileOutputStream();
        if (multiFileOutputStream == null) {
            multiFileOutputStream = new MultiFileOutputStream();
        }
        try {
            multiFileOutputStream.init(uploadObjectObserver, uploadObjectRequest.getPartSize(), uploadObjectRequest.getDiskLimit());
            this.putLocalObject(uploadObjectRequest, multiFileOutputStream);
            for (Future<UploadPartResult> future : uploadObjectObserver.getFutures()) {
                UploadPartResult uploadPartResult = future.get();
                arrayList.add(new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag()));
            }
        }
        finally {
            if (bl) {
                executorService.shutdownNow();
            }
            multiFileOutputStream.cleanup();
        }
        return uploadObjectObserver.onCompletion(arrayList);
    }

    @Override
    public void setBucketReplicationConfiguration(String string, BucketReplicationConfiguration bucketReplicationConfiguration) throws AmazonServiceException, SdkClientException {
        this.setBucketReplicationConfiguration(new SetBucketReplicationConfigurationRequest(string, bucketReplicationConfiguration));
    }

    @Override
    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest setBucketReplicationConfigurationRequest) throws AmazonServiceException, SdkClientException {
        setBucketReplicationConfigurationRequest = this.beforeClientExecution(setBucketReplicationConfigurationRequest);
        this.rejectNull(setBucketReplicationConfigurationRequest, "The set bucket replication configuration request object must be specified.");
        String string = setBucketReplicationConfigurationRequest.getBucketName();
        BucketReplicationConfiguration bucketReplicationConfiguration = setBucketReplicationConfigurationRequest.getReplicationConfiguration();
        this.rejectNull(string, "The bucket name parameter must be specified when setting replication configuration.");
        this.rejectNull(bucketReplicationConfiguration, "The replication configuration parameter must be specified when setting replication configuration.");
        Request<SetBucketReplicationConfigurationRequest> request = this.createRequest(string, null, setBucketReplicationConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketReplication");
        request.addParameter("replication", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(bucketReplicationConfiguration);
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-bucket-object-lock-token", setBucketReplicationConfigurationRequest.getToken());
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        this.populateRequestHeaderWithMd5(request, byArray);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(String string) throws AmazonServiceException, SdkClientException {
        return this.getBucketReplicationConfiguration(new GetBucketReplicationConfigurationRequest(string));
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest getBucketReplicationConfigurationRequest) throws AmazonServiceException, SdkClientException {
        getBucketReplicationConfigurationRequest = this.beforeClientExecution(getBucketReplicationConfigurationRequest);
        this.rejectNull(getBucketReplicationConfigurationRequest, "The bucket request parameter must be specified when retrieving replication configuration");
        String string = getBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket request must specify a bucket name when retrieving replication configuration");
        Request<GetBucketReplicationConfigurationRequest> request = this.createRequest(string, null, getBucketReplicationConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketReplication");
        request.addParameter("replication", null);
        return this.invoke(request, new Unmarshallers.BucketReplicationConfigurationUnmarshaller(), string, null);
    }

    @Override
    public void deleteBucketReplicationConfiguration(String string) throws AmazonServiceException, SdkClientException {
        this.deleteBucketReplicationConfiguration(new DeleteBucketReplicationConfigurationRequest(string));
    }

    @Override
    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest deleteBucketReplicationConfigurationRequest) throws AmazonServiceException, SdkClientException {
        deleteBucketReplicationConfigurationRequest = this.beforeClientExecution(deleteBucketReplicationConfigurationRequest);
        String string = deleteBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(string, "The bucket name parameter must be specified when deleting replication configuration");
        Request<DeleteBucketReplicationConfigurationRequest> request = this.createRequest(string, null, deleteBucketReplicationConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketReplication");
        request.addParameter("replication", null);
        this.invoke(request, this.voidResponseHandler, string, null);
    }

    @Override
    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.deleteBucketMetricsConfiguration(new DeleteBucketMetricsConfigurationRequest(string, string2));
    }

    @Override
    public DeleteBucketMetricsConfigurationResult deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws AmazonServiceException, SdkClientException {
        deleteBucketMetricsConfigurationRequest = this.beforeClientExecution(deleteBucketMetricsConfigurationRequest);
        this.rejectNull(deleteBucketMetricsConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(deleteBucketMetricsConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(deleteBucketMetricsConfigurationRequest.getId(), "Metrics Id");
        Request<DeleteBucketMetricsConfigurationRequest> request = this.createRequest(string, null, deleteBucketMetricsConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketMetricsConfiguration");
        request.addParameter("metrics", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.DeleteBucketMetricsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.getBucketMetricsConfiguration(new GetBucketMetricsConfigurationRequest(string, string2));
    }

    @Override
    public GetBucketMetricsConfigurationResult getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws AmazonServiceException, SdkClientException {
        getBucketMetricsConfigurationRequest = this.beforeClientExecution(getBucketMetricsConfigurationRequest);
        this.rejectNull(getBucketMetricsConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(getBucketMetricsConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(getBucketMetricsConfigurationRequest.getId(), "Metrics Id");
        Request<GetBucketMetricsConfigurationRequest> request = this.createRequest(string, null, getBucketMetricsConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketMetricsConfiguration");
        request.addParameter("metrics", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.GetBucketMetricsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public SetBucketMetricsConfigurationResult setBucketMetricsConfiguration(String string, MetricsConfiguration metricsConfiguration) throws AmazonServiceException, SdkClientException {
        return this.setBucketMetricsConfiguration(new SetBucketMetricsConfigurationRequest(string, metricsConfiguration));
    }

    @Override
    public SetBucketMetricsConfigurationResult setBucketMetricsConfiguration(SetBucketMetricsConfigurationRequest setBucketMetricsConfigurationRequest) throws AmazonServiceException, SdkClientException {
        setBucketMetricsConfigurationRequest = this.beforeClientExecution(setBucketMetricsConfigurationRequest);
        new SetBucketMetricsConfigurationRequest();
        this.rejectNull(setBucketMetricsConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(setBucketMetricsConfigurationRequest.getBucketName(), "BucketName");
        MetricsConfiguration metricsConfiguration = ValidationUtils.assertNotNull(setBucketMetricsConfigurationRequest.getMetricsConfiguration(), "Metrics Configuration");
        String string2 = ValidationUtils.assertNotNull(metricsConfiguration.getId(), "Metrics Id");
        Request<SetBucketMetricsConfigurationRequest> request = this.createRequest(string, null, setBucketMetricsConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketMetricsConfiguration");
        request.addParameter("metrics", null);
        request.addParameter("id", string2);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(metricsConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        return this.invoke(request, new Unmarshallers.SetBucketMetricsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public ListBucketMetricsConfigurationsResult listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws AmazonServiceException, SdkClientException {
        listBucketMetricsConfigurationsRequest = this.beforeClientExecution(listBucketMetricsConfigurationsRequest);
        this.rejectNull(listBucketMetricsConfigurationsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(listBucketMetricsConfigurationsRequest.getBucketName(), "BucketName");
        Request<ListBucketMetricsConfigurationsRequest> request = this.createRequest(string, null, listBucketMetricsConfigurationsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBucketMetricsConfigurations");
        request.addParameter("metrics", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketMetricsConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketMetricsConfigurationsUnmarshaller(), string, null);
    }

    @Override
    public DeleteBucketOwnershipControlsResult deleteBucketOwnershipControls(DeleteBucketOwnershipControlsRequest deleteBucketOwnershipControlsRequest) throws AmazonServiceException, SdkClientException {
        deleteBucketOwnershipControlsRequest = this.beforeClientExecution(deleteBucketOwnershipControlsRequest);
        this.rejectNull(deleteBucketOwnershipControlsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(deleteBucketOwnershipControlsRequest.getBucketName(), "BucketName");
        Request<DeleteBucketOwnershipControlsRequest> request = this.createRequest(string, null, deleteBucketOwnershipControlsRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketOwnershipControls");
        request.addParameter("ownershipControls", null);
        return this.invoke(request, new Unmarshallers.DeleteBucketOwnershipControlsUnmarshaller(), string, null);
    }

    @Override
    public GetBucketOwnershipControlsResult getBucketOwnershipControls(GetBucketOwnershipControlsRequest getBucketOwnershipControlsRequest) throws AmazonServiceException, SdkClientException {
        getBucketOwnershipControlsRequest = this.beforeClientExecution(getBucketOwnershipControlsRequest);
        this.rejectNull(getBucketOwnershipControlsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(getBucketOwnershipControlsRequest.getBucketName(), "BucketName");
        Request<GetBucketOwnershipControlsRequest> request = this.createRequest(string, null, getBucketOwnershipControlsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketOwnershipControls");
        request.addParameter("ownershipControls", null);
        return this.invoke(request, new Unmarshallers.GetBucketOwnershipControlsUnmarshaller(), string, null);
    }

    @Override
    public SetBucketOwnershipControlsResult setBucketOwnershipControls(String string, OwnershipControls ownershipControls) throws AmazonServiceException, SdkClientException {
        return this.setBucketOwnershipControls(new SetBucketOwnershipControlsRequest(string, ownershipControls));
    }

    @Override
    public SetBucketOwnershipControlsResult setBucketOwnershipControls(SetBucketOwnershipControlsRequest setBucketOwnershipControlsRequest) throws AmazonServiceException, SdkClientException {
        setBucketOwnershipControlsRequest = this.beforeClientExecution(setBucketOwnershipControlsRequest);
        this.rejectNull(setBucketOwnershipControlsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(setBucketOwnershipControlsRequest.getBucketName(), "BucketName");
        OwnershipControls ownershipControls = ValidationUtils.assertNotNull(setBucketOwnershipControlsRequest.getOwnershipControls(), "OwnershipControls");
        Request<SetBucketOwnershipControlsRequest> request = this.createRequest(string, null, setBucketOwnershipControlsRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketOwnershipControls");
        request.addParameter("ownershipControls", null);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(ownershipControls);
        this.setContent(request, byArray, "application/xml", true);
        return this.invoke(request, new Unmarshallers.SetBucketOwnershipControlsUnmarshaller(), string, null);
    }

    @Override
    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.deleteBucketAnalyticsConfiguration(new DeleteBucketAnalyticsConfigurationRequest(string, string2));
    }

    @Override
    public DeleteBucketAnalyticsConfigurationResult deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws AmazonServiceException, SdkClientException {
        deleteBucketAnalyticsConfigurationRequest = this.beforeClientExecution(deleteBucketAnalyticsConfigurationRequest);
        this.rejectNull(deleteBucketAnalyticsConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(deleteBucketAnalyticsConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(deleteBucketAnalyticsConfigurationRequest.getId(), "Analytics Id");
        Request<DeleteBucketAnalyticsConfigurationRequest> request = this.createRequest(string, null, deleteBucketAnalyticsConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketAnalyticsConfiguration");
        request.addParameter("analytics", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.DeleteBucketAnalyticsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.getBucketAnalyticsConfiguration(new GetBucketAnalyticsConfigurationRequest(string, string2));
    }

    @Override
    public GetBucketAnalyticsConfigurationResult getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws AmazonServiceException, SdkClientException {
        getBucketAnalyticsConfigurationRequest = this.beforeClientExecution(getBucketAnalyticsConfigurationRequest);
        this.rejectNull(getBucketAnalyticsConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(getBucketAnalyticsConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(getBucketAnalyticsConfigurationRequest.getId(), "Analytics Id");
        Request<GetBucketAnalyticsConfigurationRequest> request = this.createRequest(string, null, getBucketAnalyticsConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketAnalyticsConfiguration");
        request.addParameter("analytics", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.GetBucketAnalyticsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(String string, AnalyticsConfiguration analyticsConfiguration) throws AmazonServiceException, SdkClientException {
        return this.setBucketAnalyticsConfiguration(new SetBucketAnalyticsConfigurationRequest(string, analyticsConfiguration));
    }

    @Override
    public SetBucketAnalyticsConfigurationResult setBucketAnalyticsConfiguration(SetBucketAnalyticsConfigurationRequest setBucketAnalyticsConfigurationRequest) throws AmazonServiceException, SdkClientException {
        setBucketAnalyticsConfigurationRequest = this.beforeClientExecution(setBucketAnalyticsConfigurationRequest);
        this.rejectNull(setBucketAnalyticsConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(setBucketAnalyticsConfigurationRequest.getBucketName(), "BucketName");
        AnalyticsConfiguration analyticsConfiguration = ValidationUtils.assertNotNull(setBucketAnalyticsConfigurationRequest.getAnalyticsConfiguration(), "Analytics Configuration");
        String string2 = ValidationUtils.assertNotNull(analyticsConfiguration.getId(), "Analytics Id");
        Request<SetBucketAnalyticsConfigurationRequest> request = this.createRequest(string, null, setBucketAnalyticsConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketAnalyticsConfiguration");
        request.addParameter("analytics", null);
        request.addParameter("id", string2);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(analyticsConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        return this.invoke(request, new Unmarshallers.SetBucketAnalyticsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public ListBucketAnalyticsConfigurationsResult listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws AmazonServiceException, SdkClientException {
        listBucketAnalyticsConfigurationsRequest = this.beforeClientExecution(listBucketAnalyticsConfigurationsRequest);
        this.rejectNull(listBucketAnalyticsConfigurationsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(listBucketAnalyticsConfigurationsRequest.getBucketName(), "BucketName");
        Request<ListBucketAnalyticsConfigurationsRequest> request = this.createRequest(string, null, listBucketAnalyticsConfigurationsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBucketAnalyticsConfigurations");
        request.addParameter("analytics", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketAnalyticsConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketAnalyticsConfigurationUnmarshaller(), string, null);
    }

    @Override
    public DeleteBucketIntelligentTieringConfigurationResult deleteBucketIntelligentTieringConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.deleteBucketIntelligentTieringConfiguration(new DeleteBucketIntelligentTieringConfigurationRequest(string, string2));
    }

    @Override
    public DeleteBucketIntelligentTieringConfigurationResult deleteBucketIntelligentTieringConfiguration(DeleteBucketIntelligentTieringConfigurationRequest deleteBucketIntelligentTieringConfigurationRequest) throws AmazonServiceException, SdkClientException {
        deleteBucketIntelligentTieringConfigurationRequest = this.beforeClientExecution(deleteBucketIntelligentTieringConfigurationRequest);
        this.rejectNull(deleteBucketIntelligentTieringConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(deleteBucketIntelligentTieringConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(deleteBucketIntelligentTieringConfigurationRequest.getId(), "IntelligentTiering Id");
        Request<DeleteBucketIntelligentTieringConfigurationRequest> request = this.createRequest(string, null, deleteBucketIntelligentTieringConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketIntelligentTieringConfiguration");
        request.addParameter("intelligent-tiering", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.DeleteBucketIntelligenTieringConfigurationUnmarshaller(), string, null);
    }

    @Override
    public GetBucketIntelligentTieringConfigurationResult getBucketIntelligentTieringConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.getBucketIntelligentTieringConfiguration(new GetBucketIntelligentTieringConfigurationRequest(string, string2));
    }

    @Override
    public GetBucketIntelligentTieringConfigurationResult getBucketIntelligentTieringConfiguration(GetBucketIntelligentTieringConfigurationRequest getBucketIntelligentTieringConfigurationRequest) throws AmazonServiceException, SdkClientException {
        getBucketIntelligentTieringConfigurationRequest = this.beforeClientExecution(getBucketIntelligentTieringConfigurationRequest);
        this.rejectNull(getBucketIntelligentTieringConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(getBucketIntelligentTieringConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(getBucketIntelligentTieringConfigurationRequest.getId(), "IntelligentTiering Id");
        Request<GetBucketIntelligentTieringConfigurationRequest> request = this.createRequest(string, null, getBucketIntelligentTieringConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketIntelligentTieringConfiguration");
        request.addParameter("intelligent-tiering", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.GetBucketIntelligenTieringConfigurationUnmarshaller(), string, null);
    }

    @Override
    public SetBucketIntelligentTieringConfigurationResult setBucketIntelligentTieringConfiguration(String string, IntelligentTieringConfiguration intelligentTieringConfiguration) throws AmazonServiceException, SdkClientException {
        return this.setBucketIntelligentTieringConfiguration(new SetBucketIntelligentTieringConfigurationRequest(string, intelligentTieringConfiguration));
    }

    @Override
    public SetBucketIntelligentTieringConfigurationResult setBucketIntelligentTieringConfiguration(SetBucketIntelligentTieringConfigurationRequest setBucketIntelligentTieringConfigurationRequest) throws AmazonServiceException, SdkClientException {
        setBucketIntelligentTieringConfigurationRequest = this.beforeClientExecution(setBucketIntelligentTieringConfigurationRequest);
        this.rejectNull(setBucketIntelligentTieringConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(setBucketIntelligentTieringConfigurationRequest.getBucketName(), "BucketName");
        IntelligentTieringConfiguration intelligentTieringConfiguration = ValidationUtils.assertNotNull(setBucketIntelligentTieringConfigurationRequest.getIntelligentTierinConfiguration(), "Intelligent Tiering Configuration");
        String string2 = ValidationUtils.assertNotNull(intelligentTieringConfiguration.getId(), "Intelligent Tiering Id");
        Request<SetBucketIntelligentTieringConfigurationRequest> request = this.createRequest(string, null, setBucketIntelligentTieringConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketIntelligentTieringConfiguration");
        request.addParameter("intelligent-tiering", null);
        request.addParameter("id", string2);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(intelligentTieringConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        return this.invoke(request, new Unmarshallers.SetBucketIntelligentTieringConfigurationUnmarshaller(), string, null);
    }

    @Override
    public ListBucketIntelligentTieringConfigurationsResult listBucketIntelligentTieringConfigurations(ListBucketIntelligentTieringConfigurationsRequest listBucketIntelligentTieringConfigurationsRequest) throws AmazonServiceException, SdkClientException {
        listBucketIntelligentTieringConfigurationsRequest = this.beforeClientExecution(listBucketIntelligentTieringConfigurationsRequest);
        this.rejectNull(listBucketIntelligentTieringConfigurationsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(listBucketIntelligentTieringConfigurationsRequest.getBucketName(), "BucketName");
        Request<ListBucketIntelligentTieringConfigurationsRequest> request = this.createRequest(string, null, listBucketIntelligentTieringConfigurationsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBucketIntelligentTieringConfigurations");
        request.addParameter("intelligent-tiering", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketIntelligentTieringConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketIntelligenTieringConfigurationUnmarshaller(), string, null);
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.deleteBucketInventoryConfiguration(new DeleteBucketInventoryConfigurationRequest(string, string2));
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws AmazonServiceException, SdkClientException {
        deleteBucketInventoryConfigurationRequest = this.beforeClientExecution(deleteBucketInventoryConfigurationRequest);
        this.rejectNull(deleteBucketInventoryConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(deleteBucketInventoryConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(deleteBucketInventoryConfigurationRequest.getId(), "Inventory id");
        Request<DeleteBucketInventoryConfigurationRequest> request = this.createRequest(string, null, deleteBucketInventoryConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteBucketInventoryConfiguration");
        request.addParameter("inventory", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.DeleteBucketInventoryConfigurationUnmarshaller(), string, null);
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(String string, String string2) throws AmazonServiceException, SdkClientException {
        return this.getBucketInventoryConfiguration(new GetBucketInventoryConfigurationRequest(string, string2));
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws AmazonServiceException, SdkClientException {
        getBucketInventoryConfigurationRequest = this.beforeClientExecution(getBucketInventoryConfigurationRequest);
        this.rejectNull(getBucketInventoryConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(getBucketInventoryConfigurationRequest.getBucketName(), "BucketName");
        String string2 = ValidationUtils.assertStringNotEmpty(getBucketInventoryConfigurationRequest.getId(), "Inventory id");
        Request<GetBucketInventoryConfigurationRequest> request = this.createRequest(string, null, getBucketInventoryConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetBucketInventoryConfiguration");
        request.addParameter("inventory", null);
        request.addParameter("id", string2);
        return this.invoke(request, new Unmarshallers.GetBucketInventoryConfigurationUnmarshaller(), string, null);
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(String string, InventoryConfiguration inventoryConfiguration) throws AmazonServiceException, SdkClientException {
        return this.setBucketInventoryConfiguration(new SetBucketInventoryConfigurationRequest(string, inventoryConfiguration));
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws AmazonServiceException, SdkClientException {
        setBucketInventoryConfigurationRequest = this.beforeClientExecution(setBucketInventoryConfigurationRequest);
        this.rejectNull(setBucketInventoryConfigurationRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(setBucketInventoryConfigurationRequest.getBucketName(), "BucketName");
        InventoryConfiguration inventoryConfiguration = ValidationUtils.assertNotNull(setBucketInventoryConfigurationRequest.getInventoryConfiguration(), "InventoryConfiguration");
        String string2 = ValidationUtils.assertNotNull(inventoryConfiguration.getId(), "Inventory id");
        Request<SetBucketInventoryConfigurationRequest> request = this.createRequest(string, null, setBucketInventoryConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutBucketInventoryConfiguration");
        request.addParameter("inventory", null);
        request.addParameter("id", string2);
        byte[] byArray = bucketConfigurationXmlFactory.convertToXmlByteArray(inventoryConfiguration);
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(byArray));
        return this.invoke(request, new Unmarshallers.SetBucketInventoryConfigurationUnmarshaller(), string, null);
    }

    @Override
    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws AmazonServiceException, SdkClientException {
        listBucketInventoryConfigurationsRequest = this.beforeClientExecution(listBucketInventoryConfigurationsRequest);
        this.rejectNull(listBucketInventoryConfigurationsRequest, "The request cannot be null");
        String string = ValidationUtils.assertStringNotEmpty(listBucketInventoryConfigurationsRequest.getBucketName(), "BucketName");
        Request<ListBucketInventoryConfigurationsRequest> request = this.createRequest(string, null, listBucketInventoryConfigurationsRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListBucketInventoryConfigurations");
        request.addParameter("inventory", null);
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listBucketInventoryConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketInventoryConfigurationsUnmarshaller(), string, null);
    }

    URI resolveServiceEndpointFromBucketName(String string) {
        if (this.getSignerRegion() != null || this.isSignerOverridden()) {
            return this.endpoint;
        }
        String string2 = this.fetchRegionFromCache(string);
        return this.resolveServiceEndpointFromRegion(string2);
    }

    private URI resolveServiceEndpointFromRegion(String string) {
        com.amazonaws.regions.Region region = RegionUtils.getRegion(string);
        if (region == null) {
            log.warn("Region information for " + string + " is not available. Please upgrade to latest version of AWS Java SDK");
        }
        return region != null ? RuntimeHttpUtils.toUri(region.getServiceEndpoint(S3_SERVICE_NAME), this.clientConfiguration) : this.endpoint;
    }

    private String fetchRegionFromCache(String string) {
        String string2 = bucketRegionCache.get(string);
        if (string2 == null) {
            if (log.isDebugEnabled()) {
                log.debug("Bucket region cache doesn't have an entry for " + string + ". Trying to get bucket region from Amazon S3.");
            }
            if ((string2 = this.getBucketRegionViaHeadRequest(string)) != null) {
                bucketRegionCache.put(string, string2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Region for " + string + " is " + string2);
        }
        return string2;
    }

    private String getBucketRegionViaHeadRequest(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                Request<HeadBucketRequest> request = this.createRequest(string, null, new HeadBucketRequest(string), HttpMethodName.HEAD);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "HeadBucket");
                HeadBucketResult headBucketResult = this.invoke(request, new HeadBucketResultHandler(), string, null, true);
                string2 = headBucketResult.getBucketRegion();
            }
            catch (AmazonS3Exception amazonS3Exception) {
                if (amazonS3Exception.getAdditionalDetails() == null) break block3;
                string2 = amazonS3Exception.getAdditionalDetails().get("x-amz-bucket-region");
            }
        }
        if (string2 == null && log.isDebugEnabled()) {
            log.debug("Not able to derive region of the " + string + " from the HEAD Bucket requests.");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonS3Waiters waiters() {
        if (this.waiters == null) {
            AmazonS3Client amazonS3Client = this;
            synchronized (amazonS3Client) {
                if (this.waiters == null) {
                    this.waiters = new AmazonS3Waiters(this);
                }
            }
        }
        return this.waiters;
    }

    private String urlEncodeTags(ObjectTagging objectTagging) {
        if (objectTagging == null || objectTagging.getTagSet() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Tag> iterator2 = objectTagging.getTagSet().iterator();
        while (iterator2.hasNext()) {
            Tag tag = iterator2.next();
            stringBuilder.append(SdkHttpUtils.urlEncode(tag.getKey(), false)).append('=').append(SdkHttpUtils.urlEncode(tag.getValue(), false));
            if (!iterator2.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private void setContent(Request<?> request, byte[] byArray, String string, boolean bl) {
        request.setContent(new ByteArrayInputStream(byArray));
        request.addHeader("Content-Length", Integer.toString(byArray.length));
        request.addHeader("Content-Type", string);
        if (bl) {
            try {
                byte[] byArray2 = Md5Utils.computeMD5Hash(byArray);
                String string2 = BinaryUtils.toBase64(byArray2);
                request.addHeader("Content-MD5", string2);
            }
            catch (Exception exception) {
                throw new AmazonClientException("Couldn't compute md5 sum", exception);
            }
        }
    }

    private Request<RestoreObjectRequest> createRestoreObjectRequest(RestoreObjectRequest restoreObjectRequest) {
        String string = restoreObjectRequest.getBucketName();
        String string2 = restoreObjectRequest.getKey();
        String string3 = restoreObjectRequest.getVersionId();
        Request<RestoreObjectRequest> request = this.createRequest(string, string2, restoreObjectRequest, HttpMethodName.POST);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "RestoreObject");
        request.addParameter("restore", null);
        if (string3 != null) {
            request.addParameter("versionId", string3);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, restoreObjectRequest.isRequesterPays());
        byte[] byArray = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        this.setContent(request, byArray, "application/xml", true);
        return request;
    }

    private static void populateObjectLockHeaders(Request<?> request, String string, Date date, String string2) {
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-object-lock-mode", string);
        if (date != null) {
            request.addHeader("x-amz-object-lock-retain-until-date", ServiceUtils.formatIso8601Date(date));
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-object-lock-legal-hold", string2);
    }

    private PresignedUrlUploadResult createPresignedUrlUploadResult(ObjectMetadata objectMetadata, String string) {
        PresignedUrlUploadResult presignedUrlUploadResult = new PresignedUrlUploadResult();
        presignedUrlUploadResult.setMetadata(objectMetadata);
        presignedUrlUploadResult.setContentMd5(string);
        return presignedUrlUploadResult;
    }

    private void validateIsTrue(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    static {
        AwsSdkMetrics.addAll(Arrays.asList(S3ServiceMetric.values()));
        SignerFactory.registerSigner(S3_SIGNER, S3Signer.class);
        SignerFactory.registerSigner(S3_V4_SIGNER, AWSS3V4Signer.class);
        bucketConfigurationXmlFactory = new BucketConfigurationXmlFactory();
        requestPaymentConfigurationXmlFactory = new RequestPaymentConfigurationXmlFactory();
        USE_ARN_REGION_RESOLVER = new UseArnRegionResolver();
        REGIONAL_ENDPOINTS_OPTION_RESOLVER = new RegionalEndpointsOptionResolver();
        bucketRegionCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(300, 1.1f, true){
            private static final long serialVersionUID = 23453L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> entry) {
                return this.size() > 300;
            }
        });
    }

    private class PresignedUrlUploadStrategy
    implements UploadObjectStrategy<PresignedUrlUploadRequest, PresignedUrlUploadResult> {
        private final URL url;

        private PresignedUrlUploadStrategy(URL uRL) {
            this.url = uRL;
        }

        @Override
        public ObjectMetadata invokeServiceCall(Request<PresignedUrlUploadRequest> request) {
            return AmazonS3Client.this.client.execute(request, new S3MetadataResponseHandler(), AmazonS3Client.this.errorResponseHandler, AmazonS3Client.this.createExecutionContext(AmazonWebServiceRequest.NOOP, new NoOpSignerProvider()), AmazonS3Client.this.requestConfigWithSkipAppendUriPath(request)).getAwsResponse();
        }

        @Override
        public PresignedUrlUploadResult createResult(ObjectMetadata objectMetadata, String string) {
            return AmazonS3Client.this.createPresignedUrlUploadResult(objectMetadata, string);
        }

        @Override
        public String md5ValidationErrorSuffix() {
            return ", object presigned url: " + this.url;
        }
    }

    private class PutObjectStrategy
    implements UploadObjectStrategy<PutObjectRequest, PutObjectResult> {
        private final String bucketName;
        private final String key;

        private PutObjectStrategy(String string, String string2) {
            this.bucketName = string;
            this.key = string2;
        }

        @Override
        public ObjectMetadata invokeServiceCall(Request<PutObjectRequest> request) {
            return (ObjectMetadata)AmazonS3Client.this.invoke(request, new S3MetadataResponseHandler(), this.bucketName, this.key);
        }

        @Override
        public PutObjectResult createResult(ObjectMetadata objectMetadata, String string) {
            PutObjectResult putObjectResult = AmazonS3Client.createPutObjectResult(objectMetadata);
            putObjectResult.setContentMd5(string);
            return putObjectResult;
        }

        @Override
        public String md5ValidationErrorSuffix() {
            return ", bucketName: " + this.bucketName + ", key: " + this.key;
        }
    }
}

