/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.OperationInfo;
import com.amazonaws.protocol.Protocol;
import com.amazonaws.protocol.ProtocolRequestMarshaller;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.transform.DecryptRequestMarshaller;
import com.amazonaws.transform.Marshaller;

@SdkInternalApi
public class DecryptRequestProtocolMarshaller
implements Marshaller<Request<DecryptRequest>, DecryptRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("TrentService.Decrypt").serviceName("AWSKMS").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public DecryptRequestProtocolMarshaller(SdkJsonProtocolFactory sdkJsonProtocolFactory) {
        this.protocolFactory = sdkJsonProtocolFactory;
    }

    @Override
    public Request<DecryptRequest> marshall(DecryptRequest decryptRequest) {
        if (decryptRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ProtocolRequestMarshaller<DecryptRequest> protocolRequestMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, decryptRequest);
            protocolRequestMarshaller.startMarshalling();
            DecryptRequestMarshaller.getInstance().marshall(decryptRequest, protocolRequestMarshaller);
            return protocolRequestMarshaller.finishMarshalling();
        }
        catch (Exception exception) {
            throw new SdkClientException("Unable to marshall request to JSON: " + exception.getMessage(), exception);
        }
    }
}

