/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TagResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private SdkInternalList<Tag> tags;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public TagResourceRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> collection) {
        if (collection == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(collection);
    }

    public TagResourceRequest withTags(Tag ... tagArray) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tagArray.length));
        }
        for (Tag tag : tagArray) {
            this.tags.add(tag);
        }
        return this;
    }

    public TagResourceRequest withTags(Collection<Tag> collection) {
        this.setTags(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getTags() != null) {
            stringBuilder.append("Tags: ").append(this.getTags());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest tagResourceRequest = (TagResourceRequest)object;
        if (tagResourceRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (tagResourceRequest.getKeyId() != null && !tagResourceRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (tagResourceRequest.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return tagResourceRequest.getTags() == null || tagResourceRequest.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return n2;
    }

    @Override
    public TagResourceRequest clone() {
        return (TagResourceRequest)super.clone();
    }
}

