/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.MessageType;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class SignRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private ByteBuffer message;
    private String messageType;
    private SdkInternalList<String> grantTokens;
    private String signingAlgorithm;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public SignRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setMessage(ByteBuffer byteBuffer) {
        this.message = byteBuffer;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    public SignRequest withMessage(ByteBuffer byteBuffer) {
        this.setMessage(byteBuffer);
        return this;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public SignRequest withMessageType(String string) {
        this.setMessageType(string);
        return this;
    }

    public SignRequest withMessageType(MessageType messageType) {
        this.messageType = messageType.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public SignRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public SignRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public void setSigningAlgorithm(String string) {
        this.signingAlgorithm = string;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public SignRequest withSigningAlgorithm(String string) {
        this.setSigningAlgorithm(string);
        return this;
    }

    public SignRequest withSigningAlgorithm(SigningAlgorithmSpec signingAlgorithmSpec) {
        this.signingAlgorithm = signingAlgorithmSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getMessage() != null) {
            stringBuilder.append("Message: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMessageType() != null) {
            stringBuilder.append("MessageType: ").append(this.getMessageType()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens()).append(",");
        }
        if (this.getSigningAlgorithm() != null) {
            stringBuilder.append("SigningAlgorithm: ").append(this.getSigningAlgorithm());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SignRequest)) {
            return false;
        }
        SignRequest signRequest = (SignRequest)object;
        if (signRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (signRequest.getKeyId() != null && !signRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (signRequest.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (signRequest.getMessage() != null && !signRequest.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (signRequest.getMessageType() == null ^ this.getMessageType() == null) {
            return false;
        }
        if (signRequest.getMessageType() != null && !signRequest.getMessageType().equals(this.getMessageType())) {
            return false;
        }
        if (signRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        if (signRequest.getGrantTokens() != null && !signRequest.getGrantTokens().equals(this.getGrantTokens())) {
            return false;
        }
        if (signRequest.getSigningAlgorithm() == null ^ this.getSigningAlgorithm() == null) {
            return false;
        }
        return signRequest.getSigningAlgorithm() == null || signRequest.getSigningAlgorithm().equals(this.getSigningAlgorithm());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        n2 = 31 * n2 + (this.getMessageType() == null ? 0 : this.getMessageType().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        n2 = 31 * n2 + (this.getSigningAlgorithm() == null ? 0 : this.getSigningAlgorithm().hashCode());
        return n2;
    }

    @Override
    public SignRequest clone() {
        return (SignRequest)super.clone();
    }
}

