/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.KeyMetadata;
import com.amazonaws.services.kms.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ReplicateKeyResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private KeyMetadata replicaKeyMetadata;
    private String replicaPolicy;
    private SdkInternalList<Tag> replicaTags;

    public void setReplicaKeyMetadata(KeyMetadata keyMetadata) {
        this.replicaKeyMetadata = keyMetadata;
    }

    public KeyMetadata getReplicaKeyMetadata() {
        return this.replicaKeyMetadata;
    }

    public ReplicateKeyResult withReplicaKeyMetadata(KeyMetadata keyMetadata) {
        this.setReplicaKeyMetadata(keyMetadata);
        return this;
    }

    public void setReplicaPolicy(String string) {
        this.replicaPolicy = string;
    }

    public String getReplicaPolicy() {
        return this.replicaPolicy;
    }

    public ReplicateKeyResult withReplicaPolicy(String string) {
        this.setReplicaPolicy(string);
        return this;
    }

    public List<Tag> getReplicaTags() {
        if (this.replicaTags == null) {
            this.replicaTags = new SdkInternalList();
        }
        return this.replicaTags;
    }

    public void setReplicaTags(Collection<Tag> collection) {
        if (collection == null) {
            this.replicaTags = null;
            return;
        }
        this.replicaTags = new SdkInternalList<Tag>(collection);
    }

    public ReplicateKeyResult withReplicaTags(Tag ... tagArray) {
        if (this.replicaTags == null) {
            this.setReplicaTags(new SdkInternalList<Tag>(tagArray.length));
        }
        for (Tag tag : tagArray) {
            this.replicaTags.add(tag);
        }
        return this;
    }

    public ReplicateKeyResult withReplicaTags(Collection<Tag> collection) {
        this.setReplicaTags(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getReplicaKeyMetadata() != null) {
            stringBuilder.append("ReplicaKeyMetadata: ").append(this.getReplicaKeyMetadata()).append(",");
        }
        if (this.getReplicaPolicy() != null) {
            stringBuilder.append("ReplicaPolicy: ").append(this.getReplicaPolicy()).append(",");
        }
        if (this.getReplicaTags() != null) {
            stringBuilder.append("ReplicaTags: ").append(this.getReplicaTags());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ReplicateKeyResult)) {
            return false;
        }
        ReplicateKeyResult replicateKeyResult = (ReplicateKeyResult)object;
        if (replicateKeyResult.getReplicaKeyMetadata() == null ^ this.getReplicaKeyMetadata() == null) {
            return false;
        }
        if (replicateKeyResult.getReplicaKeyMetadata() != null && !replicateKeyResult.getReplicaKeyMetadata().equals(this.getReplicaKeyMetadata())) {
            return false;
        }
        if (replicateKeyResult.getReplicaPolicy() == null ^ this.getReplicaPolicy() == null) {
            return false;
        }
        if (replicateKeyResult.getReplicaPolicy() != null && !replicateKeyResult.getReplicaPolicy().equals(this.getReplicaPolicy())) {
            return false;
        }
        if (replicateKeyResult.getReplicaTags() == null ^ this.getReplicaTags() == null) {
            return false;
        }
        return replicateKeyResult.getReplicaTags() == null || replicateKeyResult.getReplicaTags().equals(this.getReplicaTags());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getReplicaKeyMetadata() == null ? 0 : this.getReplicaKeyMetadata().hashCode());
        n2 = 31 * n2 + (this.getReplicaPolicy() == null ? 0 : this.getReplicaPolicy().hashCode());
        n2 = 31 * n2 + (this.getReplicaTags() == null ? 0 : this.getReplicaTags().hashCode());
        return n2;
    }

    public ReplicateKeyResult clone() {
        try {
            return (ReplicateKeyResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

