/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListResourceTagsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Tag> tags;
    private String nextMarker;
    private Boolean truncated;

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> collection) {
        if (collection == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(collection);
    }

    public ListResourceTagsResult withTags(Tag ... tagArray) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tagArray.length));
        }
        for (Tag tag : tagArray) {
            this.tags.add(tag);
        }
        return this;
    }

    public ListResourceTagsResult withTags(Collection<Tag> collection) {
        this.setTags(collection);
        return this;
    }

    public void setNextMarker(String string) {
        this.nextMarker = string;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListResourceTagsResult withNextMarker(String string) {
        this.setNextMarker(string);
        return this;
    }

    public void setTruncated(Boolean bl) {
        this.truncated = bl;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public ListResourceTagsResult withTruncated(Boolean bl) {
        this.setTruncated(bl);
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTags() != null) {
            stringBuilder.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getNextMarker() != null) {
            stringBuilder.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getTruncated() != null) {
            stringBuilder.append("Truncated: ").append(this.getTruncated());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListResourceTagsResult)) {
            return false;
        }
        ListResourceTagsResult listResourceTagsResult = (ListResourceTagsResult)object;
        if (listResourceTagsResult.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (listResourceTagsResult.getTags() != null && !listResourceTagsResult.getTags().equals(this.getTags())) {
            return false;
        }
        if (listResourceTagsResult.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (listResourceTagsResult.getNextMarker() != null && !listResourceTagsResult.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (listResourceTagsResult.getTruncated() == null ^ this.getTruncated() == null) {
            return false;
        }
        return listResourceTagsResult.getTruncated() == null || listResourceTagsResult.getTruncated().equals(this.getTruncated());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getTags() == null ? 0 : this.getTags().hashCode());
        n2 = 31 * n2 + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        n2 = 31 * n2 + (this.getTruncated() == null ? 0 : this.getTruncated().hashCode());
        return n2;
    }

    public ListResourceTagsResult clone() {
        try {
            return (ListResourceTagsResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

