/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.KeyListEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListKeysResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<KeyListEntry> keys;
    private String nextMarker;
    private Boolean truncated;

    public List<KeyListEntry> getKeys() {
        if (this.keys == null) {
            this.keys = new SdkInternalList();
        }
        return this.keys;
    }

    public void setKeys(Collection<KeyListEntry> collection) {
        if (collection == null) {
            this.keys = null;
            return;
        }
        this.keys = new SdkInternalList<KeyListEntry>(collection);
    }

    public ListKeysResult withKeys(KeyListEntry ... keyListEntryArray) {
        if (this.keys == null) {
            this.setKeys(new SdkInternalList<KeyListEntry>(keyListEntryArray.length));
        }
        for (KeyListEntry keyListEntry : keyListEntryArray) {
            this.keys.add(keyListEntry);
        }
        return this;
    }

    public ListKeysResult withKeys(Collection<KeyListEntry> collection) {
        this.setKeys(collection);
        return this;
    }

    public void setNextMarker(String string) {
        this.nextMarker = string;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListKeysResult withNextMarker(String string) {
        this.setNextMarker(string);
        return this;
    }

    public void setTruncated(Boolean bl) {
        this.truncated = bl;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public ListKeysResult withTruncated(Boolean bl) {
        this.setTruncated(bl);
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeys() != null) {
            stringBuilder.append("Keys: ").append(this.getKeys()).append(",");
        }
        if (this.getNextMarker() != null) {
            stringBuilder.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getTruncated() != null) {
            stringBuilder.append("Truncated: ").append(this.getTruncated());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListKeysResult)) {
            return false;
        }
        ListKeysResult listKeysResult = (ListKeysResult)object;
        if (listKeysResult.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (listKeysResult.getKeys() != null && !listKeysResult.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (listKeysResult.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (listKeysResult.getNextMarker() != null && !listKeysResult.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (listKeysResult.getTruncated() == null ^ this.getTruncated() == null) {
            return false;
        }
        return listKeysResult.getTruncated() == null || listKeysResult.getTruncated().equals(this.getTruncated());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        n2 = 31 * n2 + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        n2 = 31 * n2 + (this.getTruncated() == null ? 0 : this.getTruncated().hashCode());
        return n2;
    }

    public ListKeysResult clone() {
        try {
            return (ListKeysResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

