/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.services.kms.model.GrantOperation;
import com.amazonaws.services.kms.model.transform.GrantListEntryMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GrantListEntry
implements StructuredPojo,
Serializable,
Cloneable {
    private String keyId;
    private String grantId;
    private String name;
    private Date creationDate;
    private String granteePrincipal;
    private String retiringPrincipal;
    private String issuingAccount;
    private SdkInternalList<String> operations;
    private GrantConstraints constraints;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public GrantListEntry withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setGrantId(String string) {
        this.grantId = string;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public GrantListEntry withGrantId(String string) {
        this.setGrantId(string);
        return this;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public GrantListEntry withName(String string) {
        this.setName(string);
        return this;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public GrantListEntry withCreationDate(Date date) {
        this.setCreationDate(date);
        return this;
    }

    public void setGranteePrincipal(String string) {
        this.granteePrincipal = string;
    }

    public String getGranteePrincipal() {
        return this.granteePrincipal;
    }

    public GrantListEntry withGranteePrincipal(String string) {
        this.setGranteePrincipal(string);
        return this;
    }

    public void setRetiringPrincipal(String string) {
        this.retiringPrincipal = string;
    }

    public String getRetiringPrincipal() {
        return this.retiringPrincipal;
    }

    public GrantListEntry withRetiringPrincipal(String string) {
        this.setRetiringPrincipal(string);
        return this;
    }

    public void setIssuingAccount(String string) {
        this.issuingAccount = string;
    }

    public String getIssuingAccount() {
        return this.issuingAccount;
    }

    public GrantListEntry withIssuingAccount(String string) {
        this.setIssuingAccount(string);
        return this;
    }

    public List<String> getOperations() {
        if (this.operations == null) {
            this.operations = new SdkInternalList();
        }
        return this.operations;
    }

    public void setOperations(Collection<String> collection) {
        if (collection == null) {
            this.operations = null;
            return;
        }
        this.operations = new SdkInternalList<String>(collection);
    }

    public GrantListEntry withOperations(String ... stringArray) {
        if (this.operations == null) {
            this.setOperations(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.operations.add(string);
        }
        return this;
    }

    public GrantListEntry withOperations(Collection<String> collection) {
        this.setOperations(collection);
        return this;
    }

    public GrantListEntry withOperations(GrantOperation ... grantOperationArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(grantOperationArray.length);
        for (GrantOperation grantOperation : grantOperationArray) {
            sdkInternalList.add(grantOperation.toString());
        }
        if (this.getOperations() == null) {
            this.setOperations(sdkInternalList);
        } else {
            this.getOperations().addAll(sdkInternalList);
        }
        return this;
    }

    public void setConstraints(GrantConstraints grantConstraints) {
        this.constraints = grantConstraints;
    }

    public GrantConstraints getConstraints() {
        return this.constraints;
    }

    public GrantListEntry withConstraints(GrantConstraints grantConstraints) {
        this.setConstraints(grantConstraints);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getGrantId() != null) {
            stringBuilder.append("GrantId: ").append(this.getGrantId()).append(",");
        }
        if (this.getName() != null) {
            stringBuilder.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getCreationDate() != null) {
            stringBuilder.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getGranteePrincipal() != null) {
            stringBuilder.append("GranteePrincipal: ").append(this.getGranteePrincipal()).append(",");
        }
        if (this.getRetiringPrincipal() != null) {
            stringBuilder.append("RetiringPrincipal: ").append(this.getRetiringPrincipal()).append(",");
        }
        if (this.getIssuingAccount() != null) {
            stringBuilder.append("IssuingAccount: ").append(this.getIssuingAccount()).append(",");
        }
        if (this.getOperations() != null) {
            stringBuilder.append("Operations: ").append(this.getOperations()).append(",");
        }
        if (this.getConstraints() != null) {
            stringBuilder.append("Constraints: ").append(this.getConstraints());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GrantListEntry)) {
            return false;
        }
        GrantListEntry grantListEntry = (GrantListEntry)object;
        if (grantListEntry.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (grantListEntry.getKeyId() != null && !grantListEntry.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (grantListEntry.getGrantId() == null ^ this.getGrantId() == null) {
            return false;
        }
        if (grantListEntry.getGrantId() != null && !grantListEntry.getGrantId().equals(this.getGrantId())) {
            return false;
        }
        if (grantListEntry.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (grantListEntry.getName() != null && !grantListEntry.getName().equals(this.getName())) {
            return false;
        }
        if (grantListEntry.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (grantListEntry.getCreationDate() != null && !grantListEntry.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (grantListEntry.getGranteePrincipal() == null ^ this.getGranteePrincipal() == null) {
            return false;
        }
        if (grantListEntry.getGranteePrincipal() != null && !grantListEntry.getGranteePrincipal().equals(this.getGranteePrincipal())) {
            return false;
        }
        if (grantListEntry.getRetiringPrincipal() == null ^ this.getRetiringPrincipal() == null) {
            return false;
        }
        if (grantListEntry.getRetiringPrincipal() != null && !grantListEntry.getRetiringPrincipal().equals(this.getRetiringPrincipal())) {
            return false;
        }
        if (grantListEntry.getIssuingAccount() == null ^ this.getIssuingAccount() == null) {
            return false;
        }
        if (grantListEntry.getIssuingAccount() != null && !grantListEntry.getIssuingAccount().equals(this.getIssuingAccount())) {
            return false;
        }
        if (grantListEntry.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (grantListEntry.getOperations() != null && !grantListEntry.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (grantListEntry.getConstraints() == null ^ this.getConstraints() == null) {
            return false;
        }
        return grantListEntry.getConstraints() == null || grantListEntry.getConstraints().equals(this.getConstraints());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getGrantId() == null ? 0 : this.getGrantId().hashCode());
        n2 = 31 * n2 + (this.getName() == null ? 0 : this.getName().hashCode());
        n2 = 31 * n2 + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        n2 = 31 * n2 + (this.getGranteePrincipal() == null ? 0 : this.getGranteePrincipal().hashCode());
        n2 = 31 * n2 + (this.getRetiringPrincipal() == null ? 0 : this.getRetiringPrincipal().hashCode());
        n2 = 31 * n2 + (this.getIssuingAccount() == null ? 0 : this.getIssuingAccount().hashCode());
        n2 = 31 * n2 + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        n2 = 31 * n2 + (this.getConstraints() == null ? 0 : this.getConstraints().hashCode());
        return n2;
    }

    public GrantListEntry clone() {
        try {
            return (GrantListEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

