/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry.v2;

import com.amazonaws.Request;
import com.amazonaws.SdkBaseException;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.SdkInternalApi;

@Immutable
public class RetryPolicyContext {
    private final Object originalRequest;
    private final Request<?> request;
    private final SdkBaseException exception;
    private final int retriesAttempted;
    private final Integer httpStatusCode;

    private RetryPolicyContext(Object object, Request<?> request, SdkBaseException sdkBaseException, int n, Integer n2) {
        this.originalRequest = object;
        this.request = request;
        this.exception = sdkBaseException;
        this.retriesAttempted = n;
        this.httpStatusCode = n2;
    }

    public Object originalRequest() {
        return this.originalRequest;
    }

    public Request<?> request() {
        return this.request;
    }

    public SdkBaseException exception() {
        return this.exception;
    }

    public int retriesAttempted() {
        return this.retriesAttempted;
    }

    public int totalRequests() {
        return this.retriesAttempted() + 1;
    }

    public Integer httpStatusCode() {
        return this.httpStatusCode;
    }

    @SdkInternalApi
    public static Builder builder() {
        return new Builder();
    }

    @SdkInternalApi
    public static class Builder {
        private Object originalRequest;
        private Request<?> request;
        private SdkBaseException exception;
        private int retriesAttempted;
        private Integer httpStatusCode;

        private Builder() {
        }

        public Builder originalRequest(Object object) {
            this.originalRequest = object;
            return this;
        }

        public Builder request(Request<?> request) {
            this.request = request;
            return this;
        }

        public Builder exception(SdkBaseException sdkBaseException) {
            this.exception = sdkBaseException;
            return this;
        }

        public Builder retriesAttempted(int n) {
            this.retriesAttempted = n;
            return this;
        }

        public Builder httpStatusCode(Integer n) {
            this.httpStatusCode = n;
            return this;
        }

        public RetryPolicyContext build() {
            return new RetryPolicyContext(this.originalRequest, this.request, this.exception, this.retriesAttempted, this.httpStatusCode);
        }
    }
}

