/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class RetryUtils {
    static final Set<String> THROTTLING_ERROR_CODES = new HashSet<String>(9);
    static final Set<String> CLOCK_SKEW_ERROR_CODES = new HashSet<String>(6);
    static final Set<String> RETRYABLE_ERROR_CODES = new HashSet<String>(1);
    static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    public static boolean isRetryableServiceException(SdkBaseException sdkBaseException) {
        return RetryUtils.isAse(sdkBaseException) && RetryUtils.isRetryableServiceException(RetryUtils.toAse(sdkBaseException));
    }

    public static boolean isRetryableServiceException(AmazonServiceException amazonServiceException) {
        return RETRYABLE_STATUS_CODES.contains(amazonServiceException.getStatusCode()) || RETRYABLE_ERROR_CODES.contains(amazonServiceException.getErrorCode()) || RetryUtils.reasonPhraseMatchesErrorCode(amazonServiceException, RETRYABLE_ERROR_CODES);
    }

    public static boolean isThrottlingException(SdkBaseException sdkBaseException) {
        return RetryUtils.isAse(sdkBaseException) && RetryUtils.isThrottlingException(RetryUtils.toAse(sdkBaseException));
    }

    public static boolean isThrottlingException(AmazonServiceException amazonServiceException) {
        return THROTTLING_ERROR_CODES.contains(amazonServiceException.getErrorCode()) || amazonServiceException.getStatusCode() == 429 || RetryUtils.reasonPhraseMatchesErrorCode(amazonServiceException, THROTTLING_ERROR_CODES);
    }

    public static boolean isRequestEntityTooLargeException(SdkBaseException sdkBaseException) {
        return RetryUtils.isAse(sdkBaseException) && RetryUtils.isRequestEntityTooLargeException(RetryUtils.toAse(sdkBaseException));
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException amazonServiceException) {
        return amazonServiceException.getStatusCode() == 413;
    }

    public static boolean isClockSkewError(SdkBaseException sdkBaseException) {
        return RetryUtils.isAse(sdkBaseException) && RetryUtils.isClockSkewError(RetryUtils.toAse(sdkBaseException));
    }

    public static boolean isClockSkewError(AmazonServiceException amazonServiceException) {
        return CLOCK_SKEW_ERROR_CODES.contains(amazonServiceException.getErrorCode()) || RetryUtils.reasonPhraseMatchesErrorCode(amazonServiceException, CLOCK_SKEW_ERROR_CODES);
    }

    private static boolean isAse(SdkBaseException sdkBaseException) {
        return sdkBaseException instanceof AmazonServiceException;
    }

    private static AmazonServiceException toAse(SdkBaseException sdkBaseException) {
        return (AmazonServiceException)sdkBaseException;
    }

    private static boolean reasonPhraseMatchesErrorCode(AmazonServiceException amazonServiceException, Set<String> set) {
        String string;
        String string2 = amazonServiceException.getErrorCode();
        if (string2 != null && string2.startsWith(string = String.valueOf(amazonServiceException.getStatusCode()))) {
            String string3 = string2.substring(string.length());
            string3 = WHITESPACE_PATTERN.matcher(string3).replaceAll("");
            return set.contains(string3);
        }
        return false;
    }

    static {
        THROTTLING_ERROR_CODES.add("Throttling");
        THROTTLING_ERROR_CODES.add("ThrottlingException");
        THROTTLING_ERROR_CODES.add("ThrottledException");
        THROTTLING_ERROR_CODES.add("ProvisionedThroughputExceededException");
        THROTTLING_ERROR_CODES.add("SlowDown");
        THROTTLING_ERROR_CODES.add("TooManyRequestsException");
        THROTTLING_ERROR_CODES.add("RequestLimitExceeded");
        THROTTLING_ERROR_CODES.add("BandwidthLimitExceeded");
        THROTTLING_ERROR_CODES.add("RequestThrottled");
        THROTTLING_ERROR_CODES.add("RequestThrottledException");
        THROTTLING_ERROR_CODES.add("EC2ThrottledException");
        THROTTLING_ERROR_CODES.add("PriorRequestNotComplete");
        CLOCK_SKEW_ERROR_CODES.add("RequestTimeTooSkewed");
        CLOCK_SKEW_ERROR_CODES.add("RequestExpired");
        CLOCK_SKEW_ERROR_CODES.add("InvalidSignatureException");
        CLOCK_SKEW_ERROR_CODES.add("SignatureDoesNotMatch");
        CLOCK_SKEW_ERROR_CODES.add("AuthFailure");
        CLOCK_SKEW_ERROR_CODES.add("RequestInTheFuture");
        RETRYABLE_ERROR_CODES.add("TransactionInProgressException");
        RETRYABLE_ERROR_CODES.add("RequestTimeout");
        RETRYABLE_ERROR_CODES.add("RequestTimeoutException");
        RETRYABLE_ERROR_CODES.add("IDPCommunicationError");
        RETRYABLE_STATUS_CODES.add(500);
        RETRYABLE_STATUS_CODES.add(502);
        RETRYABLE_STATUS_CODES.add(503);
        RETRYABLE_STATUS_CODES.add(504);
    }
}

