/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryMode;
import com.amazonaws.retry.internal.RetryModeResolver;

@Immutable
public final class RetryPolicy {
    private static final RetryModeResolver RETRY_MODE_RESOLVER = new RetryModeResolver();
    private final RetryCondition retryCondition;
    private final BackoffStrategy backoffStrategy;
    private final int maxErrorRetry;
    private final boolean honorMaxErrorRetryInClientConfig;
    private final RetryMode retryMode;
    private final boolean honorDefaultMaxErrorRetryInRetryMode;
    private final boolean fastFailRateLimiting;
    private final boolean honorBackoffStrategyInRetryMode;

    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int n, boolean bl) {
        this(retryCondition, backoffStrategy, n, bl, false, false);
    }

    @SdkInternalApi
    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int n, boolean bl, boolean bl2, boolean bl3) {
        this(retryCondition, backoffStrategy, n, bl, null, bl2, false, bl3);
    }

    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int n, boolean bl, RetryMode retryMode) {
        this(retryCondition, backoffStrategy, n, bl, retryMode, false, false, false);
    }

    private RetryPolicy(RetryPolicyBuilder retryPolicyBuilder) {
        this(retryPolicyBuilder.retryCondition, retryPolicyBuilder.backoffStrategy, retryPolicyBuilder.maxErrorRetry, retryPolicyBuilder.honorMaxErrorRetryInClientConfig, retryPolicyBuilder.retryMode, retryPolicyBuilder.honorDefaultMaxErrorRetryInRetryMode, retryPolicyBuilder.fastFailRateLimiting, retryPolicyBuilder.honorBackOffStrategyInRetryMode);
    }

    @SdkInternalApi
    RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int n, boolean bl, RetryMode retryMode, boolean bl2, boolean bl3, boolean bl4) {
        if (retryCondition == null) {
            retryCondition = PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Please provide a non-negative value for maxErrorRetry.");
        }
        if (backoffStrategy == null) {
            backoffStrategy = PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY;
        }
        this.honorDefaultMaxErrorRetryInRetryMode = bl2;
        this.retryCondition = retryCondition;
        this.maxErrorRetry = n;
        this.honorMaxErrorRetryInClientConfig = bl;
        this.retryMode = retryMode != null ? retryMode : RETRY_MODE_RESOLVER.retryMode();
        this.honorBackoffStrategyInRetryMode = bl4;
        this.backoffStrategy = bl4 ? PredefinedRetryPolicies.getDefaultBackoffStrategy(this.retryMode) : backoffStrategy;
        this.fastFailRateLimiting = bl3;
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public boolean isMaxErrorRetryInClientConfigHonored() {
        return this.honorMaxErrorRetryInClientConfig;
    }

    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    public boolean isFastFailRateLimiting() {
        return this.fastFailRateLimiting;
    }

    boolean isDefaultMaxErrorRetryInRetryModeHonored() {
        return this.honorDefaultMaxErrorRetryInRetryMode;
    }

    boolean isBackoffStrategyInRetryModeHonored() {
        return this.honorBackoffStrategyInRetryMode;
    }

    public static RetryPolicyBuilder builder() {
        return new RetryPolicyBuilder();
    }

    public static interface BackoffStrategy {
        public static final BackoffStrategy NO_DELAY = new BackoffStrategy(){

            @Override
            public long delayBeforeNextRetry(AmazonWebServiceRequest amazonWebServiceRequest, AmazonClientException amazonClientException, int n) {
                return 0L;
            }
        };

        public long delayBeforeNextRetry(AmazonWebServiceRequest var1, AmazonClientException var2, int var3);
    }

    public static interface RetryCondition {
        public static final RetryCondition NO_RETRY_CONDITION = new RetryCondition(){

            @Override
            public boolean shouldRetry(AmazonWebServiceRequest amazonWebServiceRequest, AmazonClientException amazonClientException, int n) {
                return false;
            }
        };

        public boolean shouldRetry(AmazonWebServiceRequest var1, AmazonClientException var2, int var3);
    }

    public static final class RetryPolicyBuilder {
        private RetryCondition retryCondition;
        private BackoffStrategy backoffStrategy;
        private int maxErrorRetry;
        private boolean honorMaxErrorRetryInClientConfig;
        private RetryMode retryMode;
        private boolean honorDefaultMaxErrorRetryInRetryMode;
        private boolean fastFailRateLimiting;
        private boolean honorBackOffStrategyInRetryMode;

        public RetryPolicyBuilder withRetryCondition(RetryCondition retryCondition) {
            this.retryCondition = retryCondition;
            return this;
        }

        public void setRetryCondition(RetryCondition retryCondition) {
            this.withRetryCondition(retryCondition);
        }

        public RetryPolicyBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
            this.withBackoffStrategy(backoffStrategy);
        }

        public RetryPolicyBuilder withMaxErrorRetry(int n) {
            this.maxErrorRetry = n;
            return this;
        }

        public void setMaxErrorRetry(int n) {
            this.withMaxErrorRetry(n);
        }

        public RetryPolicyBuilder withHonorMaxErrorRetryInClientConfig(boolean bl) {
            this.honorMaxErrorRetryInClientConfig = bl;
            return this;
        }

        public void setHonorMaxErrorRetryInClientConfig(boolean bl) {
            this.withHonorMaxErrorRetryInClientConfig(bl);
        }

        public RetryPolicyBuilder withRetryMode(RetryMode retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        public void setRetryMode(RetryMode retryMode) {
            this.withRetryMode(retryMode);
        }

        public RetryPolicyBuilder withHonorDefaultMaxErrorRetryInRetryMode(boolean bl) {
            this.honorDefaultMaxErrorRetryInRetryMode = bl;
            return this;
        }

        public void setHonorDefaultMaxErrorRetryInRetryMode(boolean bl) {
            this.withHonorDefaultMaxErrorRetryInRetryMode(bl);
        }

        public RetryPolicyBuilder withFastFailRateLimiting(boolean bl) {
            this.fastFailRateLimiting = bl;
            return this;
        }

        public void setFastFailRateLimiting(boolean bl) {
            this.withFastFailRateLimiting(bl);
        }

        public RetryPolicyBuilder withHonorDefaultBackoffStrategyInRetryMode(boolean bl) {
            this.honorBackOffStrategyInRetryMode = bl;
            return this;
        }

        public void setHonorDefaultBackoffStrategyInRetryMode(boolean bl) {
            this.withHonorDefaultBackoffStrategyInRetryMode(bl);
        }

        public RetryPolicy build() {
            return new RetryPolicy(this);
        }
    }
}

