/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.InMemoryRegionImpl;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegionMetadataParser {
    private static final Log log = LogFactory.getLog(RegionMetadataParser.class);
    private static final String REGION_TAG = "Region";
    private static final String REGION_ID_TAG = "Name";
    private static final String DOMAIN_TAG = "Domain";
    private static final String ENDPOINT_TAG = "Endpoint";
    private static final String SERVICE_TAG = "ServiceName";
    private static final String HTTP_TAG = "Http";
    private static final String HTTPS_TAG = "Https";
    private static final String HOSTNAME_TAG = "Hostname";

    public static RegionMetadata parse(InputStream inputStream2) throws IOException {
        return new RegionMetadata(RegionMetadataParser.internalParse(inputStream2, false));
    }

    @Deprecated
    public RegionMetadataParser() {
    }

    @Deprecated
    public List<Region> parseRegionMetadata(InputStream inputStream2) throws IOException {
        return RegionMetadataParser.internalParse(inputStream2, false);
    }

    @Deprecated
    public List<Region> parseRegionMetadata(InputStream inputStream2, boolean bl) throws IOException {
        return RegionMetadataParser.internalParse(inputStream2, bl);
    }

    private static List<Region> internalParse(InputStream inputStream2, boolean bl) throws IOException {
        Document document;
        Object object;
        Object object2;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setXIncludeAware(false);
            ((DocumentBuilderFactory)object2).setExpandEntityReferences(false);
            ((DocumentBuilderFactory)object2).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            RegionMetadataParser.configureDocumentBuilderFactory((DocumentBuilderFactory)object2);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unable to parse region metadata file: " + exception.getMessage(), exception);
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
        object2 = document.getElementsByTagName(REGION_TAG);
        object = new ArrayList();
        for (int i = 0; i < object2.getLength(); ++i) {
            Node node = object2.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            object.add(RegionMetadataParser.parseRegionElement(element, bl));
        }
        return object;
    }

    private static Region parseRegionElement(Element element, boolean bl) {
        String string = RegionMetadataParser.getChildElementValue(REGION_ID_TAG, element);
        String string2 = RegionMetadataParser.getChildElementValue(DOMAIN_TAG, element);
        InMemoryRegionImpl inMemoryRegionImpl = new InMemoryRegionImpl(string, string2);
        NodeList nodeList = element.getElementsByTagName(ENDPOINT_TAG);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            RegionMetadataParser.addRegionEndpoint(inMemoryRegionImpl, (Element)nodeList.item(i), bl);
        }
        return new Region(inMemoryRegionImpl);
    }

    private static void addRegionEndpoint(InMemoryRegionImpl inMemoryRegionImpl, Element element, boolean bl) {
        String string = RegionMetadataParser.getChildElementValue(SERVICE_TAG, element);
        String string2 = RegionMetadataParser.getChildElementValue(HOSTNAME_TAG, element);
        String string3 = RegionMetadataParser.getChildElementValue(HTTP_TAG, element);
        String string4 = RegionMetadataParser.getChildElementValue(HTTPS_TAG, element);
        if (bl && !RegionMetadataParser.verifyLegacyEndpoint(string2)) {
            throw new IllegalStateException("Invalid service endpoint (" + string2 + ") is detected.");
        }
        inMemoryRegionImpl.addEndpoint(string, string2);
        if (Boolean.valueOf(string3).booleanValue()) {
            inMemoryRegionImpl.addHttp(string);
        }
        if (Boolean.valueOf(string4).booleanValue()) {
            inMemoryRegionImpl.addHttps(string);
        }
    }

    private static String getChildElementValue(String string, Element element) {
        Node node = element.getElementsByTagName(string).item(0);
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = nodeList.item(0);
        return node2.getNodeValue();
    }

    private static boolean verifyLegacyEndpoint(String string) {
        return string.endsWith(".amazonaws.com");
    }

    private static boolean isXerces(DocumentBuilderFactory documentBuilderFactory) {
        String string = documentBuilderFactory.getClass().getCanonicalName();
        return string.startsWith("org.apache.xerces.") || string.startsWith("com.sun.org.apache.xerces.");
    }

    private static void configureDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        try {
            if (RegionMetadataParser.isXerces(documentBuilderFactory)) {
                documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            } else {
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
        }
        catch (Throwable throwable) {
            log.warn("Unable to configure DocumentBuilderFactory to protect against XXE attacks", throwable);
        }
    }
}

