/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.RegionImpl;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.ValidationUtils;
import java.lang.reflect.Constructor;
import java.util.Collection;

public class Region {
    private final RegionImpl regionImpl;

    public Region(RegionImpl regionImpl) {
        ValidationUtils.assertNotNull(regionImpl, "region implementation");
        this.regionImpl = regionImpl;
    }

    public static Region getRegion(Regions regions) {
        return RegionUtils.getRegion(regions.getName());
    }

    public String getName() {
        return this.regionImpl.getName();
    }

    public String getDomain() {
        return this.regionImpl.getDomain();
    }

    public String getPartition() {
        return this.regionImpl.getPartition();
    }

    public String getServiceEndpoint(String string) {
        return this.regionImpl.getServiceEndpoint(string);
    }

    public boolean isServiceSupported(String string) {
        return this.regionImpl.isServiceSupported(string);
    }

    public boolean hasHttpsEndpoint(String string) {
        return this.regionImpl.hasHttpsEndpoint(string);
    }

    public boolean hasHttpEndpoint(String string) {
        return this.regionImpl.hasHttpEndpoint(string);
    }

    public Collection<String> getAvailableEndpoints() {
        return this.regionImpl.getAvailableEndpoints();
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T createClient(Class<T> clazz, AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        try {
            AmazonWebServiceClient amazonWebServiceClient;
            if (aWSCredentialsProvider == null && clientConfiguration == null) {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(new Object[0]);
            } else if (aWSCredentialsProvider == null) {
                Constructor<T> constructor = clazz.getConstructor(ClientConfiguration.class);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(clientConfiguration);
            } else if (clientConfiguration == null) {
                Constructor<T> constructor = clazz.getConstructor(AWSCredentialsProvider.class);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(aWSCredentialsProvider);
            } else {
                Constructor<T> constructor = clazz.getConstructor(AWSCredentialsProvider.class, ClientConfiguration.class);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(aWSCredentialsProvider, clientConfiguration);
            }
            amazonWebServiceClient.setRegion(this);
            return (T)amazonWebServiceClient;
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't instantiate instance of " + clazz, exception);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.getName().equals(region.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

