/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.config.Builder;
import com.amazonaws.regions.LegacyRegionXmlLoadUtils;
import com.amazonaws.regions.RegionMetadata;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class LegacyRegionXmlMetadataBuilder
implements Builder<RegionMetadata> {
    private static final String REGIONS_FILE_OVERRIDE = "com.amazonaws.regions.RegionUtils.fileOverride";
    private static final String OVERRIDE_ENDPOINTS_RESOURCE_PATH = "/com/amazonaws/regions/override/regions.xml";
    private static final Log LOG = LogFactory.getLog(LegacyRegionXmlMetadataBuilder.class);

    @Override
    public RegionMetadata build() {
        return this.loadOverrideMetadataIfExists();
    }

    private RegionMetadata loadOverrideMetadataIfExists() {
        InputStream inputStream2;
        RegionMetadata regionMetadata = this.loadFromSystemProperty();
        if (regionMetadata == null && (inputStream2 = RegionUtils.class.getResourceAsStream(OVERRIDE_ENDPOINTS_RESOURCE_PATH)) != null) {
            regionMetadata = this.loadFromStream(inputStream2);
            IOUtils.closeQuietly(inputStream2, LOG);
        }
        return regionMetadata;
    }

    private RegionMetadata loadFromSystemProperty() {
        String string = System.getProperty(REGIONS_FILE_OVERRIDE);
        if (string != null) {
            try {
                return LegacyRegionXmlLoadUtils.load(new File(string));
            }
            catch (IOException iOException) {
                throw new SdkClientException("Error parsing region metadata from " + string, iOException);
            }
        }
        return null;
    }

    private RegionMetadata loadFromStream(InputStream inputStream2) {
        try {
            return LegacyRegionXmlLoadUtils.load(inputStream2);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Error parsing region metadata from input stream", iOException);
        }
    }
}

