/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import java.nio.charset.Charset;
import java.util.Date;

@SdkInternalApi
public class ValueToStringConverters {
    public static final ValueToString<String> FROM_STRING = new ValueToString<String>(){

        @Override
        public String convert(String string) {
            return string;
        }
    };
    public static final ValueToString<Integer> FROM_INTEGER = new ValueToString<Integer>(){

        @Override
        public String convert(Integer n) {
            return StringUtils.fromInteger(n);
        }
    };
    public static final ValueToString<Long> FROM_LONG = new ValueToString<Long>(){

        @Override
        public String convert(Long l) {
            return StringUtils.fromLong(l);
        }
    };
    public static final ValueToString<Short> FROM_SHORT = new ValueToString<Short>(){

        @Override
        public String convert(Short s2) {
            return StringUtils.fromShort(s2);
        }
    };
    public static final ValueToString<Float> FROM_FLOAT = new ValueToString<Float>(){

        @Override
        public String convert(Float f) {
            return StringUtils.fromFloat(f);
        }
    };
    public static final ValueToString<Double> FROM_DOUBLE = new ValueToString<Double>(){

        @Override
        public String convert(Double d) {
            return StringUtils.fromDouble(d);
        }
    };
    public static final ValueToString<Boolean> FROM_BOOLEAN = new ValueToString<Boolean>(){

        @Override
        public String convert(Boolean bl) {
            return StringUtils.fromBoolean(bl);
        }
    };
    public static final ValueToString<Date> FROM_DATE = new ValueToString<Date>(){

        @Override
        public String convert(Date date) {
            return StringUtils.fromDate(date);
        }
    };
    public static final ValueToString<String> FROM_JSON_VALUE_HEADER = new ValueToString<String>(){

        @Override
        public String convert(String string) {
            return Base64.encodeAsString(string.getBytes(Charset.forName("utf-8")));
        }
    };

    public static interface ValueToString<T> {
        public String convert(T var1);
    }
}

