/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.TimestampFormat;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;

@SdkInternalApi
public class SdkJsonGenerator
implements StructuredJsonGenerator {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private final JsonGenerator generator;
    private final String contentType;

    public SdkJsonGenerator(JsonFactory jsonFactory, String string) {
        try {
            this.generator = jsonFactory.createGenerator(this.baos);
            this.contentType = string;
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
    }

    @Override
    public StructuredJsonGenerator writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndArray() {
        try {
            this.generator.writeEndArray();
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndObject() {
        try {
            this.generator.writeEndObject();
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeFieldName(String string) {
        try {
            this.generator.writeFieldName(string);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(String string) {
        try {
            this.generator.writeString(string);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(boolean bl) {
        try {
            this.generator.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(long l) {
        try {
            this.generator.writeNumber(l);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(double d) {
        try {
            this.generator.writeNumber(d);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(float f) {
        try {
            this.generator.writeNumber(f);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(short s2) {
        try {
            this.generator.writeNumber(s2);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(int n) {
        try {
            this.generator.writeNumber(n);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(ByteBuffer byteBuffer) {
        try {
            this.generator.writeBinary(BinaryUtils.copyBytesFrom(byteBuffer));
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(Date date, TimestampFormat timestampFormat) {
        try {
            switch (timestampFormat) {
                case UNIX_TIMESTAMP_IN_MILLIS: {
                    this.generator.writeNumber(DateUtils.formatUnixTimestampInMills(date));
                    break;
                }
                case ISO_8601: {
                    this.generator.writeString(DateUtils.formatISO8601Date(date));
                    break;
                }
                case RFC_822: {
                    this.generator.writeString(DateUtils.formatRFC822Date(date));
                    break;
                }
                default: {
                    this.generator.writeNumber(DateUtils.formatServiceSpecificDate(date));
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigDecimal bigDecimal) {
        try {
            this.generator.writeString(bigDecimal.toString());
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigInteger bigInteger) {
        try {
            this.generator.writeNumber(bigInteger);
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
        return this;
    }

    private void close() {
        try {
            this.generator.close();
        }
        catch (IOException iOException) {
            throw new JsonGenerationException(iOException);
        }
    }

    @Override
    public byte[] getBytes() {
        this.close();
        return this.baos.toByteArray();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    protected JsonGenerator getGenerator() {
        return this.generator;
    }

    public static class JsonGenerationException
    extends SdkClientException {
        public JsonGenerationException(Throwable throwable) {
            super(throwable);
        }
    }
}

