/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class JsonContent {
    private static final Log LOG = LogFactory.getLog(JsonContent.class);
    private final byte[] rawContent;
    private final JsonNode jsonNode;

    public static JsonContent createJsonContent(HttpResponse httpResponse, JsonFactory jsonFactory) {
        byte[] byArray = null;
        try {
            if (httpResponse.getContent() != null) {
                byArray = IOUtils.toByteArray(httpResponse.getContent());
            }
        }
        catch (Exception exception) {
            LOG.debug("Unable to read HTTP response content", exception);
        }
        return new JsonContent(byArray, new ObjectMapper(jsonFactory).configure(JsonParser.Feature.ALLOW_COMMENTS, true));
    }

    public JsonContent(byte[] byArray, JsonNode jsonNode) {
        this.rawContent = byArray;
        this.jsonNode = jsonNode;
    }

    private JsonContent(byte[] byArray, ObjectMapper objectMapper) {
        this.rawContent = byArray;
        this.jsonNode = JsonContent.parseJsonContent(byArray, objectMapper);
    }

    private static JsonNode parseJsonContent(byte[] byArray, ObjectMapper objectMapper) {
        if (byArray == null) {
            return objectMapper.createObjectNode();
        }
        try {
            JsonNode jsonNode = objectMapper.readTree(byArray);
            if (jsonNode.isMissingNode()) {
                return objectMapper.createObjectNode();
            }
            return jsonNode;
        }
        catch (Exception exception) {
            LOG.debug("Unable to parse HTTP response content", exception);
            return objectMapper.createObjectNode();
        }
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

