/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.partitions.model;

import com.amazonaws.Protocol;
import com.amazonaws.partitions.model.CredentialScope;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;

public class Endpoint {
    private String hostName;
    private CredentialScope credentialScope;
    private Set<String> protocols;
    private Set<String> signatureVersions;
    private String sslCommonName;

    public static Endpoint merge(Endpoint endpoint, Endpoint endpoint2) {
        if (endpoint == null) {
            endpoint = new Endpoint();
        }
        if (endpoint2 == null) {
            endpoint2 = new Endpoint();
        }
        Endpoint endpoint3 = new Endpoint();
        endpoint3.setCredentialScope(endpoint2.getCredentialScope() != null ? endpoint2.getCredentialScope() : endpoint.getCredentialScope());
        endpoint3.setHostName(endpoint2.getHostName() != null ? endpoint2.getHostName() : endpoint.getHostName());
        endpoint3.setSslCommonName(endpoint2.getSslCommonName() != null ? endpoint2.getSslCommonName() : endpoint.getSslCommonName());
        endpoint3.setProtocols(endpoint2.getProtocols() != null ? endpoint2.getProtocols() : endpoint.getProtocols());
        endpoint3.setSignatureVersions(endpoint2.getSignatureVersions() != null ? endpoint2.getSignatureVersions() : endpoint.getSignatureVersions());
        return endpoint3;
    }

    public String getHostName() {
        return this.hostName;
    }

    @JsonProperty(value="hostname")
    public void setHostName(String string) {
        this.hostName = string;
    }

    public CredentialScope getCredentialScope() {
        return this.credentialScope;
    }

    @JsonProperty(value="credentialScope")
    public void setCredentialScope(CredentialScope credentialScope) {
        this.credentialScope = credentialScope;
    }

    public Set<String> getProtocols() {
        return this.protocols;
    }

    @JsonProperty(value="protocols")
    public void setProtocols(Set<String> set) {
        this.protocols = set;
    }

    public Set<String> getSignatureVersions() {
        return this.signatureVersions;
    }

    @JsonProperty(value="signatureVersions")
    public void setSignatureVersions(Set<String> set) {
        this.signatureVersions = set;
    }

    public String getSslCommonName() {
        return this.sslCommonName;
    }

    @JsonProperty(value="sslCommonName")
    public void setSslCommonName(String string) {
        this.sslCommonName = string;
    }

    public boolean hasHttpsSupport() {
        return this.isProtocolSupported(Protocol.HTTPS);
    }

    public boolean hasHttpSupport() {
        return this.isProtocolSupported(Protocol.HTTP);
    }

    private boolean isProtocolSupported(Protocol protocol) {
        return this.protocols != null && this.protocols.contains(protocol.toString());
    }
}

