/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.partitions;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.partitions.PartitionRegionImpl;
import com.amazonaws.partitions.model.Endpoint;
import com.amazonaws.partitions.model.Partition;
import com.amazonaws.partitions.model.Region;
import com.amazonaws.partitions.model.Service;
import com.amazonaws.regions.AbstractRegionMetadataProvider;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private static final String STANDARD_PARTITION_HOSTNAME = "{service}.{region}.{dnsSuffix}";
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.amazonaws.regions.Region> credentialScopeRegionByHost = new HashMap<String, com.amazonaws.regions.Region>();
    private final Set<String> standardHostnamePatternDnsSuffixes = new HashSet<String>();
    private final Map<String, com.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, com.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> list) {
        ValidationUtils.assertNotNull(list, "partitions");
        for (Partition partition : list) {
            this.partitionMap.put(partition.getPartition(), partition);
            if (partition.getDefaults() != null && STANDARD_PARTITION_HOSTNAME.equals(partition.getDefaults().getHostName())) {
                this.standardHostnamePatternDnsSuffixes.add(partition.getDnsSuffix());
            }
            for (Service service : partition.getServices().values()) {
                for (Endpoint endpoint : service.getEndpoints().values()) {
                    if (endpoint.getHostName() == null || endpoint.getCredentialScope() == null || endpoint.getCredentialScope().getRegion() == null) continue;
                    com.amazonaws.regions.Region region = this.cacheRegion(new PartitionRegionImpl(endpoint.getCredentialScope().getRegion(), partition));
                    this.credentialScopeRegionByHost.put(endpoint.getHostName(), region);
                }
            }
        }
    }

    @Override
    public List<com.amazonaws.regions.Region> getRegions() {
        ArrayList<com.amazonaws.regions.Region> arrayList = new ArrayList<com.amazonaws.regions.Region>();
        for (Partition partition : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : partition.getRegions().entrySet()) {
                arrayList.add(new com.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), partition)));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public com.amazonaws.regions.Region getRegion(String string) {
        if (string == null) {
            return null;
        }
        com.amazonaws.regions.Region region = this.getRegionFromCache(string);
        if (region != null) {
            return region;
        }
        return this.createNewRegion(string);
    }

    private com.amazonaws.regions.Region createNewRegion(String string) {
        for (Partition partition : this.partitionMap.values()) {
            if (!partition.hasRegion(string)) continue;
            return this.cacheRegion(new PartitionRegionImpl(string, partition));
        }
        Partition partition = this.partitionMap.get("aws");
        if (partition != null) {
            return this.cacheRegion(new PartitionRegionImpl(string, partition));
        }
        return null;
    }

    private com.amazonaws.regions.Region getRegionFromCache(String string) {
        return this.regionCache.get(string);
    }

    private com.amazonaws.regions.Region cacheRegion(PartitionRegionImpl partitionRegionImpl) {
        com.amazonaws.regions.Region region = new com.amazonaws.regions.Region(partitionRegionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.amazonaws.regions.Region> getRegionsForService(String string) {
        List<com.amazonaws.regions.Region> list = this.getRegions();
        ArrayList<com.amazonaws.regions.Region> arrayList = new ArrayList<com.amazonaws.regions.Region>();
        for (com.amazonaws.regions.Region region : list) {
            if (!region.isServiceSupported(string)) continue;
            arrayList.add(region);
        }
        return arrayList;
    }

    @Override
    public com.amazonaws.regions.Region tryGetRegionByExplicitEndpoint(String string) {
        String string2 = PartitionMetadataProvider.getHost(string);
        return this.credentialScopeRegionByHost.get(string2);
    }

    @Override
    public com.amazonaws.regions.Region tryGetRegionByEndpointDnsSuffix(String string) {
        String string2 = PartitionMetadataProvider.getHost(string);
        for (String string3 : this.standardHostnamePatternDnsSuffixes) {
            string3 = "." + string3;
            if (!string2.endsWith(string3)) continue;
            String string4 = string2.substring(0, string2.length() - string3.length());
            String string5 = string4.substring(string4.lastIndexOf(46) + 1);
            if (string5.isEmpty()) {
                return null;
            }
            return this.getRegion(string5);
        }
        return null;
    }
}

