/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.monitoring.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.Response;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.handlers.HandlerAfterAttemptContext;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.timers.client.ClientExecutionTimeoutException;
import com.amazonaws.monitoring.ApiCallAttemptMonitoringEvent;
import com.amazonaws.monitoring.ApiCallMonitoringEvent;
import com.amazonaws.monitoring.MonitoringEvent;
import com.amazonaws.monitoring.MonitoringListener;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AwsClientSideMonitoringMetrics;
import com.amazonaws.util.CollectionUtils;
import com.amazonaws.util.ImmutableMapParameter;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.Throwables;
import com.amazonaws.util.TimingInfo;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public final class ClientSideMonitoringRequestHandler
extends RequestHandler2 {
    private static final Log LOG = LogFactory.getLog(ClientSideMonitoringRequestHandler.class);
    private static final String X_AMZN_REQUEST_ID_HEADER_KEY = "x-amzn-RequestId";
    private static final String X_AMZ_REQUEST_ID_HEADER_KEY = "x-amz-request-id";
    private static final String X_AMZ_REQUEST_ID_2_HEADER_KEY = "x-amz-id-2";
    private static final String EXCEPTION_MESSAGE_KEY = "ExceptionMessage";
    private static final String EXCEPTION_KEY = "Exception";
    private static final String CLIENT_ID_KEY = "ClientId";
    private static final String USER_AGENT_KEY = "UserAgent";
    private static final HandlerContextKey<ApiCallAttemptMonitoringEvent> LAST_CALL_ATTEMPT = new HandlerContextKey("LastCallAttemptMonitoringEvent");
    private static final Integer VERSION = 1;
    private static final List<String> SECURITY_TOKENS = Arrays.asList("x-amz-security-token", "X-Amz-Security-Token");
    private static final Map<String, Integer> ENTRY_TO_MAX_SIZE = new ImmutableMapParameter.Builder<String, Integer>().put("ClientId", 255).put("UserAgent", 256).put("ExceptionMessage", 512).put("Exception", 128).build();
    private final String clientId;
    private final Collection<MonitoringListener> monitoringListeners;

    public ClientSideMonitoringRequestHandler(String string, Collection<MonitoringListener> collection) {
        this.clientId = this.trimValueIfExceedsMaxLength(CLIENT_ID_KEY, string);
        this.monitoringListeners = collection;
    }

    @Override
    public void afterAttempt(HandlerAfterAttemptContext handlerAfterAttemptContext) {
        ApiCallAttemptMonitoringEvent apiCallAttemptMonitoringEvent = this.generateApiCallAttemptMonitoringEvent(handlerAfterAttemptContext);
        handlerAfterAttemptContext.getRequest().addHandlerContext(LAST_CALL_ATTEMPT, apiCallAttemptMonitoringEvent);
        this.handToMonitoringListeners(apiCallAttemptMonitoringEvent);
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
        ApiCallMonitoringEvent apiCallMonitoringEvent = this.generateApiCallMonitoringEvent(request);
        this.handToMonitoringListeners(apiCallMonitoringEvent);
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception exception) {
        ApiCallMonitoringEvent apiCallMonitoringEvent = this.generateApiCallMonitoringEvent(request, exception);
        this.handToMonitoringListeners(apiCallMonitoringEvent);
    }

    private ApiCallAttemptMonitoringEvent generateApiCallAttemptMonitoringEvent(HandlerAfterAttemptContext handlerAfterAttemptContext) {
        Request<?> request = handlerAfterAttemptContext.getRequest();
        AWSRequestMetrics aWSRequestMetrics = handlerAfterAttemptContext.getRequest().getAWSRequestMetrics();
        String string = request.getHandlerContext(HandlerContextKey.OPERATION_NAME);
        String string2 = request.getHandlerContext(HandlerContextKey.SERVICE_ID);
        String string3 = this.getSessionToken(request.getHeaders());
        String string4 = request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
        String string5 = null;
        if (request.getHandlerContext(HandlerContextKey.AWS_CREDENTIALS) != null) {
            string5 = request.getHandlerContext(HandlerContextKey.AWS_CREDENTIALS).getAWSAccessKeyId();
        }
        String string6 = this.extractFqdn(request.getEndpoint());
        TimingInfo timingInfo = aWSRequestMetrics == null ? null : aWSRequestMetrics.getTimingInfo();
        Long l = null;
        Long l2 = null;
        if (timingInfo != null && timingInfo.getLastSubMeasurement(AWSRequestMetrics.Field.HttpRequestTime.name()) != null) {
            TimingInfo timingInfo2 = timingInfo.getLastSubMeasurement(AWSRequestMetrics.Field.HttpRequestTime.name());
            l = timingInfo2.getStartEpochTimeMilliIfKnown();
            l2 = this.convertToLongIfNotNull(timingInfo2.getTimeTakenMillisIfKnown());
        }
        ApiCallAttemptMonitoringEvent apiCallAttemptMonitoringEvent = new ApiCallAttemptMonitoringEvent().withFqdn(string6).withVersion(VERSION).withService(string2).withClientId(this.clientId).withRegion(string4).withAccessKey(string5).withUserAgent(this.trimValueIfExceedsMaxLength(USER_AGENT_KEY, this.getDefaultUserAgent(request))).withTimestamp(l).withAttemptLatency(l2).withSessionToken(string3).withApi(string);
        this.addConditionalFieldsToAttemptEvent(aWSRequestMetrics, handlerAfterAttemptContext, apiCallAttemptMonitoringEvent);
        return apiCallAttemptMonitoringEvent;
    }

    private ApiCallMonitoringEvent generateApiCallMonitoringEvent(Request<?> request) {
        Object object;
        String string = request.getHandlerContext(HandlerContextKey.OPERATION_NAME);
        String string2 = request.getHandlerContext(HandlerContextKey.SERVICE_ID);
        String string3 = request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
        ApiCallAttemptMonitoringEvent apiCallAttemptMonitoringEvent = request.getHandlerContext(LAST_CALL_ATTEMPT);
        Long l = null;
        Long l2 = null;
        Integer n = 0;
        AWSRequestMetrics aWSRequestMetrics = request.getAWSRequestMetrics();
        if (aWSRequestMetrics != null) {
            object = aWSRequestMetrics.getTimingInfo();
            n = ((TimingInfo)object).getCounter(AWSRequestMetrics.Field.RequestCount.name()) == null ? 0 : ((TimingInfo)object).getCounter(AWSRequestMetrics.Field.RequestCount.name()).intValue();
            TimingInfo timingInfo = ((TimingInfo)object).getSubMeasurement(AwsClientSideMonitoringMetrics.ApiCallLatency.name());
            if (timingInfo != null) {
                l2 = this.convertToLongIfNotNull(timingInfo.getTimeTakenMillisIfKnown());
                l = timingInfo.getStartEpochTimeMilliIfKnown();
            }
        }
        object = new ApiCallMonitoringEvent().withApi(string).withVersion(VERSION).withRegion(string3).withService(string2).withClientId(this.clientId).withAttemptCount(n).withLatency(l2).withUserAgent(this.trimValueIfExceedsMaxLength(USER_AGENT_KEY, this.getDefaultUserAgent(request))).withTimestamp(l);
        if (apiCallAttemptMonitoringEvent != null) {
            ((ApiCallMonitoringEvent)object).withFinalAwsException(apiCallAttemptMonitoringEvent.getAwsException()).withFinalAwsExceptionMessage(apiCallAttemptMonitoringEvent.getAwsExceptionMessage()).withFinalSdkException(apiCallAttemptMonitoringEvent.getSdkException()).withFinalSdkExceptionMessage(apiCallAttemptMonitoringEvent.getSdkExceptionMessage()).withFinalHttpStatusCode(apiCallAttemptMonitoringEvent.getHttpStatusCode());
        }
        return object;
    }

    private ApiCallMonitoringEvent generateApiCallMonitoringEvent(Request<?> request, Exception exception) {
        ApiCallMonitoringEvent apiCallMonitoringEvent = this.generateApiCallMonitoringEvent(request);
        AWSRequestMetrics aWSRequestMetrics = request.getAWSRequestMetrics();
        if (exception instanceof ClientExecutionTimeoutException) {
            apiCallMonitoringEvent.withApiCallTimeout(1);
        }
        if (aWSRequestMetrics != null && !CollectionUtils.isNullOrEmpty(aWSRequestMetrics.getProperty(AwsClientSideMonitoringMetrics.MaxRetriesExceeded))) {
            boolean bl = (Boolean)aWSRequestMetrics.getProperty(AwsClientSideMonitoringMetrics.MaxRetriesExceeded).get(0);
            apiCallMonitoringEvent.withMaxRetriesExceeded(bl ? 1 : 0);
        }
        return apiCallMonitoringEvent;
    }

    private void addConditionalFieldsToAttemptEvent(AWSRequestMetrics aWSRequestMetrics, HandlerAfterAttemptContext handlerAfterAttemptContext, ApiCallAttemptMonitoringEvent apiCallAttemptMonitoringEvent) {
        TimingInfo timingInfo = aWSRequestMetrics == null ? null : aWSRequestMetrics.getTimingInfo();
        Response<?> response = handlerAfterAttemptContext.getResponse();
        Integer n = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Long l = null;
        Map<String, String> map = null;
        if (response != null && response.getHttpResponse() != null) {
            map = response.getHttpResponse().getHeaders();
            n = response.getHttpResponse().getStatusCode();
            l = this.calculateRequestLatency(timingInfo);
        } else if (handlerAfterAttemptContext.getException() instanceof AmazonServiceException) {
            map = ((AmazonServiceException)handlerAfterAttemptContext.getException()).getHttpHeaders();
            n = this.extractHttpStatusCode((AmazonServiceException)handlerAfterAttemptContext.getException());
            l = this.calculateRequestLatency(timingInfo);
        }
        if (map != null) {
            string = map.get(X_AMZN_REQUEST_ID_HEADER_KEY);
            string2 = map.get(X_AMZ_REQUEST_ID_HEADER_KEY);
            string3 = map.get(X_AMZ_REQUEST_ID_2_HEADER_KEY);
        }
        apiCallAttemptMonitoringEvent.withXAmznRequestId(string).withXAmzRequestId(string2).withXAmzId2(string3).withHttpStatusCode(n).withRequestLatency(l);
        this.addException(handlerAfterAttemptContext.getException(), apiCallAttemptMonitoringEvent);
    }

    private void handToMonitoringListeners(MonitoringEvent monitoringEvent) {
        for (MonitoringListener monitoringListener : this.monitoringListeners) {
            try {
                monitoringListener.handleEvent(monitoringEvent);
            }
            catch (Exception exception) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("MonitoringListener: %s failed to handle event", monitoringListener.toString()), exception);
            }
        }
    }

    private String extractFqdn(URI uRI) {
        if (uRI == null) {
            return null;
        }
        return uRI.getHost();
    }

    private String trimValueIfExceedsMaxLength(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        Integer n = ENTRY_TO_MAX_SIZE.get(string);
        if (n != null && string2.length() > n) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }

    private String getDefaultUserAgent(Request<?> request) {
        String string = request.getOriginalRequest().getRequestClientOptions().getClientMarker(RequestClientOptions.Marker.USER_AGENT);
        String string2 = ClientConfiguration.DEFAULT_USER_AGENT;
        if (StringUtils.hasValue(string)) {
            string2 = string2 + " " + string;
        }
        return string2;
    }

    private String getSessionToken(Map<String, String> map) {
        for (String string : SECURITY_TOKENS) {
            if (map.get(string) == null) continue;
            return map.get(string);
        }
        return null;
    }

    private Long convertToLongIfNotNull(Double d) {
        if (d == null) {
            return null;
        }
        return d.longValue();
    }

    private Long calculateRequestLatency(TimingInfo timingInfo) {
        if (timingInfo == null) {
            return null;
        }
        TimingInfo timingInfo2 = timingInfo.getLastSubMeasurement(AWSRequestMetrics.Field.HttpClientSendRequestTime.name());
        TimingInfo timingInfo3 = timingInfo.getLastSubMeasurement(AWSRequestMetrics.Field.HttpClientReceiveResponseTime.name());
        if (timingInfo2 != null && timingInfo2.getTimeTakenMillisIfKnown() != null && timingInfo3 != null && timingInfo3.getTimeTakenMillisIfKnown() != null) {
            return timingInfo2.getTimeTakenMillisIfKnown().longValue() + timingInfo3.getTimeTakenMillisIfKnown().longValue();
        }
        return null;
    }

    private void addException(Exception exception, ApiCallAttemptMonitoringEvent apiCallAttemptMonitoringEvent) {
        if (exception == null) {
            return;
        }
        if (exception instanceof AmazonServiceException) {
            String string = ((AmazonServiceException)exception).getErrorCode();
            String string2 = ((AmazonServiceException)exception).getErrorMessage();
            apiCallAttemptMonitoringEvent.withAwsException(this.trimValueIfExceedsMaxLength(EXCEPTION_KEY, string));
            apiCallAttemptMonitoringEvent.withAwsExceptionMessage(this.trimValueIfExceedsMaxLength(EXCEPTION_MESSAGE_KEY, string2));
        } else {
            String string = exception.getClass().getName();
            String string3 = this.getRootCauseMessage(exception);
            apiCallAttemptMonitoringEvent.withSdkException(this.trimValueIfExceedsMaxLength(EXCEPTION_KEY, string));
            apiCallAttemptMonitoringEvent.withSdkExceptionMessage(this.trimValueIfExceedsMaxLength(EXCEPTION_MESSAGE_KEY, string3));
        }
    }

    private String getRootCauseMessage(Exception exception) {
        if (exception.getMessage() != null) {
            return exception.getMessage();
        }
        return Throwables.getRootCause(exception).getMessage();
    }

    private int extractHttpStatusCode(AmazonServiceException amazonServiceException) {
        return amazonServiceException.getStatusCode();
    }
}

