/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.monitoring;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.monitoring.CsmConfiguration;
import com.amazonaws.monitoring.CsmConfigurationProvider;

@ThreadSafe
public final class SystemPropertyCsmConfigurationProvider
implements CsmConfigurationProvider {
    @Override
    public CsmConfiguration getConfiguration() throws SdkClientException {
        String string = System.getProperty("com.amazonaws.sdk.csm.enabled");
        if (string == null) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!");
        }
        String string2 = System.getProperty("com.amazonaws.sdk.csm.host", "127.0.0.1");
        String string3 = System.getProperty("com.amazonaws.sdk.csm.port");
        String string4 = System.getProperty("com.amazonaws.sdk.csm.clientId", "");
        try {
            int n = string3 == null ? 31000 : Integer.parseInt(string3);
            return CsmConfiguration.builder().withEnabled(Boolean.parseBoolean(string)).withHost(string2).withPort(n).withClientId(string4).build();
        }
        catch (Exception exception) {
            throw new SdkClientException("Unable to load Client Side Monitoring configurations from system properties variables!", exception);
        }
    }
}

