/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.metrics.ByteThroughputHelper;
import com.amazonaws.metrics.ThroughputMetricType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public class MetricInputStreamEntity
extends InputStreamEntity {
    private static final int BUFFER_SIZE = 2048;
    private final ByteThroughputHelper helper;

    public MetricInputStreamEntity(ThroughputMetricType throughputMetricType, InputStream inputStream2, long l) {
        super(inputStream2, l);
        this.helper = new ByteThroughputHelper(throughputMetricType);
    }

    public MetricInputStreamEntity(ThroughputMetricType throughputMetricType, InputStream inputStream2, long l, ContentType contentType) {
        super(inputStream2, l, contentType);
        this.helper = new ByteThroughputHelper(throughputMetricType);
    }

    @Override
    public void writeTo(OutputStream outputStream2) throws IOException {
        MetricAware metricAware;
        if (outputStream2 instanceof MetricAware && (metricAware = (MetricAware)((Object)outputStream2)).isMetricActivated()) {
            super.writeTo(outputStream2);
            return;
        }
        this.writeToWithMetrics(outputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToWithMetrics(OutputStream outputStream2) throws IOException {
        block8: {
            if (outputStream2 == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            InputStream inputStream2 = this.getContent();
            long l = this.getContentLength();
            InputStream inputStream3 = inputStream2;
            try {
                int n;
                byte[] byArray = new byte[2048];
                if (l < 0L) {
                    int n2;
                    while ((n2 = inputStream3.read(byArray)) != -1) {
                        long l2 = this.helper.startTiming();
                        outputStream2.write(byArray, 0, n2);
                        this.helper.increment(n2, l2);
                    }
                    break block8;
                }
                for (long i = l; i > 0L; i -= (long)n) {
                    n = inputStream3.read(byArray, 0, (int)Math.min(2048L, i));
                    if (n == -1) {
                        break;
                    }
                    long l3 = this.helper.startTiming();
                    outputStream2.write(byArray, 0, n);
                    this.helper.increment(n, l3);
                }
            }
            finally {
                this.helper.reportMetrics();
                inputStream3.close();
            }
        }
    }
}

