/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.metrics.ByteThroughputHelper;
import com.amazonaws.metrics.ThroughputMetricType;
import java.io.IOException;
import java.io.InputStream;

public class MetricFilterInputStream
extends SdkFilterInputStream {
    private final ByteThroughputHelper helper;

    public MetricFilterInputStream(ThroughputMetricType throughputMetricType, InputStream inputStream2) {
        super(inputStream2);
        this.helper = new ByteThroughputHelper(throughputMetricType);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.abortIfNeeded();
        long l = this.helper.startTiming();
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.helper.increment(n3, l);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.helper.reportMetrics();
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public final boolean isMetricActivated() {
        return true;
    }
}

