/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;

@SdkInternalApi
public class TokenBucket {
    private static final double MIN_FILL_RATE = 0.5;
    private static final double MIN_CAPACITY = 1.0;
    private static final double SMOOTH = 0.8;
    private static final double BETA = 0.7;
    private static final double SCALE_CONSTANT = 0.4;
    private final Clock clock;
    private Double fillRate;
    private Double maxCapacity;
    private double currentCapacity;
    private Double lastTimestamp;
    private boolean enabled;
    private double measuredTxRate;
    private double lastTxRateBucket;
    private long requestCount;
    private double lastMaxRate;
    private double lastThrottleTime;
    private double timeWindow;

    public TokenBucket() {
        this.clock = new DefaultClock();
        this.initialize();
    }

    @SdkTestInternalApi
    TokenBucket(Clock clock) {
        this.clock = clock;
        this.initialize();
    }

    public boolean acquire(double d) {
        return this.acquire(d, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(double d, boolean bl) {
        double d2 = 0.0;
        TokenBucket tokenBucket = this;
        synchronized (tokenBucket) {
            if (!this.enabled) {
                return true;
            }
            this.refill();
            double d3 = this.currentCapacity;
            double d4 = this.tryAcquireCapacity(d);
            if (d4 > 0.0 && bl) {
                this.currentCapacity = d3;
                return false;
            }
            if (d4 > 0.0) {
                d2 = d4 / this.fillRate;
            }
        }
        if (d2 > 0.0) {
            this.sleep(d2);
        }
        return true;
    }

    double tryAcquireCapacity(double d) {
        double d2 = d <= this.currentCapacity ? 0.0 : d - this.currentCapacity;
        this.currentCapacity -= d;
        return d2;
    }

    private void initialize() {
        this.fillRate = null;
        this.maxCapacity = null;
        this.currentCapacity = 0.0;
        this.lastTimestamp = null;
        this.enabled = false;
        this.measuredTxRate = 0.0;
        this.lastTxRateBucket = Math.floor(this.clock.time());
        this.requestCount = 0L;
        this.lastMaxRate = 0.0;
        this.lastThrottleTime = this.clock.time();
    }

    synchronized void refill() {
        double d = this.clock.time();
        if (this.lastTimestamp == null) {
            this.lastTimestamp = d;
            return;
        }
        double d2 = (d - this.lastTimestamp) * this.fillRate;
        this.currentCapacity = Math.min(this.maxCapacity, this.currentCapacity + d2);
        this.lastTimestamp = d;
    }

    private synchronized void updateRate(double d) {
        this.refill();
        this.fillRate = Math.max(d, 0.5);
        this.maxCapacity = Math.max(d, 1.0);
        this.currentCapacity = Math.min(this.currentCapacity, this.maxCapacity);
    }

    private synchronized void updateMeasuredRate() {
        double d = this.clock.time();
        double d2 = Math.floor(d * 2.0) / 2.0;
        ++this.requestCount;
        if (d2 > this.lastTxRateBucket) {
            double d3 = (double)this.requestCount / (d2 - this.lastTxRateBucket);
            this.measuredTxRate = d3 * 0.8 + this.measuredTxRate * 0.19999999999999996;
            this.requestCount = 0L;
            this.lastTxRateBucket = d2;
        }
    }

    synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void updateClientSendingRate(boolean bl) {
        double d;
        double d2;
        this.updateMeasuredRate();
        if (bl) {
            d2 = !this.enabled ? this.measuredTxRate : Math.min(this.measuredTxRate, this.fillRate);
            this.lastMaxRate = d2;
            this.calculateTimeWindow();
            this.lastThrottleTime = this.clock.time();
            d = this.cubicThrottle(d2);
            this.enable();
        } else {
            this.calculateTimeWindow();
            d = this.cubicSuccess(this.clock.time());
        }
        d2 = Math.min(d, 2.0 * this.measuredTxRate);
        this.updateRate(d2);
    }

    synchronized void calculateTimeWindow() {
        this.timeWindow = Math.pow(this.lastMaxRate * 0.30000000000000004 / 0.4, 0.3333333333333333);
    }

    void sleep(double d) {
        long l = (long)(d * 1000.0);
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    double cubicThrottle(double d) {
        double d2 = d * 0.7;
        return d2;
    }

    synchronized double cubicSuccess(double d) {
        double d2 = d - this.lastThrottleTime;
        double d3 = 0.4 * Math.pow(d2 - this.timeWindow, 3.0) + this.lastMaxRate;
        return d3;
    }

    @SdkTestInternalApi
    synchronized void setLastMaxRate(double d) {
        this.lastMaxRate = d;
    }

    @SdkTestInternalApi
    synchronized void setLastThrottleTime(double d) {
        this.lastThrottleTime = d;
    }

    @SdkTestInternalApi
    synchronized double getMeasuredTxRate() {
        return this.measuredTxRate;
    }

    @SdkTestInternalApi
    synchronized double getFillRate() {
        return this.fillRate;
    }

    @SdkTestInternalApi
    synchronized void setCurrentCapacity(double d) {
        this.currentCapacity = d;
    }

    @SdkTestInternalApi
    synchronized double getCurrentCapacity() {
        return this.currentCapacity;
    }

    @SdkTestInternalApi
    synchronized void setFillRate(double d) {
        this.fillRate = d;
    }

    static class DefaultClock
    implements Clock {
        DefaultClock() {
        }

        @Override
        public double time() {
            long l = System.nanoTime();
            return (double)l / 1.0E9;
        }
    }

    public static interface Clock {
        public double time();
    }
}

