/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.internal.DelegateSSLSocket;
import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdkSSLSocket
extends DelegateSSLSocket {
    private static final Log log = LogFactory.getLog(SdkSSLSocket.class);

    public SdkSSLSocket(SSLSocket sSLSocket) {
        super(sSLSocket);
        if (log.isDebugEnabled()) {
            log.debug("created: " + this.endpoint());
        }
    }

    private String endpoint() {
        return this.sock.getInetAddress() + ":" + this.sock.getPort();
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("connecting to: " + socketAddress);
        }
        this.sock.connect(socketAddress);
        if (log.isDebugEnabled()) {
            log.debug("connected to: " + this.endpoint());
        }
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("connecting to: " + socketAddress);
        }
        this.sock.connect(socketAddress, n);
        if (log.isDebugEnabled()) {
            log.debug("connected to: " + this.endpoint());
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("closing " + this.endpoint());
        }
        this.sock.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("shutting down input of " + this.endpoint());
        }
        this.sock.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("shutting down output of " + this.endpoint());
        }
        this.sock.shutdownOutput();
    }
}

