/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AbortedException;
import com.amazonaws.internal.MetricAware;
import com.amazonaws.internal.Releasable;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.SdkRuntime;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public abstract class SdkInputStream
extends InputStream
implements MetricAware,
Releasable {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream inputStream2 = this.getWrappedInputStream();
        if (inputStream2 instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)inputStream2);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException iOException) {
                LogFactory.getLog(this.getClass()).debug("FYI", iOException);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream inputStream2 = this.getWrappedInputStream();
        if (inputStream2 instanceof Releasable) {
            Releasable releasable = (Releasable)((Object)inputStream2);
            releasable.release();
        }
    }
}

