/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.internal.ConnectionUtils;
import com.amazonaws.internal.EC2ResourceFetcher;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.amazonaws.util.EC2MetadataUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public final class InstanceMetadataServiceResourceFetcher
extends EC2ResourceFetcher {
    private static final Log LOG = LogFactory.getLog(InstanceMetadataServiceResourceFetcher.class);
    private static final String EC2_TOKEN_ROOT = "/latest/api/token";
    private static final String TOKEN_TTL_HEADER = "x-aws-ec2-metadata-token-ttl-seconds";
    private static final String TOKEN_HEADER = "x-aws-ec2-metadata-token";
    private static final String DEFAULT_TOKEN_TTL = "21600";

    private InstanceMetadataServiceResourceFetcher() {
    }

    @SdkTestInternalApi
    InstanceMetadataServiceResourceFetcher(ConnectionUtils connectionUtils) {
        super(connectionUtils);
    }

    public static InstanceMetadataServiceResourceFetcher getInstance() {
        return InstanceMetadataServiceResourceFetcherHolder.INSTANCE;
    }

    @Override
    public String readResource(URI uRI, CredentialsEndpointRetryPolicy credentialsEndpointRetryPolicy, Map<String, String> map) {
        if (SDKGlobalConfiguration.isEc2MetadataDisabled()) {
            throw new AmazonClientException("EC2 Instance Metadata Service is disabled");
        }
        Map<String, String> map2 = this.addDefaultHeaders(map);
        String string = this.getToken();
        if (string != null) {
            map2.put(TOKEN_HEADER, string);
        }
        return this.doReadResource(uRI, credentialsEndpointRetryPolicy, map2);
    }

    private String getToken() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TOKEN_TTL_HEADER, DEFAULT_TOKEN_TTL);
        String string = null;
        String string2 = EC2MetadataUtils.getHostAddressForEC2MetadataService();
        try {
            string = this.doReadResource(URI.create(string2 + EC2_TOKEN_ROOT), CredentialsEndpointRetryPolicy.NO_RETRY, hashMap, "PUT");
        }
        catch (SdkClientException sdkClientException) {
            this.handleException(sdkClientException);
        }
        return string;
    }

    private void handleException(SdkClientException sdkClientException) {
        if (this.isTokenUnsupported(sdkClientException)) {
            LOG.debug("Token is not supported. Ignoring ");
            return;
        }
        LOG.warn("Fail to retrieve token ", sdkClientException);
        throw sdkClientException;
    }

    private boolean isTokenUnsupported(SdkClientException sdkClientException) {
        if (sdkClientException instanceof AmazonServiceException) {
            AmazonServiceException amazonServiceException = (AmazonServiceException)sdkClientException;
            return amazonServiceException.getStatusCode() != 400 && !this.isRetryable(amazonServiceException.getCause()) && !this.isRetryable(amazonServiceException.getStatusCode());
        }
        return sdkClientException.getCause() instanceof SocketTimeoutException || sdkClientException.getMessage().contains("The requested metadata is not found at ");
    }

    private boolean isRetryable(int n) {
        return n >= 500 && n < 600;
    }

    private boolean isRetryable(Throwable throwable) {
        return throwable instanceof IOException;
    }

    private static final class InstanceMetadataServiceResourceFetcherHolder {
        private static final InstanceMetadataServiceResourceFetcher INSTANCE = new InstanceMetadataServiceResourceFetcher();

        private InstanceMetadataServiceResourceFetcherHolder() {
        }
    }
}

