/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.util.VersionInfoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class EC2MetadataClient {
    private static final String EC2_METADATA_SERVICE_URL = "http://169.254.169.254";
    public static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    private static final Log log = LogFactory.getLog(EC2MetadataClient.class);
    private static final String USER_AGENT = String.format("aws-sdk-java/%s", VersionInfoUtils.getVersion());

    public String getDefaultCredentials() throws IOException {
        String string = this.readResource(SECURITY_CREDENTIALS_RESOURCE);
        String[] stringArray = (string = string.trim()).split("\n");
        if (stringArray.length == 0) {
            return null;
        }
        String string2 = stringArray[0];
        return this.readResource(SECURITY_CREDENTIALS_RESOURCE + string2);
    }

    public String readResource(String string) throws IOException, SdkClientException {
        URL uRL = this.getEc2MetadataServiceUrlForResource(string);
        log.debug("Connecting to EC2 instance metadata service at URL: " + uRL.toString());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(2000);
        httpURLConnection.setReadTimeout(5000);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.addRequestProperty("User-Agent", USER_AGENT);
        httpURLConnection.connect();
        return this.readResponse(httpURLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpURLConnection httpURLConnection) throws IOException {
        if (httpURLConnection.getResponseCode() == 404) {
            throw new SdkClientException("The requested metadata is not found at " + httpURLConnection.getURL());
        }
        try (InputStream inputStream2 = httpURLConnection.getInputStream();){
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = inputStream2.read()) != -1) {
                stringBuilder.append((char)n);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    private URL getEc2MetadataServiceUrlForResource(String string) throws IOException {
        String string2 = EC2_METADATA_SERVICE_URL;
        if (System.getProperty("com.amazonaws.sdk.ec2MetadataServiceEndpointOverride") != null) {
            string2 = System.getProperty("com.amazonaws.sdk.ec2MetadataServiceEndpointOverride");
        }
        return new URL(string2 + string);
    }
}

