/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn;

import com.amazonaws.http.conn.Wrapped;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.ServiceLatencyProvider;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.util.AWSServiceMetrics;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionRequest;

class ClientConnectionRequestFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionRequestFactory.class);
    private static final Class<?>[] interfaces = new Class[]{ConnectionRequest.class, Wrapped.class};

    ClientConnectionRequestFactory() {
    }

    static ConnectionRequest wrap(ConnectionRequest connectionRequest) {
        if (connectionRequest instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        return (ConnectionRequest)Proxy.newProxyInstance(ClientConnectionRequestFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(connectionRequest));
    }

    private static class Handler
    implements InvocationHandler {
        private final ConnectionRequest orig;

        Handler(ConnectionRequest connectionRequest) {
            this.orig = connectionRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (!"get".equals(method.getName())) return method.invoke((Object)this.orig, objectArray);
            ServiceLatencyProvider serviceLatencyProvider = new ServiceLatencyProvider(AWSServiceMetrics.HttpClientGetConnectionTime);
            try {
                Object object2 = method.invoke((Object)this.orig, objectArray);
                ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(serviceLatencyProvider.endTiming());
                return object2;
            }
            catch (Throwable throwable) {
                try {
                    ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(serviceLatencyProvider.endTiming());
                    throw throwable;
                }
                catch (InvocationTargetException invocationTargetException) {
                    log.debug("", invocationTargetException);
                    throw invocationTargetException.getCause();
                }
            }
        }
    }
}

