/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.request.impl;

import com.amazonaws.ProxyAuthenticationMethod;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.RepeatableInputStreamRequestEntity;
import com.amazonaws.http.apache.request.impl.HttpGetWithBody;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.http.request.HttpRequestFactory;
import com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.util.FakeIOException;
import com.amazonaws.util.SdkHttpUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public class ApacheHttpRequestFactory
implements HttpRequestFactory<HttpRequestBase> {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String QUERY_PARAM_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=" + "UTF-8".toLowerCase();
    private static final List<String> ignoreHeaders = Arrays.asList("Content-Length", "Host");

    @Override
    public HttpRequestBase create(Request<?> request, HttpClientSettings httpClientSettings) throws FakeIOException {
        HttpRequestBase httpRequestBase;
        String string = this.getUriEndpoint(request);
        String string2 = SdkHttpUtils.encodeParameters(request);
        if (this.shouldMoveQueryParametersToBody(request, string2)) {
            httpRequestBase = this.createPostParamsInBodyRequest(string, string2);
            this.addHeadersToRequest(httpRequestBase, request);
            this.addContentTypeHeaderIfNeeded(httpRequestBase);
        } else {
            if (string2 != null) {
                string = string + "?" + string2;
            }
            httpRequestBase = this.createStandardRequest(request, string);
            this.addHeadersToRequest(httpRequestBase, request);
        }
        this.addRequestConfig(httpRequestBase, request, httpClientSettings);
        return httpRequestBase;
    }

    private String getUriEndpoint(Request<?> request) {
        URI uRI = request.getEndpoint();
        if (request.getOriginalRequest().getRequestClientOptions().isSkipAppendUriPath()) {
            return uRI.toString();
        }
        return SdkHttpUtils.appendUri(uRI.toString(), request.getResourcePath(), true);
    }

    private void addRequestConfig(HttpRequestBase httpRequestBase, Request<?> request, HttpClientSettings httpClientSettings) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(httpClientSettings.getConnectionPoolRequestTimeout()).setConnectTimeout(httpClientSettings.getConnectionTimeout()).setSocketTimeout(httpClientSettings.getSocketTimeout()).setLocalAddress(httpClientSettings.getLocalAddress());
        ApacheUtils.disableNormalizeUri(builder);
        if (HttpMethodName.PUT == request.getHttpMethod() && httpClientSettings.isUseExpectContinue()) {
            builder.setExpectContinueEnabled(true);
        }
        this.addProxyConfig(builder, httpClientSettings);
        httpRequestBase.setConfig(builder.build());
    }

    private HttpRequestBase createStandardRequest(Request<?> request, String string) throws FakeIOException {
        switch (request.getHttpMethod()) {
            case HEAD: {
                return new HttpHead(string);
            }
            case GET: {
                return this.wrapEntity(request, new HttpGetWithBody(string));
            }
            case DELETE: {
                return new HttpDelete(string);
            }
            case OPTIONS: {
                return new HttpOptions(string);
            }
            case PATCH: {
                return this.wrapEntity(request, new HttpPatch(string));
            }
            case POST: {
                return this.wrapEntity(request, new HttpPost(string));
            }
            case PUT: {
                return this.wrapEntity(request, new HttpPut(string));
            }
        }
        throw new SdkClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
    }

    private HttpRequestBase wrapEntity(Request<?> request, HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase) throws FakeIOException {
        if (HttpMethodName.POST == request.getHttpMethod()) {
            this.createHttpEntityForPostVerb(request, httpEntityEnclosingRequestBase);
        } else if (request.getContent() != null) {
            this.createHttpEntityForNonPostVerbs(request, httpEntityEnclosingRequestBase);
        }
        return httpEntityEnclosingRequestBase;
    }

    private void createHttpEntityForPostVerb(Request<?> request, HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase) throws FakeIOException {
        HttpEntity httpEntity = new RepeatableInputStreamRequestEntity(request);
        if (request.getHeaders().get("Content-Length") == null && this.isRequiresLength(request)) {
            httpEntity = ApacheUtils.newBufferedHttpEntity(httpEntity);
        }
        httpEntityEnclosingRequestBase.setEntity(httpEntity);
    }

    private void createHttpEntityForNonPostVerbs(Request<?> request, HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase) throws FakeIOException {
        HttpEntity httpEntity = new RepeatableInputStreamRequestEntity(request);
        if (request.getHeaders().get("Content-Length") == null && (this.isRequiresLength(request) || !this.hasStreamingInput(request))) {
            httpEntity = ApacheUtils.newBufferedHttpEntity(httpEntity);
        }
        httpEntityEnclosingRequestBase.setEntity(httpEntity);
    }

    private boolean isRequiresLength(Request<?> request) {
        return Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.REQUIRES_LENGTH));
    }

    private boolean hasStreamingInput(Request<?> request) {
        return Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT));
    }

    private void addHeadersToRequest(HttpRequestBase httpRequestBase, Request<?> request) {
        httpRequestBase.addHeader("Host", this.getHostHeaderValue(request.getEndpoint()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (ignoreHeaders.contains(entry.getKey())) continue;
            httpRequestBase.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private boolean shouldMoveQueryParametersToBody(Request<?> request, String string) {
        boolean bl = request.getHttpMethod() == HttpMethodName.POST;
        return bl && request.getContent() == null && string != null;
    }

    private HttpRequestBase createPostParamsInBodyRequest(String string, String string2) {
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity(ApacheUtils.newStringEntity(string2));
        return httpPost;
    }

    private void addContentTypeHeaderIfNeeded(HttpRequestBase httpRequestBase) {
        if (httpRequestBase.getHeaders("Content-Type") == null || httpRequestBase.getHeaders("Content-Type").length == 0) {
            httpRequestBase.addHeader("Content-Type", QUERY_PARAM_CONTENT_TYPE);
        }
    }

    private String getHostHeaderValue(URI uRI) {
        return SdkHttpUtils.isUsingNonDefaultPort(uRI) ? uRI.getHost() + ":" + uRI.getPort() : uRI.getHost();
    }

    private void addProxyConfig(RequestConfig.Builder builder, HttpClientSettings httpClientSettings) {
        if (httpClientSettings.isProxyEnabled() && httpClientSettings.isAuthenticatedProxy() && httpClientSettings.getProxyAuthenticationMethods() != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ProxyAuthenticationMethod proxyAuthenticationMethod : httpClientSettings.getProxyAuthenticationMethods()) {
                arrayList.add(this.toApacheAuthenticationScheme(proxyAuthenticationMethod));
            }
            builder.setProxyPreferredAuthSchemes(arrayList);
        }
    }

    private String toApacheAuthenticationScheme(ProxyAuthenticationMethod proxyAuthenticationMethod) {
        if (proxyAuthenticationMethod == null) {
            throw new IllegalStateException("The configured proxy authentication methods must not be null.");
        }
        switch (proxyAuthenticationMethod) {
            case NTLM: {
                return "NTLM";
            }
            case BASIC: {
                return "Basic";
            }
            case DIGEST: {
                return "Digest";
            }
            case SPNEGO: {
                return "Negotiate";
            }
            case KERBEROS: {
                return "Kerberos";
            }
        }
        throw new IllegalStateException("Unknown authentication scheme: " + (Object)((Object)proxyAuthenticationMethod));
    }
}

