/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.http.AbstractFileTlsKeyManagersProvider;
import com.amazonaws.util.ValidationUtils;
import java.io.File;
import javax.net.ssl.KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileStoreTlsKeyManagersProvider
extends AbstractFileTlsKeyManagersProvider {
    private static final Log log = LogFactory.getLog(FileStoreTlsKeyManagersProvider.class);
    private final File storePath;
    private final String storeType;
    private final char[] password;

    public FileStoreTlsKeyManagersProvider(File file, String string, String string2) {
        this.storePath = ValidationUtils.assertNotNull(file, "storePath");
        this.storeType = ValidationUtils.assertStringNotEmpty(string, "storeType");
        this.password = string2 != null ? string2.toCharArray() : null;
    }

    @Override
    public KeyManager[] getKeyManagers() {
        try {
            return this.createKeyManagers(this.storePath, this.storeType, this.password);
        }
        catch (Exception exception) {
            if (log.isWarnEnabled()) {
                log.warn(String.format("Unable to create KeyManagers from file %s", this.storePath.getAbsolutePath()), exception);
            }
            return null;
        }
    }
}

