/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SdkProtectedApi
public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private Map<String, Unmarshaller<AmazonServiceException, Node>> unmarshallerMap;
    private Unmarshaller<AmazonServiceException, Node> defaultUnmarshaller;
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(Map<String, Unmarshaller<AmazonServiceException, Node>> map, Unmarshaller<AmazonServiceException, Node> unmarshaller) {
        this.unmarshallerMap = map;
        this.defaultUnmarshaller = unmarshaller;
    }

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> list) {
        this.unmarshallerList = list;
    }

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        AmazonServiceException amazonServiceException = this.createAse(httpResponse);
        if (amazonServiceException == null) {
            throw new SdkClientException("Unable to unmarshall error response from service");
        }
        amazonServiceException.setHttpHeaders(httpResponse.getHeaders());
        if (StringUtils.isNullOrEmpty(amazonServiceException.getErrorCode())) {
            amazonServiceException.setErrorCode(httpResponse.getStatusCode() + " " + httpResponse.getStatusText());
        }
        return amazonServiceException;
    }

    private AmazonServiceException createAse(HttpResponse httpResponse) throws Exception {
        Document document = this.documentFromContent(httpResponse.getContent(), this.idString(httpResponse));
        return this.unmarshallerMap != null ? this.exceptionFromMappedUnmarshallers(httpResponse, document) : this.getExceptionFromList(httpResponse, document);
    }

    private AmazonServiceException exceptionFromMappedUnmarshallers(HttpResponse httpResponse, Document document) throws Exception {
        Unmarshaller<AmazonServiceException, Node> unmarshaller = null;
        String string = this.parseErrorCodeFromResponse(document);
        if (string != null) {
            unmarshaller = this.unmarshallerMap.get(string);
        }
        Unmarshaller<AmazonServiceException, Node> unmarshaller2 = unmarshaller != null ? unmarshaller : this.defaultUnmarshaller;
        return unmarshaller2 != null ? this.getAmazonServiceException(httpResponse, document, unmarshaller2) : null;
    }

    private String parseErrorCodeFromResponse(Document document) throws XPathExpressionException {
        String string = XpathUtils.asString("Response/Errors/Error/Code", document);
        if (string == null) {
            string = XpathUtils.asString("ErrorResponse/Error/Code", document);
        }
        return string;
    }

    private AmazonServiceException getExceptionFromList(HttpResponse httpResponse, Document document) throws Exception {
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException amazonServiceException = this.getAmazonServiceException(httpResponse, document, unmarshaller);
            if (amazonServiceException == null) continue;
            return amazonServiceException;
        }
        return null;
    }

    private AmazonServiceException getAmazonServiceException(HttpResponse httpResponse, Document document, Unmarshaller<AmazonServiceException, Node> unmarshaller) throws Exception {
        AmazonServiceException amazonServiceException = unmarshaller.unmarshall(document);
        if (amazonServiceException != null) {
            amazonServiceException.setStatusCode(httpResponse.getStatusCode());
            return amazonServiceException;
        }
        return null;
    }

    private Document documentFromContent(InputStream inputStream2, String string) throws ParserConfigurationException, SAXException, IOException {
        try {
            return this.parseXml(this.contentToString(inputStream2, string), string);
        }
        catch (Exception exception) {
            return XpathUtils.documentFrom("<empty/>");
        }
    }

    private String contentToString(InputStream inputStream2, String string) throws Exception {
        try {
            return IOUtils.toString(inputStream2);
        }
        catch (Exception exception) {
            log.debug(String.format("Unable to read input stream to string (%s)", string), exception);
            throw exception;
        }
    }

    private Document parseXml(String string, String string2) throws Exception {
        try {
            return XpathUtils.documentFrom(string);
        }
        catch (Exception exception) {
            log.debug(String.format("Unable to parse HTTP response (%s) content to XML document '%s' ", string2, string), exception);
            throw exception;
        }
    }

    private String idString(HttpResponse httpResponse) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (httpResponse.getRequest().getHeaders().containsKey("amz-sdk-invocation-id")) {
                stringBuilder.append("Invocation Id:").append(httpResponse.getRequest().getHeaders().get("amz-sdk-invocation-id"));
            }
            if (httpResponse.getHeaders().containsKey("x-amzn-RequestId")) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("Request Id:").append(httpResponse.getHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (NullPointerException nullPointerException) {
            log.debug("Error getting Request or Invocation ID from response", nullPointerException);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : "Unknown";
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

