/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.handlers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.handlers.HandlerAfterAttemptContext;
import com.amazonaws.handlers.HandlerBeforeAttemptContext;
import com.amazonaws.handlers.IRequestHandler2;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ThreadSafe
public class StackedRequestHandler
implements IRequestHandler2 {
    private final List<RequestHandler2> inOrderRequestHandlers;
    private final List<RequestHandler2> reverseOrderRequestHandlers;

    public StackedRequestHandler(RequestHandler2 ... requestHandler2Array) {
        this(Arrays.asList((Object[])ValidationUtils.assertNotNull(requestHandler2Array, "requestHandlers")));
    }

    public StackedRequestHandler(List<RequestHandler2> list) {
        this.inOrderRequestHandlers = ValidationUtils.assertNotNull(list, "requestHandlers");
        this.reverseOrderRequestHandlers = new ArrayList<RequestHandler2>(list);
        Collections.reverse(this.reverseOrderRequestHandlers);
    }

    @Override
    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest amazonWebServiceRequest) {
        AmazonWebServiceRequest amazonWebServiceRequest2 = amazonWebServiceRequest;
        for (RequestHandler2 requestHandler2 : this.inOrderRequestHandlers) {
            amazonWebServiceRequest2 = requestHandler2.beforeExecution(amazonWebServiceRequest2);
        }
        return amazonWebServiceRequest2;
    }

    @Override
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest amazonWebServiceRequest) {
        AmazonWebServiceRequest amazonWebServiceRequest2 = amazonWebServiceRequest;
        for (RequestHandler2 requestHandler2 : this.inOrderRequestHandlers) {
            amazonWebServiceRequest2 = requestHandler2.beforeMarshalling(amazonWebServiceRequest2);
        }
        return amazonWebServiceRequest2;
    }

    @Override
    public void beforeRequest(Request<?> request) {
        for (RequestHandler2 requestHandler2 : this.inOrderRequestHandlers) {
            requestHandler2.beforeRequest(request);
        }
    }

    @Override
    public void beforeAttempt(HandlerBeforeAttemptContext handlerBeforeAttemptContext) {
        for (RequestHandler2 requestHandler2 : this.inOrderRequestHandlers) {
            requestHandler2.beforeAttempt(handlerBeforeAttemptContext);
        }
    }

    @Override
    public HttpResponse beforeUnmarshalling(Request<?> request, HttpResponse httpResponse) {
        HttpResponse httpResponse2 = httpResponse;
        for (RequestHandler2 requestHandler2 : this.reverseOrderRequestHandlers) {
            httpResponse2 = requestHandler2.beforeUnmarshalling(request, httpResponse2);
        }
        return httpResponse2;
    }

    @Override
    public void afterAttempt(HandlerAfterAttemptContext handlerAfterAttemptContext) {
        for (RequestHandler2 requestHandler2 : this.reverseOrderRequestHandlers) {
            requestHandler2.afterAttempt(handlerAfterAttemptContext);
        }
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
        for (RequestHandler2 requestHandler2 : this.reverseOrderRequestHandlers) {
            requestHandler2.afterResponse(request, response);
        }
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception exception) {
        for (RequestHandler2 requestHandler2 : this.reverseOrderRequestHandlers) {
            requestHandler2.afterError(request, response, exception);
        }
    }
}

