/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.handlers;

import com.amazonaws.AmazonClientException;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.util.ClassLoaderHelper;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class HandlerChainFactory {
    private static final String GLOBAL_HANDLER_PATH = "com/amazonaws/global/handlers/request.handler2s";

    public List<RequestHandler2> newRequestHandlerChain(String string) {
        return this.createRequestHandlerChain(string, RequestHandler.class);
    }

    public List<RequestHandler2> newRequestHandler2Chain(String string) {
        return this.createRequestHandlerChain(string, RequestHandler2.class);
    }

    public List<RequestHandler2> getGlobalHandlers() {
        ArrayList<RequestHandler2> arrayList = new ArrayList<RequestHandler2>();
        BufferedReader bufferedReader = null;
        try {
            ArrayList<URL> arrayList2 = Collections.list(this.getGlobalHandlerResources());
            for (URL uRL : arrayList2) {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), StringUtils.UTF8));
                while ((string = bufferedReader.readLine()) != null) {
                    RequestHandler2 requestHandler2 = this.createRequestHandler(string, RequestHandler2.class);
                    if (requestHandler2 == null) continue;
                    arrayList.add(requestHandler2);
                }
            }
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to instantiate request handler chain for client: " + exception.getMessage(), exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    private Enumeration<URL> getGlobalHandlerResources() throws IOException {
        if (HandlerChainFactory.class.getClassLoader() == null) {
            return ClassLoader.getSystemResources(GLOBAL_HANDLER_PATH);
        }
        return HandlerChainFactory.class.getClassLoader().getResources(GLOBAL_HANDLER_PATH);
    }

    private RequestHandler2 createRequestHandler(String string, Class<?> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if ((string = string.trim()).equals("")) {
            return null;
        }
        Class<?> clazz2 = ClassLoaderHelper.loadClass(string, clazz, this.getClass());
        Object obj = clazz2.newInstance();
        if (clazz.isInstance(obj)) {
            if (clazz == RequestHandler2.class) {
                return (RequestHandler2)obj;
            }
            if (clazz == RequestHandler.class) {
                return RequestHandler2.adapt((RequestHandler)obj);
            }
            throw new IllegalStateException();
        }
        throw new AmazonClientException("Unable to instantiate request handler chain for client.  Listed request handler ('" + string + "') does not implement the " + clazz + " API.");
    }

    private List<RequestHandler2> createRequestHandlerChain(String string, Class<?> clazz) {
        ArrayList<RequestHandler2> arrayList = new ArrayList<RequestHandler2>();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            InputStream inputStream2 = this.getClass().getResourceAsStream(string);
            if (inputStream2 == null) {
                ArrayList<RequestHandler2> arrayList2 = arrayList;
                return arrayList2;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            while ((string2 = bufferedReader.readLine()) != null) {
                RequestHandler2 requestHandler2 = this.createRequestHandler(string2, clazz);
                if (requestHandler2 == null) continue;
                arrayList.add(requestHandler2);
            }
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to instantiate request handler chain for client: " + exception.getMessage(), exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }
}

